/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.rdbms.operate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.drill.metastore.operate.AbstractRead;
import org.apache.drill.metastore.operate.MetadataTypeValidator;
import org.apache.drill.metastore.rdbms.RdbmsMetastoreContext;
import org.apache.drill.metastore.rdbms.exception.RdbmsMetastoreException;
import org.apache.drill.metastore.rdbms.transform.MetadataMapper;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.exception.DataAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbmsRead<T>
extends AbstractRead<T> {
    private static final Logger logger = LoggerFactory.getLogger(RdbmsRead.class);
    private final RdbmsMetastoreContext<T> context;

    public RdbmsRead(MetadataTypeValidator metadataTypeValidator, RdbmsMetastoreContext<T> context) {
        super(metadataTypeValidator);
        this.context = context;
    }

    protected List<T> internalExecute() {
        Set<MetadataMapper<T, Record>> mappers = this.context.transformer().toMappers(this.metadataTypes);
        if (mappers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> units = new ArrayList<T>();
        try (DSLContext executor = this.context.executorProvider().executor();){
            for (MetadataMapper<T, Record> mapper : mappers) {
                Condition condition = mapper.toCondition(this.filter);
                logger.debug("Query data from RDBMS Metastore table {} using condition: {}", mapper.table(), (Object)condition);
                List<Field<?>> fields = this.columns.isEmpty() ? Arrays.asList(mapper.table().fields()) : mapper.toFields(this.columns);
                try {
                    if (fields.isEmpty()) {
                        units.addAll(this.countRecords(executor, mapper, condition));
                        continue;
                    }
                    units.addAll(this.queryRecords(executor, mapper, fields, condition));
                }
                catch (DataAccessException e) {
                    throw new RdbmsMetastoreException("Error when reading data from Metastore: " + e.getMessage(), e);
                }
            }
            ArrayList<T> arrayList = units;
            return arrayList;
        }
    }

    private List<T> countRecords(DSLContext executor, MetadataMapper<T, ? extends Record> mapper, Condition condition) throws DataAccessException {
        Integer recordsNumber = (Integer)((Record1)executor.selectCount().from(mapper.table()).where(condition).fetchOne()).value1();
        return recordsNumber == null || recordsNumber == 0 ? Collections.emptyList() : IntStream.range(0, recordsNumber).mapToObj(i -> mapper.emptyUnit()).collect(Collectors.toList());
    }

    private List<T> queryRecords(DSLContext executor, MetadataMapper<T, ? extends Record> mapper, List<Field<?>> fields, Condition condition) throws DataAccessException {
        Result records = executor.select(fields).from(mapper.table()).where(condition).fetchInto(mapper.table());
        return records.stream().map(mapper::toUnit).collect(Collectors.toList());
    }
}

