/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.ProgressListener;
import java.io.IOException;
import java.io.InputStream;

class ProgressInputStream
extends InputStream {
    private final InputStream stream;
    private final ProgressListener listener;
    private long total;
    private long totalRead;
    private int progress;

    ProgressInputStream(InputStream stream, ProgressListener listener, long total) {
        this.stream = stream;
        this.listener = listener;
        this.total = total;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public int read() throws IOException {
        int read = this.stream.read();
        ++this.totalRead;
        this.listener.onProgressChanged(this.totalRead, this.total);
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.stream.read(b, off, len);
        this.totalRead += (long)read;
        this.listener.onProgressChanged(this.totalRead, this.total);
        return read;
    }
}

