/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxGroup;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUser;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

@BoxResourceType(value="collaboration")
public class BoxCollaboration
extends BoxResource {
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "item", "accessible_by", "role", "expires_at", "can_view_path", "status", "acknowledged_at", "created_by", "created_at", "modified_at"};
    public static final URLTemplate COLLABORATIONS_URL_TEMPLATE = new URLTemplate("collaborations");
    public static final URLTemplate PENDING_COLLABORATIONS_URL = new URLTemplate("collaborations?status=pending");
    public static final URLTemplate COLLABORATION_URL_TEMPLATE = new URLTemplate("collaborations/%s");
    public static final URLTemplate GET_ALL_FILE_COLLABORATIONS_URL = new URLTemplate("files/%s/collaborations");

    public BoxCollaboration(BoxAPIConnection api, String id) {
        super(api, id);
    }

    protected static Info create(BoxAPIConnection api, JsonObject accessibleBy, JsonObject item, Role role, Boolean notify, Boolean canViewPath) {
        return BoxCollaboration.create(api, accessibleBy, item, role, notify, canViewPath, null);
    }

    protected static Info create(BoxAPIConnection api, JsonObject accessibleBy, JsonObject item, Role role, Boolean notify, Boolean canViewPath, Date expiresAt) {
        BoxCollaboration newCollaboration;
        String queryString = "";
        if (notify != null) {
            queryString = new QueryStringBuilder().appendParam("notify", notify.toString()).toString();
        }
        URL url = queryString.length() > 0 ? COLLABORATIONS_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), queryString, new Object[0]) : COLLABORATIONS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("item", (JsonValue)item);
        requestJSON.add("accessible_by", (JsonValue)accessibleBy);
        requestJSON.add("role", role.toJSONString());
        if (canViewPath != null) {
            requestJSON.add("can_view_path", canViewPath.booleanValue());
        }
        if (expiresAt != null) {
            requestJSON.add("expires_at", BoxDateFormat.format(expiresAt));
        }
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
        BoxCollaboration boxCollaboration = newCollaboration = new BoxCollaboration(api, responseJSON.get("id").asString());
        boxCollaboration.getClass();
        return boxCollaboration.new Info(responseJSON);
    }

    public static Collection<Info> getPendingCollaborations(BoxAPIConnection api) {
        URL url = PENDING_COLLABORATIONS_URL.build(api.getBaseURL(), new Object[0]);
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
        int entriesCount = responseJSON.get("total_count").asInt();
        ArrayList<Info> collaborations = new ArrayList<Info>(entriesCount);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue entry : entries) {
            BoxCollaboration collaboration;
            JsonObject entryObject = entry.asObject();
            BoxCollaboration boxCollaboration = collaboration = new BoxCollaboration(api, entryObject.get("id").asString());
            boxCollaboration.getClass();
            Info info = boxCollaboration.new Info(entryObject);
            collaborations.add(info);
        }
        return collaborations;
    }

    public static BoxResourceIterable<Info> getAllFileCollaborations(final BoxAPIConnection api, String fileID, int pageSize, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new BoxResourceIterable<Info>(api, GET_ALL_FILE_COLLABORATIONS_URL.buildWithQuery(api.getBaseURL(), builder.toString(), fileID), pageSize){

            @Override
            protected Info factory(JsonObject jsonObject) {
                String id = jsonObject.get("id").asString();
                BoxCollaboration boxCollaboration = new BoxCollaboration(api, id);
                boxCollaboration.getClass();
                return boxCollaboration.new Info(jsonObject);
            }
        };
    }

    public Info getInfo() {
        BoxAPIConnection api = this.getAPI();
        URL url = COLLABORATION_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = Json.parse((String)response.getJSON()).asObject();
        return new Info(jsonObject);
    }

    public Info getInfo(String ... fields) {
        String queryString = new QueryStringBuilder().appendParam("fields", fields).toString();
        URL url = COLLABORATION_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Info(response.getJSON());
    }

    public void updateInfo(Info info) {
        BoxAPIConnection api = this.getAPI();
        URL url = COLLABORATION_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(api, url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxAPIResponse boxAPIResponse = request.send();
        if (boxAPIResponse instanceof BoxJSONResponse) {
            BoxJSONResponse response = (BoxJSONResponse)boxAPIResponse;
            JsonObject jsonObject = Json.parse((String)response.getJSON()).asObject();
            info.update(jsonObject);
        }
    }

    public void delete() {
        BoxAPIConnection api = this.getAPI();
        URL url = COLLABORATION_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public class Info
    extends BoxResource.Info {
        private BoxUser.Info createdBy;
        private Date createdAt;
        private Date modifiedAt;
        private Date expiresAt;
        private Status status;
        private BoxCollaborator.Info accessibleBy;
        private Role role;
        private Date acknowledgedAt;
        private BoxItem.Info item;
        private String inviteEmail;
        private boolean canViewPath;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        public BoxUser.Info getCreatedBy() {
            return this.createdBy;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        public Date getExpiresAt() {
            return this.expiresAt;
        }

        public void setExpiresAt(Date expiresAt) {
            this.expiresAt = expiresAt;
            this.addPendingChange("expires_at", BoxDateFormat.format(expiresAt));
        }

        public boolean getCanViewPath() {
            return this.canViewPath;
        }

        public void setCanViewPath(boolean canViewState) {
            this.canViewPath = canViewState;
            this.addPendingChange("can_view_path", canViewState);
        }

        public String getInviteEmail() {
            return this.inviteEmail;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
            this.addPendingChange("status", status.name().toLowerCase());
        }

        public BoxCollaborator.Info getAccessibleBy() {
            return this.accessibleBy;
        }

        public Role getRole() {
            return this.role;
        }

        public void setRole(Role role) {
            this.role = role;
            this.addPendingChange("role", role.toJSONString());
        }

        public Date getAcknowledgedAt() {
            return this.acknowledgedAt;
        }

        public BoxItem.Info getItem() {
            return this.item;
        }

        @Override
        public BoxCollaboration getResource() {
            return BoxCollaboration.this;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                switch (memberName) {
                    case "created_by": {
                        JsonObject userJSON = value.asObject();
                        if (this.createdBy == null) {
                            BoxUser user;
                            String userID = userJSON.get("id").asString();
                            BoxUser boxUser = user = new BoxUser(BoxCollaboration.this.getAPI(), userID);
                            boxUser.getClass();
                            this.createdBy = new BoxUser.Info(boxUser, userJSON);
                            break;
                        }
                        this.createdBy.update(userJSON);
                        break;
                    }
                    case "created_at": {
                        this.createdAt = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "modified_at": {
                        this.modifiedAt = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "expires_at": {
                        this.expiresAt = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "status": {
                        String statusString = value.asString().toUpperCase();
                        this.status = Status.valueOf(statusString);
                        break;
                    }
                    case "accessible_by": {
                        JsonObject accessibleByJSON = value.asObject();
                        if (this.accessibleBy == null) {
                            this.accessibleBy = this.parseAccessibleBy(accessibleByJSON);
                            break;
                        }
                        this.updateAccessibleBy(accessibleByJSON);
                        break;
                    }
                    case "role": {
                        this.role = Role.fromJSONString(value.asString());
                        break;
                    }
                    case "acknowledged_at": {
                        this.acknowledgedAt = BoxDateFormat.parse(value.asString());
                        break;
                    }
                    case "can_view_path": {
                        this.canViewPath = value.asBoolean();
                        break;
                    }
                    case "invite_email": {
                        this.inviteEmail = value.asString();
                        break;
                    }
                    case "item": {
                        JsonObject itemJson = value.asObject();
                        if (this.item == null) {
                            this.item = this.selectCollaborationItem(itemJson);
                            break;
                        }
                        this.item.update(itemJson);
                    }
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }

        private BoxItem.Info selectCollaborationItem(JsonObject itemJson) {
            String itemType;
            String itemId = itemJson.get("id").asString();
            switch (itemType = itemJson.get("type").asString()) {
                case "file": {
                    BoxFile boxFile = new BoxFile(BoxCollaboration.this.getAPI(), itemId);
                    boxFile.getClass();
                    return boxFile.new BoxFile.Info(itemJson);
                }
                case "folder": {
                    BoxFolder boxFolder = new BoxFolder(BoxCollaboration.this.getAPI(), itemId);
                    boxFolder.getClass();
                    return boxFolder.new BoxFolder.Info(itemJson);
                }
            }
            throw new IllegalStateException(String.format("Unsupported collaboration item type '%s': JSON %n%s", itemType, itemJson));
        }

        private void updateAccessibleBy(JsonObject json) {
            String type = json.get("type").asString();
            if (type.equals("user") && this.accessibleBy instanceof BoxUser.Info || type.equals("group") && this.accessibleBy instanceof BoxGroup.Info) {
                this.accessibleBy.update(json);
            } else {
                this.accessibleBy = this.parseAccessibleBy(json);
            }
        }

        private BoxCollaborator.Info parseAccessibleBy(JsonObject json) {
            String id = json.get("id").asString();
            String type = json.get("type").asString();
            BoxCollaborator.Info parsedInfo = null;
            if (type.equals("user")) {
                BoxUser user;
                BoxUser boxUser = user = new BoxUser(BoxCollaboration.this.getAPI(), id);
                boxUser.getClass();
                parsedInfo = new BoxUser.Info(boxUser, json);
            } else if (type.equals("group")) {
                BoxGroup group;
                BoxGroup boxGroup = group = new BoxGroup(BoxCollaboration.this.getAPI(), id);
                boxGroup.getClass();
                parsedInfo = new BoxGroup.Info(boxGroup, json);
            }
            return parsedInfo;
        }
    }

    public static enum Role {
        EDITOR("editor"),
        VIEWER("viewer"),
        PREVIEWER("previewer"),
        UPLOADER("uploader"),
        PREVIEWER_UPLOADER("previewer uploader"),
        VIEWER_UPLOADER("viewer uploader"),
        CO_OWNER("co-owner"),
        OWNER("owner");

        private final String jsonValue;

        private Role(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Role fromJSONString(String jsonValue) {
            switch (jsonValue) {
                case "editor": {
                    return EDITOR;
                }
                case "viewer": {
                    return VIEWER;
                }
                case "previewer": {
                    return PREVIEWER;
                }
                case "uploader": {
                    return UPLOADER;
                }
                case "previewer uploader": {
                    return PREVIEWER_UPLOADER;
                }
                case "viewer uploader": {
                    return VIEWER_UPLOADER;
                }
                case "co-owner": {
                    return CO_OWNER;
                }
                case "owner": {
                    return OWNER;
                }
            }
            throw new IllegalArgumentException("The provided JSON value isn't a valid Role.");
        }

        String toJSONString() {
            return this.jsonValue;
        }
    }

    public static enum Status {
        ACCEPTED,
        PENDING,
        REJECTED;

    }
}

