/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class ForeignExceptionUtil {
    private ForeignExceptionUtil() {
    }

    public static IOException toIOException(ErrorHandlingProtos.ForeignExceptionMessage eem) {
        ErrorHandlingProtos.GenericExceptionMessage gem = eem.getGenericException();
        StackTraceElement[] trace = ForeignExceptionUtil.toStackTrace(gem.getTraceList());
        RemoteException re = new RemoteException(gem.getClassName(), gem.getMessage());
        re.setStackTrace(trace);
        return re.unwrapRemoteException();
    }

    public static ErrorHandlingProtos.ForeignExceptionMessage toProtoForeignException(String source, Throwable t) {
        List<ErrorHandlingProtos.StackTraceElementMessage> stack;
        ErrorHandlingProtos.GenericExceptionMessage.Builder gemBuilder = ErrorHandlingProtos.GenericExceptionMessage.newBuilder();
        gemBuilder.setClassName(t.getClass().getName());
        if (t.getMessage() != null) {
            gemBuilder.setMessage(t.getMessage());
        }
        if ((stack = ForeignExceptionUtil.toProtoStackTraceElement(t.getStackTrace())) != null) {
            gemBuilder.addAllTrace(stack);
        }
        ErrorHandlingProtos.GenericExceptionMessage payload = gemBuilder.build();
        ErrorHandlingProtos.ForeignExceptionMessage.Builder exception = ErrorHandlingProtos.ForeignExceptionMessage.newBuilder();
        exception.setGenericException(payload).setSource(source);
        return exception.build();
    }

    public static List<ErrorHandlingProtos.StackTraceElementMessage> toProtoStackTraceElement(StackTraceElement[] trace) {
        if (trace == null) {
            return null;
        }
        ArrayList<ErrorHandlingProtos.StackTraceElementMessage> pbTrace = new ArrayList<ErrorHandlingProtos.StackTraceElementMessage>(trace.length);
        for (StackTraceElement elem : trace) {
            ErrorHandlingProtos.StackTraceElementMessage.Builder stackBuilder = ErrorHandlingProtos.StackTraceElementMessage.newBuilder();
            stackBuilder.setDeclaringClass(elem.getClassName());
            if (elem.getFileName() != null) {
                stackBuilder.setFileName(elem.getFileName());
            }
            stackBuilder.setLineNumber(elem.getLineNumber());
            stackBuilder.setMethodName(elem.getMethodName());
            pbTrace.add(stackBuilder.build());
        }
        return pbTrace;
    }

    public static StackTraceElement[] toStackTrace(List<ErrorHandlingProtos.StackTraceElementMessage> traceList) {
        if (traceList == null || traceList.size() == 0) {
            return new StackTraceElement[0];
        }
        StackTraceElement[] trace = new StackTraceElement[traceList.size()];
        for (int i = 0; i < traceList.size(); ++i) {
            ErrorHandlingProtos.StackTraceElementMessage elem = traceList.get(i);
            trace[i] = new StackTraceElement(elem.getDeclaringClass(), elem.getMethodName(), elem.hasFileName() ? elem.getFileName() : null, elem.getLineNumber());
        }
        return trace;
    }
}

