/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.client;

import java.util.Objects;

final class TableName {
    private final String dbName;
    private final String tableName;

    private TableName(String dbName, String tableName) {
        this.dbName = dbName;
        this.tableName = tableName;
    }

    public static TableName of(String dbName, String tableName) {
        return new TableName(dbName, tableName);
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableName)) {
            return false;
        }
        TableName other = (TableName)o;
        return Objects.equals(this.dbName, other.dbName) && Objects.equals(this.tableName, other.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.dbName, this.tableName);
    }

    public String toString() {
        return String.format("dbName:%s, tableName:%s", this.dbName, this.tableName);
    }
}

