/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.rdbms.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.metastore.rdbms.exception.RdbmsMetastoreException;

public class ConverterUtil {
    private static final ObjectMapper MAPPER = JacksonUtils.createObjectMapper();
    private static final TypeReference<List<String>> LIST_STRING_TYPE_REF = new TypeReference<List<String>>(){};
    private static final TypeReference<Map<String, String>> MAP_STRING_STRING_TYPE_REF = new TypeReference<Map<String, String>>(){};
    private static final TypeReference<Map<String, Float>> MAP_STRING_FLOAT_TYPE_REF = new TypeReference<Map<String, Float>>(){};

    public static <T> String convertToString(T value) {
        try {
            return MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RdbmsMetastoreException("Unable to convert value to String: " + value);
        }
    }

    public static <T> T convertTo(String value, TypeReference<T> typeReference) {
        if (value == null) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(value, typeReference);
        }
        catch (IOException e) {
            throw new RdbmsMetastoreException(String.format("Unable to convert to %s value: %s", typeReference.getType().getTypeName(), value));
        }
    }

    public static List<String> convertToListString(String value) {
        return ConverterUtil.convertTo(value, LIST_STRING_TYPE_REF);
    }

    public static Map<String, String> convertToMapStringString(String value) {
        return ConverterUtil.convertTo(value, MAP_STRING_STRING_TYPE_REF);
    }

    public static Map<String, Float> convertToMapStringFloat(String value) {
        return ConverterUtil.convertTo(value, MAP_STRING_FLOAT_TYPE_REF);
    }
}

