/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.util;

import java.util.Map;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionManager;
import org.apache.tephra.TransactionType;
import org.apache.tephra.persist.TransactionVisibilityState;
import org.apache.tephra.shaded.com.google.common.primitives.Longs;

public class TxUtils {
    private static final long MAX_NON_TX_TIMESTAMP = (long)((double)System.currentTimeMillis() * 1.1);

    public static long getOldestVisibleTimestamp(Map<byte[], Long> ttlByFamily, Transaction tx) {
        long maxTTL = TxUtils.getMaxTTL(ttlByFamily);
        return maxTTL < Long.MAX_VALUE ? tx.getVisibilityUpperBound() - maxTTL * 1000000L : 0L;
    }

    public static long getOldestVisibleTimestamp(Map<byte[], Long> ttlByFamily, Transaction tx, boolean readNonTxnData) {
        if (readNonTxnData) {
            long maxTTL = TxUtils.getMaxTTL(ttlByFamily);
            return maxTTL < Long.MAX_VALUE ? System.currentTimeMillis() - maxTTL : 0L;
        }
        return TxUtils.getOldestVisibleTimestamp(ttlByFamily, tx);
    }

    public static long getMaxVisibleTimestamp(Transaction tx) {
        return tx.getWritePointer() < Long.MAX_VALUE ? tx.getWritePointer() + 1L : tx.getWritePointer();
    }

    public static Transaction createDummyTransaction(TransactionVisibilityState txVisibilityState) {
        return new Transaction(txVisibilityState.getReadPointer(), Long.MAX_VALUE, Longs.toArray(txVisibilityState.getInvalid()), Longs.toArray(txVisibilityState.getInProgress().keySet()), TxUtils.getFirstShortInProgress(txVisibilityState.getInProgress()), TransactionType.SHORT);
    }

    public static long getFirstShortInProgress(Map<Long, TransactionManager.InProgressTx> inProgress) {
        long firstShort = Long.MAX_VALUE;
        for (Map.Entry<Long, TransactionManager.InProgressTx> entry : inProgress.entrySet()) {
            if (entry.getValue().isLongRunning()) continue;
            firstShort = entry.getKey();
            break;
        }
        return firstShort;
    }

    public static long getTimestampForTTL(long cellTs) {
        return TxUtils.isPreExistingVersion(cellTs) ? cellTs * 1000000L : cellTs;
    }

    private static long getMaxTTL(Map<byte[], Long> ttlByFamily) {
        long maxTTL = 0L;
        for (Long familyTTL : ttlByFamily.values()) {
            maxTTL = Math.max(familyTTL <= 0L ? Long.MAX_VALUE : familyTTL, maxTTL);
        }
        return maxTTL == 0L ? Long.MAX_VALUE : maxTTL;
    }

    public static boolean isPreExistingVersion(long version) {
        return version < MAX_NON_TX_TIMESTAMP;
    }

    public static long getPruneUpperBound(Transaction tx) {
        if (tx.getInvalids().length == 0 && tx.getInProgress().length == 0) {
            return tx.getReadPointer() - 1L;
        }
        long maxInvalidTx = tx.getInvalids().length > 0 ? tx.getInvalids()[tx.getInvalids().length - 1] : Long.MAX_VALUE;
        long firstInProgress = tx.getFirstInProgress();
        return Math.min(maxInvalidTx, firstInProgress - 1L);
    }

    public static long getInactiveTxBound(long timeMills, long txMaxLifetimeMillis) {
        return (timeMills - txMaxLifetimeMillis) * 1000000L - 1L;
    }

    public static long getTimestamp(long txId) {
        return txId / 1000000L;
    }
}

