/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.internal.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.apache.tephra.shaded.com.google.common.base.Defaults;
import org.apache.tephra.shaded.com.google.common.base.Preconditions;
import org.apache.tephra.shaded.com.google.common.base.Throwables;
import org.apache.tephra.shaded.com.google.common.reflect.TypeToken;

public final class Instances {
    private static final Object UNSAFE;
    private static final Method UNSAFE_NEW_INSTANCE;

    public static <T> T newInstance(Class<T> clz) {
        try {
            Constructor<T> cons = clz.getDeclaredConstructor(new Class[0]);
            if (!cons.isAccessible()) {
                cons.setAccessible(true);
            }
            return cons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            try {
                Preconditions.checkState(UNSAFE != null, "Fail to instantiate with Unsafe.");
                return Instances.unsafeCreate(clz);
            }
            catch (Exception e2) {
                throw Throwables.propagate(e2);
            }
        }
    }

    private static <T> T unsafeCreate(Class<T> clz) throws InvocationTargetException, IllegalAccessException {
        TypeToken type;
        Object instance = UNSAFE_NEW_INSTANCE.invoke(UNSAFE, clz);
        Iterator i$ = TypeToken.of(clz).getTypes().classes().iterator();
        while (i$.hasNext() && !Object.class.equals((type = (TypeToken)i$.next()).getRawType())) {
            for (Field field : type.getRawType().getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(instance, Defaults.defaultValue(field.getType()));
            }
        }
        return (T)instance;
    }

    private Instances() {
    }

    static {
        Method newInstance;
        Object unsafe;
        try {
            Class<?> clz = Class.forName("sun.misc.Unsafe");
            Field f = clz.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unsafe = f.get(null);
            newInstance = clz.getMethod("allocateInstance", Class.class);
        }
        catch (Exception e) {
            unsafe = null;
            newInstance = null;
        }
        UNSAFE = unsafe;
        UNSAFE_NEW_INSTANCE = newInstance;
    }
}

