/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxJSONObject;
import com.box.sdk.BoxZipConflict;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BoxZipInfo
extends BoxJSONObject {
    private URL downloadURL;
    private URL statusURL;
    private Date expiresAt;
    private List<BoxZipConflict> nameConflicts;

    public BoxZipInfo() {
    }

    public BoxZipInfo(String json) {
        super(json);
    }

    BoxZipInfo(JsonObject jsonObject) {
        super(jsonObject);
    }

    public URL getDownloadURL() {
        return this.downloadURL;
    }

    public URL getStatusURL() {
        return this.statusURL;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public List<BoxZipConflict> getNameConflicts() {
        return this.nameConflicts;
    }

    @Override
    void parseJSONMember(JsonObject.Member member) {
        block11: {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            try {
                if (memberName.equals("download_url")) {
                    try {
                        String urlString = value.asString();
                        this.downloadURL = new URL(urlString);
                        break block11;
                    }
                    catch (MalformedURLException e) {
                        throw new BoxAPIException("Couldn't parse download url for zip", e);
                    }
                }
                if (memberName.equals("status_url")) {
                    try {
                        String urlString = value.asString();
                        this.statusURL = new URL(urlString);
                        break block11;
                    }
                    catch (MalformedURLException e) {
                        throw new BoxAPIException("Couldn't parse status url for zip", e);
                    }
                }
                if (memberName.equals("expires_at")) {
                    this.expiresAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("name_conflicts")) {
                    this.nameConflicts = this.parseNameConflicts(value.asArray());
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }

    private List<BoxZipConflict> parseNameConflicts(JsonArray jsonArray) {
        ArrayList<BoxZipConflict> nameConflicts = new ArrayList<BoxZipConflict>(jsonArray.size());
        for (JsonValue conflict : jsonArray) {
            JsonObject conflictObj = new JsonObject().add("conflict", conflict);
            nameConflicts.add(new BoxZipConflict(conflictObj));
        }
        return nameConflicts;
    }
}

