/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.storage;

import io.jhdf.Superblock;
import io.jhdf.exceptions.HdfException;
import io.jhdf.storage.HdfBackingStorage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class HdfFileChannel
implements HdfBackingStorage {
    private final FileChannel fc;
    private final Superblock sb;

    public HdfFileChannel(FileChannel fileChannel, Superblock superblock) {
        this.fc = fileChannel;
        this.sb = superblock;
    }

    @Override
    public ByteBuffer readBufferFromAddress(long address, int length) {
        ByteBuffer bb = ByteBuffer.allocate(length);
        try {
            this.fc.read(bb, address + this.sb.getBaseAddressByte());
        }
        catch (IOException e) {
            throw new HdfException("Failed to read from file at address '" + address + "' (raw address '" + address + this.sb.getBaseAddressByte() + "'", e);
        }
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.rewind();
        return bb;
    }

    @Override
    public ByteBuffer map(long address, long length) {
        return this.mapNoOffset(address + this.sb.getBaseAddressByte(), length);
    }

    @Override
    public ByteBuffer mapNoOffset(long address, long length) {
        try {
            return this.fc.map(FileChannel.MapMode.READ_ONLY, address, length);
        }
        catch (IOException e) {
            throw new HdfException("Failed to map buffer at address '" + address + "' of length '" + length + "'", e);
        }
    }

    @Override
    public long getUserBlockSize() {
        return this.sb.getBaseAddressByte();
    }

    @Override
    public Superblock getSuperblock() {
        return this.sb;
    }

    @Override
    public FileChannel getFileChannel() {
        return this.fc;
    }

    @Override
    public int getSizeOfOffsets() {
        return this.sb.getSizeOfOffsets();
    }

    @Override
    public int getSizeOfLengths() {
        return this.sb.getSizeOfLengths();
    }

    @Override
    public final void close() {
        try {
            this.fc.close();
        }
        catch (IOException e) {
            throw new HdfException("Failed closing HDF5 file", e);
        }
    }

    @Override
    public long size() {
        try {
            return this.fc.size();
        }
        catch (IOException e) {
            throw new HdfException("Failed to get size of HDF5 file", e);
        }
    }

    @Override
    public boolean inMemory() {
        return false;
    }
}

