/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.OrderedDataType;
import io.jhdf.storage.HdfBackingStorage;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BitField
extends DataType
implements OrderedDataType {
    private final ByteOrder order;
    private final boolean lowPadding;
    private final boolean highPadding;
    private final short bitOffset;
    private final short bitPrecision;

    public BitField(ByteBuffer bb) {
        super(bb);
        this.order = this.classBits.get(0) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.lowPadding = this.classBits.get(1);
        this.highPadding = this.classBits.get(2);
        this.bitOffset = bb.getShort();
        this.bitPrecision = bb.getShort();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.order;
    }

    public boolean isLowPadding() {
        return this.lowPadding;
    }

    public boolean isHighPadding() {
        return this.highPadding;
    }

    public short getBitOffset() {
        return this.bitOffset;
    }

    public short getBitPrecision() {
        return this.bitPrecision;
    }

    @Override
    public Class<?> getJavaType() {
        return Boolean.TYPE;
    }

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfBackingStorage hdfBackingStorage) {
        Object data = Array.newInstance(this.getJavaType(), dimensions);
        BitField.fillBitfieldData(data, dimensions, buffer.order(this.getByteOrder()));
        return data;
    }

    private static void fillBitfieldData(Object data, int[] dims, ByteBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                BitField.fillBitfieldData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            for (int i = 0; i < Array.getLength(data); ++i) {
                Array.set(data, i, buffer.get() == 1);
            }
        }
    }
}

