/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.WritableComparator;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.BaseQueryPlan;
import org.apache.phoenix.execute.DescVarLengthFastByteComparisons;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.filter.ColumnProjectionFilter;
import org.apache.phoenix.filter.DistinctPrefixFilter;
import org.apache.phoenix.filter.EncodedQualifiersColumnProjectionFilter;
import org.apache.phoenix.filter.MultiEncodedCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.PagedFilter;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterators;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanUtil.class);
    public static final int[] SINGLE_COLUMN_SLOT_SPAN = new int[1];
    public static final int UNKNOWN_CLIENT_VERSION = VersionUtil.encodeVersion(4, 4, 0);
    private static final byte[] MAX_FILL_LENGTH_FOR_PREVIOUS_KEY = new byte[16];
    private static final byte[] ZERO_BYTE_ARRAY;
    private static final BytesComparator DESC_VAR_WIDTH_COMPARATOR;
    private static final BytesComparator ASC_FIXED_WIDTH_COMPARATOR;

    private ScanUtil() {
    }

    public static void setTenantId(Scan scan, byte[] tenantId) {
        scan.setAttribute("TenantId", tenantId);
    }

    public static void setLocalIndex(Scan scan) {
        scan.setAttribute("_LocalIndex", PDataType.TRUE_BYTES);
    }

    public static boolean isLocalIndex(Scan scan) {
        return scan.getAttribute("_LocalIndex") != null;
    }

    public static boolean isNonAggregateScan(Scan scan) {
        return scan.getAttribute("_NonAggregateQuery") != null;
    }

    public static boolean isSimpleScan(Scan scan) {
        return ScanUtil.isNonAggregateScan(scan) && scan.getAttribute("_TopN") == null && scan.getAttribute("_RowOffset") == null;
    }

    public static ImmutableBytesPtr getTenantId(Scan scan) {
        byte[] tenantId = scan.getAttribute("TenantId");
        if (tenantId == null) {
            return null;
        }
        return new ImmutableBytesPtr(tenantId);
    }

    public static void setCustomAnnotations(Scan scan, byte[] annotations) {
        scan.setAttribute("_Annot", annotations);
    }

    public static byte[] getCustomAnnotations(Scan scan) {
        return scan.getAttribute("_Annot");
    }

    public static Scan newScan(Scan scan) {
        try {
            Scan newScan = new Scan(scan);
            TreeMap existingMap = (TreeMap)scan.getFamilyMap();
            TreeMap clonedMap = new TreeMap(existingMap);
            newScan.setFamilyMap(clonedMap);
            newScan.setReversed(scan.isReversed());
            if (scan.isSmall()) {
                newScan.setSmall(true);
            }
            return newScan;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean intersectScanRange(Scan scan, byte[] startKey, byte[] stopKey) {
        return ScanUtil.intersectScanRange(scan, startKey, stopKey, false);
    }

    public static boolean intersectScanRange(Scan scan, byte[] startKey, byte[] stopKey, boolean useSkipScan) {
        boolean mayHaveRows = false;
        int offset = 0;
        if (ScanUtil.isLocalIndex(scan)) {
            offset = startKey.length != 0 ? startKey.length : stopKey.length;
        }
        byte[] existingStartKey = scan.getStartRow();
        byte[] existingStopKey = scan.getStopRow();
        if (existingStartKey.length > 0) {
            if (startKey.length == 0 || Bytes.compareTo((byte[])existingStartKey, (byte[])startKey) > 0) {
                startKey = existingStartKey;
            }
        } else {
            mayHaveRows = true;
        }
        if (existingStopKey.length > 0) {
            if (stopKey.length == 0 || Bytes.compareTo((byte[])existingStopKey, (byte[])stopKey) < 0) {
                stopKey = existingStopKey;
            }
        } else {
            mayHaveRows = true;
        }
        scan.setStartRow(startKey);
        scan.setStopRow(stopKey);
        if (offset > 0 && useSkipScan) {
            byte[] temp = null;
            if (startKey.length != 0) {
                temp = new byte[startKey.length - offset];
                System.arraycopy(startKey, offset, temp, 0, startKey.length - offset);
                startKey = temp;
            }
            if (stopKey.length != 0) {
                temp = new byte[stopKey.length - offset];
                System.arraycopy(stopKey, offset, temp, 0, stopKey.length - offset);
                stopKey = temp;
            }
        }
        boolean bl = mayHaveRows = mayHaveRows || Bytes.compareTo((byte[])scan.getStartRow(), (byte[])scan.getStopRow()) < 0;
        if (mayHaveRows && useSkipScan) {
            Filter filter = scan.getFilter();
            if (filter instanceof SkipScanFilter) {
                SkipScanFilter oldFilter = (SkipScanFilter)filter;
                SkipScanFilter newFilter = oldFilter.intersect(startKey, stopKey);
                if (newFilter == null) {
                    return false;
                }
                scan.setFilter((Filter)newFilter);
            } else if (filter instanceof FilterList) {
                FilterList oldList = (FilterList)filter;
                FilterList newList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                for (Filter f : oldList.getFilters()) {
                    if (f instanceof SkipScanFilter) {
                        SkipScanFilter newFilter = ((SkipScanFilter)f).intersect(startKey, stopKey);
                        if (newFilter == null) {
                            return false;
                        }
                        newList.addFilter((Filter)newFilter);
                        continue;
                    }
                    newList.addFilter(f);
                }
                scan.setFilter((Filter)newList);
            }
        }
        return mayHaveRows;
    }

    public static void andFilterAtBeginning(Scan scan, Filter andWithFilter) {
        if (andWithFilter == null) {
            return;
        }
        Filter filter = scan.getFilter();
        if (filter == null) {
            scan.setFilter(andWithFilter);
        } else if (filter instanceof FilterList && ((FilterList)filter).getOperator() == FilterList.Operator.MUST_PASS_ALL) {
            FilterList filterList = (FilterList)filter;
            ArrayList<Filter> allFilters = new ArrayList<Filter>(filterList.getFilters().size() + 1);
            allFilters.add(andWithFilter);
            allFilters.addAll(filterList.getFilters());
            scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, allFilters));
        } else {
            scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(andWithFilter, filter)));
        }
    }

    public static void andFilterAtEnd(Scan scan, Filter andWithFilter) {
        if (andWithFilter == null) {
            return;
        }
        Filter filter = scan.getFilter();
        if (filter == null) {
            scan.setFilter(andWithFilter);
        } else if (filter instanceof FilterList && ((FilterList)filter).getOperator() == FilterList.Operator.MUST_PASS_ALL) {
            FilterList filterList = (FilterList)filter;
            ArrayList<Filter> allFilters = new ArrayList<Filter>(filterList.getFilters().size() + 1);
            allFilters.addAll(filterList.getFilters());
            allFilters.add(andWithFilter);
            scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, allFilters));
        } else {
            scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filter, andWithFilter)));
        }
    }

    public static void setQualifierRangesOnFilter(Scan scan, Pair<Integer, Integer> minMaxQualifiers) {
        Filter filter = scan.getFilter();
        if (filter != null) {
            if (filter instanceof FilterList) {
                for (Filter f : ((FilterList)filter).getFilters()) {
                    if (!(f instanceof MultiEncodedCQKeyValueComparisonFilter)) continue;
                    ((MultiEncodedCQKeyValueComparisonFilter)f).setMinMaxQualifierRange(minMaxQualifiers);
                }
            } else if (filter instanceof MultiEncodedCQKeyValueComparisonFilter) {
                ((MultiEncodedCQKeyValueComparisonFilter)filter).setMinMaxQualifierRange(minMaxQualifiers);
            }
        }
    }

    public static void setTimeRange(Scan scan, long ts) {
        try {
            scan.setTimeRange(0L, ts);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setTimeRange(Scan scan, TimeRange range) {
        try {
            scan.setTimeRange(range.getMin(), range.getMax());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setTimeRange(Scan scan, long minStamp, long maxStamp) {
        try {
            scan.setTimeRange(minStamp, maxStamp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getMinKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan) {
        return ScanUtil.getKey(schema, slots, slotSpan, KeyRange.Bound.LOWER);
    }

    public static byte[] getMaxKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan) {
        return ScanUtil.getKey(schema, slots, slotSpan, KeyRange.Bound.UPPER);
    }

    private static byte[] getKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan, KeyRange.Bound bound) {
        if (slots.isEmpty()) {
            return KeyRange.UNBOUND;
        }
        int[] position = new int[slots.size()];
        int maxLength = 0;
        for (int i = 0; i < position.length; ++i) {
            position[i] = bound == KeyRange.Bound.LOWER ? 0 : slots.get(i).size() - 1;
            KeyRange range = slots.get(i).get(position[i]);
            ValueSchema.Field field = schema.getField(i + slotSpan[i]);
            int keyLength = range.getRange(bound).length;
            if (!field.getDataType().isFixedWidth()) {
                ++keyLength;
                if (range.isUnbound(bound) && !range.isInclusive(bound) && field.getSortOrder() == SortOrder.DESC) {
                    ++keyLength;
                }
            }
            maxLength += keyLength;
        }
        byte[] key = new byte[maxLength];
        int length = ScanUtil.setKey(schema, slots, slotSpan, position, bound, key, 0, 0, position.length);
        if (length == 0) {
            return KeyRange.UNBOUND;
        }
        if (length == maxLength) {
            return key;
        }
        byte[] keyCopy = new byte[length];
        System.arraycopy(key, 0, keyCopy, 0, length);
        return keyCopy;
    }

    public static int setKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan, int[] position, KeyRange.Bound bound, byte[] key, int byteOffset, int slotStartIndex, int slotEndIndex) {
        return ScanUtil.setKey(schema, slots, slotSpan, position, bound, key, byteOffset, slotStartIndex, slotEndIndex, slotStartIndex);
    }

    public static int setKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] slotSpan, int[] position, KeyRange.Bound bound, byte[] key, int byteOffset, int slotStartIndex, int slotEndIndex, int schemaStartIndex) {
        int offset = byteOffset;
        boolean lastInclusiveUpperSingleKey = false;
        boolean anyInclusiveUpperRangeKey = false;
        boolean lastUnboundUpper = false;
        ValueSchema.Field field = null;
        int i = slotStartIndex;
        int fieldIndex = ScanUtil.getRowKeyPosition(slotSpan, slotStartIndex);
        for (i = slotStartIndex; i < slotEndIndex; ++i) {
            KeyRange range = slots.get(i).get(position[i]);
            field = schema.getField(fieldIndex + slotSpan[i]);
            boolean isFixedWidth = field.getDataType().isFixedWidth();
            lastUnboundUpper = false;
            if (range.isUnbound(bound) && (bound == KeyRange.Bound.UPPER || isFixedWidth)) {
                lastUnboundUpper = bound == KeyRange.Bound.UPPER;
                break;
            }
            byte[] bytes = range.getRange(bound);
            System.arraycopy(bytes, 0, key, offset, bytes.length);
            offset += bytes.length;
            boolean inclusiveUpper = range.isUpperInclusive() && bound == KeyRange.Bound.UPPER;
            boolean exclusiveLower = !range.isLowerInclusive() && bound == KeyRange.Bound.LOWER && range != KeyRange.EVERYTHING_RANGE;
            boolean exclusiveUpper = !range.isUpperInclusive() && bound == KeyRange.Bound.UPPER;
            lastInclusiveUpperSingleKey = range.isSingleKey() && inclusiveUpper;
            anyInclusiveUpperRangeKey |= !range.isSingleKey() && inclusiveUpper;
            byte sepByte = SchemaUtil.getSeparatorByte(schema.rowKeyOrderOptimizable(), bytes.length == 0, field);
            if (!isFixedWidth && (sepByte == QueryConstants.DESC_SEPARATOR_BYTE || !exclusiveUpper && (fieldIndex < schema.getMaxFields() || inclusiveUpper || exclusiveLower))) {
                key[offset++] = sepByte;
                if (sepByte != QueryConstants.DESC_SEPARATOR_BYTE) {
                    lastInclusiveUpperSingleKey &= fieldIndex + slotSpan[i] < schema.getMaxFields() - 1;
                }
            }
            if (exclusiveUpper) break;
            if (exclusiveLower) {
                if (!ByteUtil.nextKey(key, offset)) {
                    return -byteOffset;
                }
                if (!isFixedWidth && bytes.length == 0 && SchemaUtil.getSeparatorByte(schema.rowKeyOrderOptimizable(), false, field) == QueryConstants.DESC_SEPARATOR_BYTE) {
                    key[offset++] = QueryConstants.DESC_SEPARATOR_BYTE;
                }
            }
            fieldIndex += slotSpan[i] + 1;
        }
        if ((lastInclusiveUpperSingleKey || anyInclusiveUpperRangeKey || lastUnboundUpper) && !ByteUtil.nextKey(key, offset)) {
            return -byteOffset;
        }
        if (bound == KeyRange.Bound.LOWER) {
            while (--i >= schemaStartIndex && offset > byteOffset && !(field = schema.getField(--fieldIndex)).getDataType().isFixedWidth() && field.getSortOrder() == SortOrder.ASC && key[offset - 1] == 0) {
                --offset;
                fieldIndex -= slotSpan[i];
            }
        }
        return offset - byteOffset;
    }

    public static BytesComparator getComparator(boolean isFixedWidth, SortOrder sortOrder) {
        return isFixedWidth || sortOrder == SortOrder.ASC ? ASC_FIXED_WIDTH_COMPARATOR : DESC_VAR_WIDTH_COMPARATOR;
    }

    public static BytesComparator getComparator(ValueSchema.Field field) {
        return ScanUtil.getComparator(field.getDataType().isFixedWidth(), field.getSortOrder());
    }

    public static int searchClosestKeyRangeWithUpperHigherThanPtr(List<KeyRange> slots, ImmutableBytesWritable ptr, int lower, ValueSchema.Field field) {
        int mid;
        int upper = slots.size() - 1;
        BytesComparator comparator = ScanUtil.getComparator(field.getDataType().isFixedWidth(), field.getSortOrder());
        while (lower <= upper) {
            mid = (lower + upper) / 2;
            int cmp = slots.get(mid).compareUpperToLowerBound(ptr, true, comparator);
            if (cmp < 0) {
                lower = mid + 1;
                continue;
            }
            if (cmp > 0) {
                upper = mid - 1;
                continue;
            }
            return mid;
        }
        mid = (lower + upper) / 2;
        if (mid == 0 && slots.get(mid).compareUpperToLowerBound(ptr, true, comparator) > 0) {
            return mid;
        }
        return ++mid;
    }

    public static ScanRanges newScanRanges(List<? extends Mutation> mutations) throws SQLException {
        ArrayList keys = Lists.newArrayListWithExpectedSize((int)mutations.size());
        for (Mutation mutation : mutations) {
            keys.add(PVarbinary.INSTANCE.getKeyRange(mutation.getRow()));
        }
        ScanRanges keyRanges = ScanRanges.createPointLookup(keys);
        return keyRanges;
    }

    public static KeyRange convertToInclusiveExclusiveRange(KeyRange partialRange, RowKeySchema schema, ImmutableBytesWritable ptr) {
        byte[] lowerRange = partialRange.getLowerRange();
        if (!partialRange.lowerUnbound() && !partialRange.isLowerInclusive()) {
            lowerRange = ScanUtil.nextKey(lowerRange, schema, ptr);
        }
        byte[] upperRange = partialRange.getUpperRange();
        if (!partialRange.upperUnbound() && partialRange.isUpperInclusive()) {
            upperRange = ScanUtil.nextKey(upperRange, schema, ptr);
        }
        if (partialRange.getLowerRange() != lowerRange || partialRange.getUpperRange() != upperRange) {
            partialRange = KeyRange.getKeyRange(lowerRange, upperRange);
        }
        return partialRange;
    }

    private static byte[] nextKey(byte[] key, RowKeySchema schema, ImmutableBytesWritable ptr) {
        int pos = 0;
        int maxOffset = schema.iterator(key, ptr);
        while (schema.next(ptr, pos, maxOffset) != null) {
            ++pos;
        }
        ValueSchema.Field field = schema.getField(pos - 1);
        if (!field.getDataType().isFixedWidth()) {
            byte[] newLowerRange = new byte[key.length + 1];
            System.arraycopy(key, 0, newLowerRange, 0, key.length);
            newLowerRange[key.length] = SchemaUtil.getSeparatorByte(schema.rowKeyOrderOptimizable(), key.length == 0, field);
            key = newLowerRange;
        } else {
            key = Arrays.copyOf(key, key.length);
        }
        ByteUtil.nextKey(key, key.length);
        return key;
    }

    public static boolean isReversed(Scan scan) {
        return scan.getAttribute("_ReverseScan") != null;
    }

    public static void setReversed(Scan scan) {
        scan.setAttribute("_ReverseScan", PDataType.TRUE_BYTES);
        scan.setLoadColumnFamiliesOnDemand(false);
    }

    public static void unsetReversed(Scan scan) {
        scan.setAttribute("_ReverseScan", PDataType.FALSE_BYTES);
        scan.setLoadColumnFamiliesOnDemand(true);
    }

    private static byte[] getReversedRow(byte[] startRow) {
        byte[] newStartRow = startRow;
        if (startRow.length != 0) {
            newStartRow = Arrays.copyOf(startRow, startRow.length + MAX_FILL_LENGTH_FOR_PREVIOUS_KEY.length);
            if (ByteUtil.previousKey(newStartRow, startRow.length)) {
                System.arraycopy(MAX_FILL_LENGTH_FOR_PREVIOUS_KEY, 0, newStartRow, startRow.length, MAX_FILL_LENGTH_FOR_PREVIOUS_KEY.length);
            } else {
                newStartRow = HConstants.EMPTY_START_ROW;
            }
        }
        return newStartRow;
    }

    public static void setupReverseScan(Scan scan) {
        if (ScanUtil.isReversed(scan) && !scan.isReversed()) {
            byte[] newStartRow = ScanUtil.getReversedRow(scan.getStartRow());
            byte[] newStopRow = ScanUtil.getReversedRow(scan.getStopRow());
            scan.setStartRow(newStopRow);
            scan.setStopRow(newStartRow);
            scan.setReversed(true);
        }
    }

    public static void setupLocalIndexScan(Scan scan) {
        int prefixLength;
        byte[] prefix = scan.getStartRow().length == 0 ? new byte[scan.getStopRow().length] : scan.getStartRow();
        int n = prefixLength = scan.getStartRow().length == 0 ? scan.getStopRow().length : scan.getStartRow().length;
        if (scan.getAttribute("_ScanStartRowSuffix") != null) {
            scan.setStartRow(ScanRanges.prefixKey(scan.getAttribute("_ScanStartRowSuffix"), 0, prefix, prefixLength));
        }
        if (scan.getAttribute("_ScanStopRowSuffix") != null) {
            scan.setStopRow(ScanRanges.prefixKey(scan.getAttribute("_ScanStopRowSuffix"), 0, prefix, prefixLength));
        }
    }

    public static byte[] getActualStartRow(Scan localIndexScan, RegionInfo regionInfo) {
        return localIndexScan.getAttribute("_ScanStartRowSuffix") == null ? localIndexScan.getStartRow() : ScanRanges.prefixKey(localIndexScan.getAttribute("_ScanStartRowSuffix"), 0, regionInfo.getStartKey().length == 0 ? new byte[regionInfo.getEndKey().length] : regionInfo.getStartKey(), regionInfo.getStartKey().length == 0 ? regionInfo.getEndKey().length : regionInfo.getStartKey().length);
    }

    public static void setLocalIndexAttributes(Scan newScan, int keyOffset, byte[] regionStartKey, byte[] regionEndKey, byte[] startRowSuffix, byte[] stopRowSuffix) {
        if (ScanUtil.isLocalIndex(newScan)) {
            newScan.setAttribute("_ScanActualStartRow", regionStartKey);
            newScan.setStartRow(regionStartKey);
            newScan.setStopRow(regionEndKey);
            if (keyOffset > 0) {
                newScan.setAttribute("_ScanStartRowSuffix", ScanRanges.stripPrefix(startRowSuffix, keyOffset));
            } else {
                newScan.setAttribute("_ScanStartRowSuffix", startRowSuffix);
            }
            if (keyOffset > 0) {
                newScan.setAttribute("_ScanStopRowSuffix", ScanRanges.stripPrefix(stopRowSuffix, keyOffset));
            } else {
                newScan.setAttribute("_ScanStopRowSuffix", stopRowSuffix);
            }
        }
    }

    public static boolean isContextScan(Scan scan, StatementContext context) {
        return Bytes.compareTo((byte[])context.getScan().getStartRow(), (byte[])scan.getStartRow()) == 0 && Bytes.compareTo((byte[])context.getScan().getStopRow(), (byte[])scan.getStopRow()) == 0;
    }

    public static int getRowKeyOffset(byte[] regionStartKey, byte[] regionEndKey) {
        return regionStartKey.length > 0 ? regionStartKey.length : regionEndKey.length;
    }

    private static void setRowKeyOffset(Filter filter, int offset) {
        if (filter instanceof BooleanExpressionFilter) {
            BooleanExpressionFilter boolFilter = (BooleanExpressionFilter)filter;
            IndexUtil.setRowKeyExpressionOffset(boolFilter.getExpression(), offset);
        } else if (filter instanceof SkipScanFilter) {
            SkipScanFilter skipScanFilter = (SkipScanFilter)filter;
            skipScanFilter.setOffset(offset);
        } else if (filter instanceof DistinctPrefixFilter) {
            DistinctPrefixFilter prefixFilter = (DistinctPrefixFilter)filter;
            prefixFilter.setOffset(offset);
        }
    }

    public static void setRowKeyOffset(Scan scan, int offset) {
        Filter filter = scan.getFilter();
        if (filter == null) {
            return;
        }
        if (filter instanceof PagedFilter && (filter = ((PagedFilter)filter).getDelegateFilter()) == null) {
            return;
        }
        if (filter instanceof FilterList) {
            FilterList filterList = (FilterList)filter;
            for (Filter childFilter : filterList.getFilters()) {
                ScanUtil.setRowKeyOffset(childFilter, offset);
            }
        } else {
            ScanUtil.setRowKeyOffset(filter, offset);
        }
    }

    public static int[] getDefaultSlotSpans(int nSlots) {
        return new int[nSlots];
    }

    public static int getRowKeyPosition(int[] slotSpan, int slotPosition) {
        int offset = 0;
        for (int i = 0; i < slotPosition; ++i) {
            offset += slotSpan[i];
        }
        return offset + slotPosition;
    }

    public static boolean isAnalyzeTable(Scan scan) {
        return scan.getAttribute("_ANALYZETABLE") != null;
    }

    public static boolean crossesPrefixBoundary(byte[] key, byte[] prefixBytes, int prefixLength) {
        if (key.length < prefixLength) {
            return true;
        }
        if (prefixBytes.length >= prefixLength) {
            return Bytes.compareTo((byte[])prefixBytes, (int)0, (int)prefixLength, (byte[])key, (int)0, (int)prefixLength) != 0;
        }
        return ScanUtil.hasNonZeroLeadingBytes(key, prefixLength);
    }

    public static byte[] getPrefix(byte[] startKey, int prefixLength) {
        return startKey.length >= prefixLength ? startKey : ByteUtil.EMPTY_BYTE_ARRAY;
    }

    private static boolean hasNonZeroLeadingBytes(byte[] key, int nBytesToCheck) {
        if (nBytesToCheck > ZERO_BYTE_ARRAY.length) {
            do {
                if (Bytes.compareTo((byte[])key, (int)(nBytesToCheck - ZERO_BYTE_ARRAY.length), (int)ZERO_BYTE_ARRAY.length, (byte[])ZERO_BYTE_ARRAY, (int)0, (int)ZERO_BYTE_ARRAY.length) == 0) continue;
                return true;
            } while ((nBytesToCheck -= ZERO_BYTE_ARRAY.length) > ZERO_BYTE_ARRAY.length);
        }
        return Bytes.compareTo((byte[])key, (int)0, (int)nBytesToCheck, (byte[])ZERO_BYTE_ARRAY, (int)0, (int)nBytesToCheck) != 0;
    }

    public static byte[] getTenantIdBytes(RowKeySchema schema, boolean isSalted, PName tenantId, boolean isMultiTenantTable, boolean isSharedIndex) throws SQLException {
        return isMultiTenantTable ? ScanUtil.getTenantIdBytes(schema, isSalted, tenantId, isSharedIndex) : tenantId.getBytes();
    }

    public static byte[] getTenantIdBytes(RowKeySchema schema, boolean isSalted, PName tenantId, boolean isSharedIndex) throws SQLException {
        byte[] convertedValue;
        int pkPos = (isSalted ? 1 : 0) + (isSharedIndex ? 1 : 0);
        ValueSchema.Field field = schema.getField(pkPos);
        PDataType dataType = field.getDataType();
        try {
            Object value = dataType.toObject(tenantId.getString());
            convertedValue = dataType.toBytes(value);
            ImmutableBytesWritable ptr = new ImmutableBytesWritable(convertedValue);
            dataType.pad(ptr, field.getMaxLength(), field.getSortOrder());
            convertedValue = ByteUtil.copyKeyBytesIfNecessary(ptr);
        }
        catch (IllegalDataException ex) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TENANTID_IS_OF_WRONG_TYPE).build().buildException();
        }
        return convertedValue;
    }

    public static Iterator<Filter> getFilterIterator(Scan scan) {
        Filter topLevelFilter = scan.getFilter();
        Object filterIterator = topLevelFilter == null ? Collections.emptyIterator() : (topLevelFilter instanceof FilterList ? ((FilterList)topLevelFilter).getFilters().iterator() : Iterators.singletonIterator((Object)topLevelFilter));
        return filterIterator;
    }

    public static boolean isRoundRobinPossible(OrderByCompiler.OrderBy orderBy, StatementContext context) throws SQLException {
        int fetchSize = context.getStatement().getFetchSize();
        return fetchSize > 1 && !ScanUtil.shouldRowsBeInRowKeyOrder(orderBy, context) && orderBy.getOrderByExpressions().isEmpty();
    }

    public static boolean forceRowKeyOrder(StatementContext context) {
        return context.getConnection().getQueryServices().getProps().getBoolean("phoenix.query.force.rowkeyorder", false);
    }

    public static boolean shouldRowsBeInRowKeyOrder(OrderByCompiler.OrderBy orderBy, StatementContext context) {
        return ScanUtil.forceRowKeyOrder(context) || orderBy == OrderByCompiler.OrderBy.FWD_ROW_KEY_ORDER_BY || orderBy == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY;
    }

    public static TimeRange intersectTimeRange(TimeRange rowTimestampColRange, TimeRange scanTimeRange, Long scn) throws IOException, SQLException {
        long scnToUse = scn == null ? Long.MAX_VALUE : scn;
        long lowerRangeToBe = 0L;
        long upperRangeToBe = scnToUse;
        if (rowTimestampColRange != null) {
            long minRowTimestamp = rowTimestampColRange.getMin();
            long maxRowTimestamp = rowTimestampColRange.getMax();
            if (lowerRangeToBe > maxRowTimestamp || upperRangeToBe < minRowTimestamp) {
                return null;
            }
            lowerRangeToBe = Math.max(lowerRangeToBe, minRowTimestamp);
            upperRangeToBe = Math.min(upperRangeToBe, maxRowTimestamp);
        }
        if (scanTimeRange != null) {
            long minScanTimeRange = scanTimeRange.getMin();
            long maxScanTimeRange = scanTimeRange.getMax();
            if (lowerRangeToBe > maxScanTimeRange || upperRangeToBe < lowerRangeToBe) {
                return null;
            }
            lowerRangeToBe = Math.max(lowerRangeToBe, minScanTimeRange);
            upperRangeToBe = Math.min(upperRangeToBe, maxScanTimeRange);
        }
        return new TimeRange(lowerRangeToBe, upperRangeToBe);
    }

    public static boolean isDefaultTimeRange(TimeRange range) {
        return range.getMin() == 0L && range.getMax() == Long.MAX_VALUE;
    }

    public static boolean isPacingScannersPossible(StatementContext context) {
        return context.getConnection().getQueryServices().isRenewingLeasesEnabled();
    }

    public static void addOffsetAttribute(Scan scan, Integer offset) {
        scan.setAttribute("_RowOffset", Bytes.toBytes((int)offset));
    }

    public static final boolean canQueryBeExecutedSerially(PTable table, OrderByCompiler.OrderBy orderBy, StatementContext context) {
        return orderBy.getOrderByExpressions().isEmpty() && (table.getBucketNum() == null && table.getIndexType() != PTable.IndexType.LOCAL || !ScanUtil.shouldRowsBeInRowKeyOrder(orderBy, context));
    }

    public static boolean hasDynamicColumns(PTable table) {
        for (PColumn col : table.getColumns()) {
            if (!col.isDynamic()) continue;
            return true;
        }
        return false;
    }

    public static boolean isIndexRebuild(Scan scan) {
        return scan.getAttribute("_RebuildIndexes") != null;
    }

    public static int getClientVersion(Scan scan) {
        int clientVersion = UNKNOWN_CLIENT_VERSION;
        byte[] clientVersionBytes = scan.getAttribute("_ClientVersion");
        if (clientVersionBytes != null) {
            clientVersion = Bytes.toInt((byte[])clientVersionBytes);
        }
        return clientVersion;
    }

    public static void setClientVersion(Scan scan, int version) {
        scan.setAttribute("_ClientVersion", Bytes.toBytes((int)version));
    }

    public static boolean isServerSideMaskingEnabled(PhoenixConnection phoenixConnection) {
        String isServerSideMaskingSet = phoenixConnection.getClientInfo("phoenix.ttl.server_side.masking.enabled");
        return phoenixConnection.getQueryServices().getConfiguration().getBoolean("phoenix.ttl.server_side.masking.enabled", true) || isServerSideMaskingSet != null && Boolean.parseBoolean(isServerSideMaskingSet);
    }

    public static long getPhoenixTTL(Scan scan) {
        byte[] phoenixTTL = scan.getAttribute("_PhoenixTTL");
        if (phoenixTTL == null) {
            return 0L;
        }
        return Bytes.toLong((byte[])phoenixTTL);
    }

    public static boolean isMaskTTLExpiredRows(Scan scan) {
        return scan.getAttribute("_MASK_TTL_EXPIRED") != null && Bytes.compareTo((byte[])scan.getAttribute("_MASK_TTL_EXPIRED"), (byte[])PDataType.TRUE_BYTES) == 0 && scan.getAttribute("_PhoenixTTL") != null;
    }

    public static boolean isDeleteTTLExpiredRows(Scan scan) {
        return scan.getAttribute("_DELETE_TTL_EXPIRED") != null && Bytes.compareTo((byte[])scan.getAttribute("_DELETE_TTL_EXPIRED"), (byte[])PDataType.TRUE_BYTES) == 0 && scan.getAttribute("_PhoenixTTL") != null;
    }

    public static boolean isEmptyColumn(Cell cell, byte[] emptyCF, byte[] emptyCQ) {
        return Bytes.compareTo((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength(), (byte[])emptyCF, (int)0, (int)emptyCF.length) == 0 && Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])emptyCQ, (int)0, (int)emptyCQ.length) == 0;
    }

    public static long getMaxTimestamp(List<Cell> cellList) {
        long maxTs = 0L;
        long ts = 0L;
        for (Cell cell : cellList) {
            ts = cell.getTimestamp();
            if (ts <= maxTs) continue;
            maxTs = ts;
        }
        return maxTs;
    }

    public static boolean isTTLExpired(Cell cell, Scan scan, long nowTS) {
        long ttl;
        long ts = cell.getTimestamp();
        return ts + (ttl = ScanUtil.getPhoenixTTL(scan)) < nowTS;
    }

    private static boolean containsOneOrMoreColumn(Scan scan) {
        Map familyMap = scan.getFamilyMap();
        if (familyMap == null || familyMap.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : familyMap.entrySet()) {
            NavigableSet family = (NavigableSet)entry.getValue();
            if (family == null || family.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static boolean addEmptyColumnToFilter(Scan scan, byte[] emptyCF, byte[] emptyCQ, Filter filter, boolean addedEmptyColumn) {
        if (filter instanceof EncodedQualifiersColumnProjectionFilter) {
            ((EncodedQualifiersColumnProjectionFilter)filter).addTrackedColumn(QueryConstants.ENCODED_EMPTY_COLUMN_NAME);
            if (!addedEmptyColumn && ScanUtil.containsOneOrMoreColumn(scan)) {
                scan.addColumn(emptyCF, emptyCQ);
                return true;
            }
        } else if (filter instanceof ColumnProjectionFilter) {
            ((ColumnProjectionFilter)filter).addTrackedColumn(new ImmutableBytesPtr(emptyCF), new ImmutableBytesPtr(emptyCQ));
            if (!addedEmptyColumn && ScanUtil.containsOneOrMoreColumn(scan)) {
                scan.addColumn(emptyCF, emptyCQ);
                return true;
            }
        } else if (filter instanceof MultiEncodedCQKeyValueComparisonFilter) {
            ((MultiEncodedCQKeyValueComparisonFilter)filter).setMinQualifier(QueryConstants.ENCODED_EMPTY_COLUMN_NAME);
        } else if (!addedEmptyColumn && filter instanceof FirstKeyOnlyFilter) {
            scan.addColumn(emptyCF, emptyCQ);
            return true;
        }
        return addedEmptyColumn;
    }

    private static boolean addEmptyColumnToFilterList(Scan scan, byte[] emptyCF, byte[] emptyCQ, FilterList filterList, boolean addedEmptyColumn) {
        for (Filter filter : filterList.getFilters()) {
            if (filter instanceof FilterList) {
                if (!ScanUtil.addEmptyColumnToFilterList(scan, emptyCF, emptyCQ, (FilterList)filter, addedEmptyColumn)) continue;
                addedEmptyColumn = true;
                continue;
            }
            if (!ScanUtil.addEmptyColumnToFilter(scan, emptyCF, emptyCQ, filter, addedEmptyColumn)) continue;
            addedEmptyColumn = true;
        }
        return addedEmptyColumn;
    }

    public static void addEmptyColumnToScan(Scan scan, byte[] emptyCF, byte[] emptyCQ) {
        boolean addedEmptyColumn = false;
        Filter filter = scan.getFilter();
        if (filter != null) {
            if (filter instanceof FilterList) {
                if (ScanUtil.addEmptyColumnToFilterList(scan, emptyCF, emptyCQ, (FilterList)filter, addedEmptyColumn)) {
                    addedEmptyColumn = true;
                }
            } else if (ScanUtil.addEmptyColumnToFilter(scan, emptyCF, emptyCQ, filter, addedEmptyColumn)) {
                addedEmptyColumn = true;
            }
        }
        if (!addedEmptyColumn && ScanUtil.containsOneOrMoreColumn(scan)) {
            scan.addColumn(emptyCF, emptyCQ);
        }
    }

    public static void setScanAttributesForIndexReadRepair(Scan scan, PTable table, PhoenixConnection phoenixConnection) throws SQLException {
        PTable dataTable;
        if (table.isTransactional() || table.getType() != PTableType.INDEX) {
            return;
        }
        PTable indexTable = table;
        if (indexTable.getIndexType() != PTable.IndexType.GLOBAL) {
            return;
        }
        String schemaName = indexTable.getParentSchemaName().getString();
        String tableName = indexTable.getParentTableName().getString();
        try {
            dataTable = PhoenixRuntime.getTable(phoenixConnection, SchemaUtil.getTableName(schemaName, tableName));
        }
        catch (TableNotFoundException e) {
            return;
        }
        if (indexTable.getViewIndexId() != null && indexTable.getName().getString().contains("#")) {
            int lastIndexOf = indexTable.getName().getString().lastIndexOf("#");
            String indexName = indexTable.getName().getString().substring(lastIndexOf + 1);
            indexTable = PhoenixRuntime.getTable(phoenixConnection, indexName);
        }
        if (!dataTable.getIndexes().contains(indexTable)) {
            return;
        }
        if (scan.getAttribute("IdxProtoMD") == null) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            IndexMaintainer.serialize(dataTable, ptr, Collections.singletonList(indexTable), phoenixConnection);
            scan.setAttribute("IdxProtoMD", ByteUtil.copyKeyBytesIfNecessary(ptr));
        }
        scan.setAttribute("_CheckVerifyColumn", PDataType.TRUE_BYTES);
        scan.setAttribute("_PhysicalDataTableName", dataTable.getPhysicalName().getBytes());
        IndexMaintainer indexMaintainer = indexTable.getIndexMaintainer(dataTable, phoenixConnection);
        byte[] emptyCF = indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary();
        byte[] emptyCQ = indexMaintainer.getEmptyKeyValueQualifier();
        scan.setAttribute("_EmptyCFName", emptyCF);
        scan.setAttribute("_EmptyCQName", emptyCQ);
        if (scan.getAttribute("_ViewConstants") == null) {
            BaseQueryPlan.serializeViewConstantsIntoScan(scan, dataTable);
        }
    }

    public static void setScanAttributesForPhoenixTTL(Scan scan, PTable table, PhoenixConnection phoenixConnection) throws SQLException {
        if (!ScanUtil.isServerSideMaskingEnabled(phoenixConnection) || SchemaUtil.isSystemTable(SchemaUtil.getTableNameAsBytes(table.getSchemaName().getString(), table.getTableName().getString()))) {
            return;
        }
        PTable dataTable = table;
        String tableName = table.getTableName().getString();
        if (table.getType() == PTableType.INDEX && table.getParentName() != null) {
            String parentSchemaName = table.getParentSchemaName().getString();
            String parentTableName = table.getParentTableName().getString();
            if (tableName.contains("#")) {
                String parentViewName = SchemaUtil.getSchemaNameFromFullName(tableName, "#");
                parentSchemaName = SchemaUtil.getSchemaNameFromFullName(parentViewName);
                parentTableName = SchemaUtil.getTableNameFromFullName(parentViewName);
            }
            try {
                dataTable = PhoenixRuntime.getTable(phoenixConnection, SchemaUtil.getTableName(parentSchemaName, parentTableName));
            }
            catch (TableNotFoundException e) {
                return;
            }
        }
        if (dataTable.getPhoenixTTL() != 0L) {
            byte[] emptyColumnFamilyName = SchemaUtil.getEmptyColumnFamily(table);
            byte[] emptyColumnName = table.getEncodingScheme() == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? QueryConstants.EMPTY_COLUMN_BYTES : table.getEncodingScheme().encode(QueryConstants.ENCODED_EMPTY_COLUMN_NAME);
            scan.setAttribute("_PhoenixTTLScanTableName", Bytes.toBytes((String)tableName));
            scan.setAttribute("_EmptyCFName", emptyColumnFamilyName);
            scan.setAttribute("_EmptyCQName", emptyColumnName);
            scan.setAttribute("_PhoenixTTL", Bytes.toBytes((long)dataTable.getPhoenixTTL()));
            if (!ScanUtil.isDeleteTTLExpiredRows(scan)) {
                scan.setAttribute("_MASK_TTL_EXPIRED", PDataType.TRUE_BYTES);
            }
            if (ScanUtil.isLocalIndex(scan)) {
                byte[] actualStartRow = scan.getAttribute("_ScanActualStartRow") != null ? scan.getAttribute("_ScanActualStartRow") : HConstants.EMPTY_BYTE_ARRAY;
                ScanUtil.setLocalIndexAttributes(scan, 0, actualStartRow, HConstants.EMPTY_BYTE_ARRAY, scan.getStartRow(), scan.getStopRow());
            }
        }
    }

    public static void setScanAttributesForClient(Scan scan, PTable table, PhoenixConnection phoenixConnection) throws SQLException {
        ScanUtil.setScanAttributesForIndexReadRepair(scan, table, phoenixConnection);
        ScanUtil.setScanAttributesForPhoenixTTL(scan, table, phoenixConnection);
        byte[] emptyCF = scan.getAttribute("_EmptyCFName");
        byte[] emptyCQ = scan.getAttribute("_EmptyCQName");
        if (emptyCF != null && emptyCQ != null) {
            ScanUtil.addEmptyColumnToScan(scan, emptyCF, emptyCQ);
        }
        if (phoenixConnection.getQueryServices().getProps().getBoolean("phoenix.server.paging.enabled", true)) {
            long pageSizeMs = phoenixConnection.getQueryServices().getProps().getInt("phoenix.server.page.size.ms", -1);
            if (pageSizeMs == -1L) {
                pageSizeMs = (long)((double)phoenixConnection.getQueryServices().getProps().getLong("hbase.rpc.timeout", 60000L) * 0.5);
            }
            scan.setAttribute("_ServerPageSizeMs", Bytes.toBytes((long)pageSizeMs));
        }
    }

    public static void getDummyResult(byte[] rowKey, List<Cell> result) {
        Cell keyValue = PhoenixKeyValueUtil.newKeyValue(rowKey, 0, rowKey.length, ByteUtil.EMPTY_BYTE_ARRAY, ByteUtil.EMPTY_BYTE_ARRAY, 0L, ByteUtil.EMPTY_BYTE_ARRAY, 0, ByteUtil.EMPTY_BYTE_ARRAY.length);
        result.add(keyValue);
    }

    public static void getDummyResult(List<Cell> result) {
        ScanUtil.getDummyResult(ByteUtil.EMPTY_BYTE_ARRAY, result);
    }

    public static Tuple getDummyTuple(byte[] rowKey) {
        ArrayList<Cell> result = new ArrayList<Cell>(1);
        ScanUtil.getDummyResult(rowKey, result);
        return new ResultTuple(Result.create(result));
    }

    public static Tuple getDummyTuple() {
        ArrayList<Cell> result = new ArrayList<Cell>(1);
        ScanUtil.getDummyResult(result);
        return new ResultTuple(Result.create(result));
    }

    public static Tuple getDummyTuple(Tuple tuple) {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        tuple.getKey(ptr);
        return ScanUtil.getDummyTuple(ptr.copyBytes());
    }

    public static boolean isDummy(Cell cell) {
        return CellUtil.matchingColumn((Cell)cell, (byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])ByteUtil.EMPTY_BYTE_ARRAY);
    }

    public static boolean isDummy(Result result) {
        if (result.rawCells().length != 1) {
            return false;
        }
        Cell cell = result.rawCells()[0];
        return ScanUtil.isDummy(cell);
    }

    public static boolean isDummy(List<Cell> result) {
        if (result.size() != 1) {
            return false;
        }
        Cell cell = result.get(0);
        return ScanUtil.isDummy(cell);
    }

    public static boolean isDummy(Tuple tuple) {
        if (tuple instanceof ResultTuple) {
            ScanUtil.isDummy(((ResultTuple)tuple).getResult());
        }
        return false;
    }

    public static PagedFilter getPhoenixPagedFilter(Scan scan) {
        Filter filter = scan.getFilter();
        if (filter != null && filter instanceof PagedFilter) {
            PagedFilter pageFilter = (PagedFilter)filter;
            return pageFilter;
        }
        return null;
    }

    private static long getPageSizeMs(Scan scan, double factor) {
        long pageSizeMs = Long.MAX_VALUE;
        byte[] pageSizeMsBytes = scan.getAttribute("_ServerPageSizeMs");
        if (pageSizeMsBytes != null) {
            pageSizeMs = Bytes.toLong((byte[])pageSizeMsBytes);
            pageSizeMs = (long)((double)pageSizeMs * factor);
        }
        return pageSizeMs;
    }

    public static long getPageSizeMsForRegionScanner(Scan scan) {
        return ScanUtil.getPageSizeMs(scan, 0.6);
    }

    public static long getPageSizeMsForFilter(Scan scan) {
        return ScanUtil.getPageSizeMs(scan, 0.3);
    }

    public static void setWALAnnotationAttributes(PTable table, Scan scan) {
        if (table.isChangeDetectionEnabled()) {
            if (table.getTenantId() != null) {
                scan.setAttribute(MutationState.MutationMetadataType.TENANT_ID.toString(), table.getTenantId().getBytes());
            }
            scan.setAttribute(MutationState.MutationMetadataType.SCHEMA_NAME.toString(), table.getSchemaName().getBytes());
            scan.setAttribute(MutationState.MutationMetadataType.LOGICAL_TABLE_NAME.toString(), table.getTableName().getBytes());
            scan.setAttribute(MutationState.MutationMetadataType.TABLE_TYPE.toString(), table.getType().getValue().getBytes());
            scan.setAttribute(MutationState.MutationMetadataType.TIMESTAMP.toString(), Bytes.toBytes((long)table.getLastDDLTimestamp()));
        }
    }

    static {
        Arrays.fill(MAX_FILL_LENGTH_FOR_PREVIOUS_KEY, (byte)-1);
        ZERO_BYTE_ARRAY = new byte[1024];
        DESC_VAR_WIDTH_COMPARATOR = new BytesComparator(){

            @Override
            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
                return DescVarLengthFastByteComparisons.compareTo(b1, s1, l1, b2, s2, l2);
            }
        };
        ASC_FIXED_WIDTH_COMPARATOR = new BytesComparator(){

            @Override
            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
                return WritableComparator.compareBytes((byte[])b1, (int)s1, (int)l1, (byte[])b2, (int)s2, (int)l2);
            }
        };
    }

    public static interface BytesComparator {
        public int compare(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);
    }
}

