/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.util.List;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.AggregateFunctionParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.ParseNode;

public class AggregateFunctionWithinGroupParseNode
extends AggregateFunctionParseNode {
    public AggregateFunctionWithinGroupParseNode(String name, List<ParseNode> children, FunctionParseNode.BuiltInFunctionInfo info) {
        super(name, children, info);
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        buf.append(' ');
        buf.append(this.getName());
        buf.append('(');
        List<ParseNode> children = this.getChildren();
        List<ParseNode> args = children.subList(2, children.size());
        if (!args.isEmpty()) {
            for (ParseNode child : args) {
                child.toSQL(resolver, buf);
                buf.append(',');
            }
            buf.setLength(buf.length() - 1);
        }
        buf.append(')');
        buf.append(" WITHIN GROUP (ORDER BY ");
        children.get(0).toSQL(resolver, buf);
        buf.append(" " + (LiteralParseNode.TRUE.equals(children.get(1)) ? "ASC" : "DESC"));
        buf.append(')');
    }
}

