/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.bulkload;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public class TableRowkeyPair
implements WritableComparable<TableRowkeyPair> {
    private String tableName;
    private ImmutableBytesWritable rowkey;

    public TableRowkeyPair() {
    }

    public TableRowkeyPair(String tableName, ImmutableBytesWritable rowkey) {
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull((Object)rowkey);
        this.tableName = tableName;
        this.rowkey = rowkey;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ImmutableBytesWritable getRowkey() {
        return this.rowkey;
    }

    public void setRowkey(ImmutableBytesWritable rowkey) {
        this.rowkey = rowkey;
    }

    public void readFields(DataInput input) throws IOException {
        this.tableName = WritableUtils.readString((DataInput)input);
        this.rowkey = new ImmutableBytesWritable();
        this.rowkey.readFields(input);
    }

    public void write(DataOutput output) throws IOException {
        WritableUtils.writeString((DataOutput)output, (String)this.tableName);
        this.rowkey.write(output);
    }

    public int hashCode() {
        int result = this.tableName.hashCode();
        result = 31 * result + this.rowkey.hashCode();
        return result;
    }

    public int compareTo(TableRowkeyPair other) {
        String otherTableName = other.getTableName();
        if (this.tableName.equals(otherTableName)) {
            return this.rowkey.compareTo(other.getRowkey());
        }
        return this.tableName.compareTo(otherTableName);
    }

    static {
        WritableComparator.define(TableRowkeyPair.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(TableRowkeyPair.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                int strL1 = Comparator.readInt((byte[])b1, (int)s1);
                int strL2 = Comparator.readInt((byte[])b2, (int)s2);
                int cmp = Comparator.compareBytes((byte[])b1, (int)(s1 + 4), (int)strL1, (byte[])b2, (int)(s2 + 4), (int)strL2);
                if (cmp != 0) {
                    return cmp;
                }
                int strL3 = Comparator.readInt((byte[])b1, (int)(s1 + 4 + strL1));
                int strL4 = Comparator.readInt((byte[])b2, (int)(s2 + 4 + strL2));
                int i = Comparator.compareBytes((byte[])b1, (int)(s1 + 8 + strL1), (int)strL3, (byte[])b2, (int)(s2 + 8 + strL2), (int)strL4);
                return i;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }
}

