/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.thirdparty.com.google.common.base.Predicate;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterables;
import org.apache.phoenix.util.EncodedColumnsUtil;

public class ColumnProjectionFilter
extends FilterBase
implements Writable {
    private byte[] emptyCFName;
    private Map<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>> columnsTracker;
    private Set<byte[]> conditionOnlyCfs;
    private boolean usesEncodedColumnNames;
    private byte[] emptyKVQualifier;
    private ImmutableBytesPtr ptr = new ImmutableBytesPtr();

    public ColumnProjectionFilter() {
    }

    public ColumnProjectionFilter(byte[] emptyCFName, Map<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>> columnsTracker, Set<byte[]> conditionOnlyCfs, boolean usesEncodedColumnNames) {
        this.emptyCFName = emptyCFName;
        this.columnsTracker = columnsTracker;
        this.conditionOnlyCfs = conditionOnlyCfs;
        this.usesEncodedColumnNames = usesEncodedColumnNames;
        this.emptyKVQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(usesEncodedColumnNames).getFirst();
    }

    public void readFields(DataInput input) throws IOException {
        int familyMapSize;
        this.emptyCFName = WritableUtils.readCompressedByteArray((DataInput)input);
        assert (familyMapSize > 0);
        this.columnsTracker = new TreeMap<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>>();
        for (familyMapSize = WritableUtils.readVInt((DataInput)input); familyMapSize > 0; --familyMapSize) {
            int qualifiersSize;
            byte[] cf = WritableUtils.readCompressedByteArray((DataInput)input);
            TreeSet<ImmutableBytesPtr> qualifiers = null;
            if (qualifiersSize > 0) {
                qualifiers = new TreeSet<ImmutableBytesPtr>();
                for (qualifiersSize = WritableUtils.readVInt((DataInput)input); qualifiersSize > 0; --qualifiersSize) {
                    qualifiers.add(new ImmutableBytesPtr(WritableUtils.readCompressedByteArray((DataInput)input)));
                }
            }
            this.columnsTracker.put(new ImmutableBytesPtr(cf), qualifiers);
        }
        int conditionOnlyCfsSize = WritableUtils.readVInt((DataInput)input);
        this.usesEncodedColumnNames = conditionOnlyCfsSize > 0;
        this.emptyKVQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo(this.usesEncodedColumnNames).getFirst();
        this.conditionOnlyCfs = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (conditionOnlyCfsSize = Math.abs(conditionOnlyCfsSize) - 1; conditionOnlyCfsSize > 0; --conditionOnlyCfsSize) {
            this.conditionOnlyCfs.add(WritableUtils.readCompressedByteArray((DataInput)input));
        }
    }

    public void write(DataOutput output) throws IOException {
        WritableUtils.writeCompressedByteArray((DataOutput)output, (byte[])this.emptyCFName);
        WritableUtils.writeVInt((DataOutput)output, (int)this.columnsTracker.size());
        for (Map.Entry<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>> entry : this.columnsTracker.entrySet()) {
            WritableUtils.writeCompressedByteArray((DataOutput)output, (byte[])entry.getKey().copyBytes());
            int qaulsSize = entry.getValue() == null ? 0 : entry.getValue().size();
            WritableUtils.writeVInt((DataOutput)output, (int)qaulsSize);
            if (qaulsSize <= 0) continue;
            for (ImmutableBytesPtr cq : entry.getValue()) {
                WritableUtils.writeCompressedByteArray((DataOutput)output, (byte[])cq.copyBytes());
            }
        }
        WritableUtils.writeVInt((DataOutput)output, (int)((this.conditionOnlyCfs.size() + 1) * (this.usesEncodedColumnNames ? 1 : -1)));
        for (byte[] f : this.conditionOnlyCfs) {
            WritableUtils.writeCompressedByteArray((DataOutput)output, (byte[])f);
        }
    }

    public byte[] toByteArray() throws IOException {
        return Writables.getBytes((Writable)this);
    }

    public static ColumnProjectionFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            return (ColumnProjectionFilter)Writables.getWritable((byte[])pbBytes, (Writable)new ColumnProjectionFilter());
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
    }

    public void filterRowCells(List<Cell> kvs) throws IOException {
        if (kvs.isEmpty()) {
            return;
        }
        Cell firstKV = kvs.get(0);
        Iterables.removeIf(kvs, (Predicate)new Predicate<Cell>(){

            public boolean apply(Cell kv) {
                ColumnProjectionFilter.this.ptr.set(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength());
                if (ColumnProjectionFilter.this.columnsTracker.containsKey((Object)ColumnProjectionFilter.this.ptr)) {
                    Set cols = (Set)ColumnProjectionFilter.this.columnsTracker.get((Object)ColumnProjectionFilter.this.ptr);
                    ColumnProjectionFilter.this.ptr.set(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength());
                    return cols != null && !cols.contains((Object)ColumnProjectionFilter.this.ptr);
                }
                return true;
            }
        });
        this.ptr.set(HConstants.EMPTY_BYTE_ARRAY);
        if (kvs.isEmpty()) {
            kvs.add((Cell)new KeyValue(firstKV.getRowArray(), firstKV.getRowOffset(), (int)firstKV.getRowLength(), this.emptyCFName, 0, this.emptyCFName.length, this.emptyKVQualifier, 0, this.emptyKVQualifier.length, Long.MAX_VALUE, KeyValue.Type.Maximum, null, 0, 0));
        }
    }

    public boolean hasFilterRow() {
        return true;
    }

    public boolean isFamilyEssential(byte[] name) {
        return this.conditionOnlyCfs.isEmpty() || this.conditionOnlyCfs.contains(name);
    }

    public String toString() {
        return "";
    }

    public Filter.ReturnCode filterKeyValue(Cell ignored) throws IOException {
        return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
    }

    public void addTrackedColumn(ImmutableBytesPtr cf, ImmutableBytesPtr cq) {
        NavigableSet<ImmutableBytesPtr> columns = this.columnsTracker.get((Object)cf);
        if (columns == null) {
            columns = new TreeSet<ImmutableBytesPtr>();
            this.columnsTracker.put(cf, columns);
        }
        columns.add(cq);
    }
}

