/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import org.apache.phoenix.compile.CompiledOffset;
import org.apache.phoenix.compile.RVCOffsetCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.OffsetNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.TraverseNoParseNodeVisitor;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;

public class OffsetCompiler {
    private static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();
    private static final PDatum OFFSET_DATUM = new PDatum(){

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public PDataType getDataType() {
            return PInteger.INSTANCE;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    };
    private final RVCOffsetCompiler rvcOffsetCompiler = RVCOffsetCompiler.getInstance();
    private static final OffsetCompiler OFFSET_COMPILER = OffsetCompiler.getInstance();

    private OffsetCompiler() {
    }

    private static OffsetCompiler getInstance() {
        return new OffsetCompiler();
    }

    public static OffsetCompiler getOffsetCompiler() {
        return OFFSET_COMPILER;
    }

    public CompiledOffset compile(StatementContext context, FilterableStatement statement, boolean inJoin, boolean inUnion) throws SQLException {
        OffsetNode offsetNode = statement.getOffset();
        if (offsetNode == null) {
            return new CompiledOffset((Optional<Integer>)Optional.absent(), (Optional<byte[]>)Optional.absent());
        }
        if (offsetNode.isIntegerOffset()) {
            OffsetParseNodeVisitor visitor = new OffsetParseNodeVisitor(context);
            offsetNode.getOffsetParseNode().accept(visitor);
            Integer offset = visitor.getOffset();
            return new CompiledOffset((Optional<Integer>)Optional.fromNullable((Object)offset), (Optional<byte[]>)Optional.absent());
        }
        return this.rvcOffsetCompiler.getRVCOffset(context, statement, inJoin, inUnion, offsetNode);
    }

    private static class OffsetParseNodeVisitor
    extends TraverseNoParseNodeVisitor<Void> {
        private final StatementContext context;
        private Integer offset;

        OffsetParseNodeVisitor(StatementContext context) {
            this.context = context;
        }

        Integer getOffset() {
            return this.offset;
        }

        @Override
        public Void visit(LiteralParseNode node) throws SQLException {
            Integer offset;
            Object offsetValue = node.getValue();
            if (offsetValue != null && (offset = (Integer)OFFSET_DATUM.getDataType().toObject(offsetValue, node.getType())) >= 0) {
                this.offset = offset;
            }
            return null;
        }

        @Override
        public Void visit(BindParseNode node) throws SQLException {
            if (this.context == null) {
                return null;
            }
            Object value = this.context.getBindManager().getBindValue(node);
            this.context.getBindManager().addParamMetaData(node, OFFSET_DATUM);
            this.visit(NODE_FACTORY.literal(value, OFFSET_DATUM.getDataType()));
            return null;
        }
    }
}

