/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.google.common.base.Supplier;
import com.oracle.bmc.hdfs.util.FSStreamUtils;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.model.Range;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import java.beans.ConstructorProperties;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BmcFSInputStream
extends FSInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(BmcFSInputStream.class);
    private static final int EOF = -1;
    protected final ObjectStorage objectStorage;
    protected final FileStatus status;
    protected final Supplier<GetObjectRequest.Builder> requestBuilder;
    protected final FileSystem.Statistics statistics;
    protected InputStream sourceInputStream;
    protected long currentPosition = 0L;
    protected boolean closed = false;

    public long getPos() throws IOException {
        return this.currentPosition;
    }

    public void seek(long position) throws IOException {
        this.checkNotClosed();
        if (this.currentPosition == position) {
            LOG.debug("Already at desired position, nothing to seek");
            return;
        }
        if (position < 0L) {
            throw new EOFException("Cannot seek to a negative offset");
        }
        if (position >= this.status.getLen()) {
            throw new EOFException("Cannot seek to " + position + " (file size : " + this.status.getLen() + ")");
        }
        this.currentPosition = this.doSeek(position);
        LOG.debug("Requested seek to {}, ended at position {}", (Object)position, (Object)this.currentPosition);
    }

    protected abstract long doSeek(long var1) throws IOException;

    public boolean seekToNewSource(long arg0) throws IOException {
        return false;
    }

    public int read() throws IOException {
        this.validateState(this.currentPosition);
        int byteRead = this.sourceInputStream.read();
        if (byteRead != -1) {
            ++this.currentPosition;
            this.statistics.incrementBytesRead(1L);
        }
        return byteRead;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.validateState(this.currentPosition);
        if (len == 0) {
            return 0;
        }
        int bytesRead = this.sourceInputStream.read(b, off, len);
        if (bytesRead != -1) {
            this.currentPosition += (long)bytesRead;
            this.statistics.incrementBytesRead((long)bytesRead);
        }
        return bytesRead;
    }

    public int available() throws IOException {
        this.validateState(this.currentPosition);
        long bytesRemaining = this.status.getLen() - this.currentPosition;
        return bytesRemaining <= Integer.MAX_VALUE ? (int)bytesRemaining : Integer.MAX_VALUE;
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
        if (this.sourceInputStream != null) {
            FSStreamUtils.closeQuietly(this.sourceInputStream);
            this.sourceInputStream = null;
        }
    }

    protected InputStream wrap(InputStream rawInputStream) throws IOException {
        return rawInputStream;
    }

    protected void validateState(long startPosition) throws IOException {
        this.checkNotClosed();
        try {
            this.verifyInitialized(startPosition);
        }
        catch (BmcException e) {
            throw new IOException("Unable to initialize data", e);
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
    }

    private void verifyInitialized(long startPosition) throws IOException, BmcException {
        if (this.sourceInputStream != null) {
            return;
        }
        Range range = null;
        if (startPosition > 0L) {
            LOG.debug("Initializing with start position {}", (Object)startPosition);
            range = new Range(Long.valueOf(startPosition), null);
        }
        GetObjectRequest request = ((GetObjectRequest.Builder)this.requestBuilder.get()).range(range).build();
        GetObjectResponse response = this.objectStorage.getObject(request);
        LOG.debug("Opened object with etag {} and size {}", (Object)response.getETag(), (Object)response.getContentLength());
        InputStream dataStream = response.getInputStream();
        this.sourceInputStream = this.wrap(dataStream);
        this.currentPosition = range != null ? response.getContentRange().getStartByte() : startPosition;
    }

    @ConstructorProperties(value={"objectStorage", "status", "requestBuilder", "statistics"})
    public BmcFSInputStream(ObjectStorage objectStorage, FileStatus status, Supplier<GetObjectRequest.Builder> requestBuilder, FileSystem.Statistics statistics) {
        this.objectStorage = objectStorage;
        this.status = status;
        this.requestBuilder = requestBuilder;
        this.statistics = statistics;
    }

    protected FileSystem.Statistics getStatistics() {
        return this.statistics;
    }

    protected void setSourceInputStream(InputStream sourceInputStream) {
        this.sourceInputStream = sourceInputStream;
    }

    protected InputStream getSourceInputStream() {
        return this.sourceInputStream;
    }
}

