/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.UploadSessionCursor;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class UploadSessionAppendArg {
    protected final UploadSessionCursor cursor;
    protected final boolean close;
    protected final String contentHash;

    public UploadSessionAppendArg(UploadSessionCursor cursor, boolean close, String contentHash) {
        if (cursor == null) {
            throw new IllegalArgumentException("Required value for 'cursor' is null");
        }
        this.cursor = cursor;
        this.close = close;
        if (contentHash != null) {
            if (contentHash.length() < 64) {
                throw new IllegalArgumentException("String 'contentHash' is shorter than 64");
            }
            if (contentHash.length() > 64) {
                throw new IllegalArgumentException("String 'contentHash' is longer than 64");
            }
        }
        this.contentHash = contentHash;
    }

    public UploadSessionAppendArg(UploadSessionCursor cursor) {
        this(cursor, false, null);
    }

    public UploadSessionCursor getCursor() {
        return this.cursor;
    }

    public boolean getClose() {
        return this.close;
    }

    public String getContentHash() {
        return this.contentHash;
    }

    public static Builder newBuilder(UploadSessionCursor cursor) {
        return new Builder(cursor);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.cursor, this.close, this.contentHash});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UploadSessionAppendArg other = (UploadSessionAppendArg)obj;
            return (this.cursor == other.cursor || this.cursor.equals(other.cursor)) && this.close == other.close && (this.contentHash == other.contentHash || this.contentHash != null && this.contentHash.equals(other.contentHash));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UploadSessionAppendArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UploadSessionAppendArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("cursor");
            UploadSessionCursor.Serializer.INSTANCE.serialize(value.cursor, g);
            g.writeFieldName("close");
            StoneSerializers.boolean_().serialize((Boolean)value.close, g);
            if (value.contentHash != null) {
                g.writeFieldName("content_hash");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.contentHash, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UploadSessionAppendArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_contentHash;
            Boolean f_close;
            UploadSessionCursor f_cursor;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_cursor = null;
                f_close = false;
                f_contentHash = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("cursor".equals(field)) {
                        f_cursor = (UploadSessionCursor)UploadSessionCursor.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("close".equals(field)) {
                        f_close = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("content_hash".equals(field)) {
                        f_contentHash = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_cursor == null) {
                    throw new JsonParseException(p, "Required field \"cursor\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UploadSessionAppendArg value = new UploadSessionAppendArg(f_cursor, f_close, f_contentHash);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final UploadSessionCursor cursor;
        protected boolean close;
        protected String contentHash;

        protected Builder(UploadSessionCursor cursor) {
            if (cursor == null) {
                throw new IllegalArgumentException("Required value for 'cursor' is null");
            }
            this.cursor = cursor;
            this.close = false;
            this.contentHash = null;
        }

        public Builder withClose(Boolean close) {
            this.close = close != null ? close : false;
            return this;
        }

        public Builder withContentHash(String contentHash) {
            if (contentHash != null) {
                if (contentHash.length() < 64) {
                    throw new IllegalArgumentException("String 'contentHash' is shorter than 64");
                }
                if (contentHash.length() > 64) {
                    throw new IllegalArgumentException("String 'contentHash' is longer than 64");
                }
            }
            this.contentHash = contentHash;
            return this;
        }

        public UploadSessionAppendArg build() {
            return new UploadSessionAppendArg(this.cursor, this.close, this.contentHash);
        }
    }
}

