/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.IncludeGrantedScopes;
import com.dropbox.core.TokenAccessType;
import com.dropbox.core.android.AuthActivity;
import com.dropbox.core.oauth.DbxCredential;
import com.dropbox.core.util.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/dropbox/core/android/Auth;", "", "()V", "Companion", "dropbox-sdk-java"})
public final class Auth {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void startOAuth2Authentication(@NotNull Context context, @Nullable String appKey) {
        Companion.startOAuth2Authentication(context, appKey);
    }

    @JvmStatic
    public static final void startOAuth2Authentication(@NotNull Context context, @Nullable String appKey, @Nullable String desiredUid, @Nullable String[] alreadyAuthedUids, @Nullable String sessionId) {
        Companion.startOAuth2Authentication(context, appKey, desiredUid, alreadyAuthedUids, sessionId);
    }

    @JvmStatic
    @JvmOverloads
    public static final void startOAuth2PKCE(@NotNull Context context, @Nullable String appKey, @Nullable DbxRequestConfig requestConfig, @Nullable Collection<String> scope) {
        Companion.startOAuth2PKCE(context, appKey, requestConfig, scope);
    }

    @JvmStatic
    public static final void startOAuth2PKCE(@NotNull Context context, @Nullable String appKey, @Nullable DbxRequestConfig requestConfig, @Nullable DbxHost host) {
        Companion.startOAuth2PKCE(context, appKey, requestConfig, host);
    }

    @JvmStatic
    public static final void startOAuth2PKCE(@NotNull Context context, @Nullable String appKey, @Nullable DbxRequestConfig requestConfig, @Nullable DbxHost host, @Nullable Collection<String> scope) {
        Companion.startOAuth2PKCE(context, appKey, requestConfig, host, scope);
    }

    @JvmStatic
    public static final void startOAuth2PKCE(@NotNull Context context, @Nullable String appKey, @Nullable DbxRequestConfig requestConfig, @Nullable DbxHost host, @Nullable Collection<String> scope, @Nullable IncludeGrantedScopes includeGrantedScopes) {
        Companion.startOAuth2PKCE(context, appKey, requestConfig, host, scope, includeGrantedScopes);
    }

    @JvmStatic
    public static final void startOAuth2Authentication(@NotNull Context context, @Nullable String appKey, @Nullable String desiredUid, @Nullable String[] alreadyAuthedUids, @Nullable String sessionId, @Nullable String webHost) {
        Companion.startOAuth2Authentication(context, appKey, desiredUid, alreadyAuthedUids, sessionId, webHost);
    }

    @JvmStatic
    @Nullable
    public static final String getOAuth2Token() {
        return Companion.getOAuth2Token();
    }

    @JvmStatic
    @Nullable
    public static final String getUid() {
        return Companion.getUid();
    }

    @JvmStatic
    @Nullable
    public static final DbxCredential getDbxCredential() {
        return Companion.getDbxCredential();
    }

    @JvmStatic
    @Nullable
    public static final String getScope() {
        return Companion.getScope();
    }

    @JvmStatic
    @JvmOverloads
    public static final void startOAuth2PKCE(@NotNull Context context, @Nullable String appKey, @Nullable DbxRequestConfig requestConfig) {
        Companion.startOAuth2PKCE(context, appKey, requestConfig);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0007J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0007J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0007JC\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u0012JM\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u0014J\u008b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0012\b\u0002\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ.\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J@\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u001cH\u0007JJ\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007J8\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0012\b\u0002\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u001cH\u0007\u00a8\u0006!"}, d2={"Lcom/dropbox/core/android/Auth$Companion;", "", "()V", "getDbxCredential", "Lcom/dropbox/core/oauth/DbxCredential;", "getOAuth2Token", "", "getScope", "getUid", "startOAuth2Authentication", "", "context", "Landroid/content/Context;", "appKey", "desiredUid", "alreadyAuthedUids", "", "sessionId", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)V", "webHost", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "tokenAccessType", "Lcom/dropbox/core/TokenAccessType;", "requestConfig", "Lcom/dropbox/core/DbxRequestConfig;", "host", "Lcom/dropbox/core/DbxHost;", "scope", "", "includeGrantedScopes", "Lcom/dropbox/core/IncludeGrantedScopes;", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/dropbox/core/TokenAccessType;Lcom/dropbox/core/DbxRequestConfig;Lcom/dropbox/core/DbxHost;Ljava/util/Collection;Lcom/dropbox/core/IncludeGrantedScopes;)V", "startOAuth2PKCE", "dropbox-sdk-java"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void startOAuth2Authentication(@NotNull Context context, @Nullable String appKey) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.startOAuth2Authentication(context, appKey, null, null, null);
        }

        @JvmStatic
        public final void startOAuth2Authentication(@NotNull Context context, @Nullable String appKey, @Nullable String desiredUid, @Nullable String[] alreadyAuthedUids, @Nullable String sessionId) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.startOAuth2Authentication(context, appKey, desiredUid, alreadyAuthedUids, sessionId, "www.dropbox.com");
        }

        @JvmStatic
        @JvmOverloads
        public final void startOAuth2PKCE(@NotNull Context context, @Nullable String appKey, @Nullable DbxRequestConfig requestConfig, @Nullable Collection<String> scope) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.startOAuth2PKCE(context, appKey, requestConfig, null, scope);
        }

        public static /* synthetic */ void startOAuth2PKCE$default(Companion companion, Context context, String string, DbxRequestConfig dbxRequestConfig, Collection collection, int n, Object object) {
            if ((n & 8) != 0) {
                collection = null;
            }
            companion.startOAuth2PKCE(context, string, dbxRequestConfig, collection);
        }

        @JvmStatic
        public final void startOAuth2PKCE(@NotNull Context context, @Nullable String appKey, @Nullable DbxRequestConfig requestConfig, @Nullable DbxHost host) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (requestConfig == null) {
                boolean bl = false;
                String string = "Invalid Dbx requestConfig for PKCE flow.";
                throw new IllegalArgumentException(string.toString());
            }
            com.dropbox.core.android.Auth$Companion.startOAuth2Authentication$default(this, context, appKey, null, null, null, null, TokenAccessType.OFFLINE, requestConfig, host, null, null, 1536, null);
        }

        @JvmStatic
        public final void startOAuth2PKCE(@NotNull Context context, @Nullable String appKey, @Nullable DbxRequestConfig requestConfig, @Nullable DbxHost host, @Nullable Collection<String> scope) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (requestConfig == null) {
                boolean bl = false;
                String string = "Invalid Dbx requestConfig for PKCE flow.";
                throw new IllegalArgumentException(string.toString());
            }
            this.startOAuth2Authentication(context, appKey, null, null, null, null, TokenAccessType.OFFLINE, requestConfig, host, scope, null);
        }

        @JvmStatic
        public final void startOAuth2PKCE(@NotNull Context context, @Nullable String appKey, @Nullable DbxRequestConfig requestConfig, @Nullable DbxHost host, @Nullable Collection<String> scope, @Nullable IncludeGrantedScopes includeGrantedScopes) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (requestConfig == null) {
                boolean bl = false;
                String string = "Invalid Dbx requestConfig for PKCE flow.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(includeGrantedScopes == null || scope != null)) {
                boolean bl = false;
                String string = "If you are using includeGrantedScope, you must ask for specific new scopes";
                throw new IllegalArgumentException(string.toString());
            }
            this.startOAuth2Authentication(context, appKey, null, null, null, null, TokenAccessType.OFFLINE, requestConfig, host, scope, includeGrantedScopes);
        }

        @JvmStatic
        public final void startOAuth2Authentication(@NotNull Context context, @Nullable String appKey, @Nullable String desiredUid, @Nullable String[] alreadyAuthedUids, @Nullable String sessionId, @Nullable String webHost) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            com.dropbox.core.android.Auth$Companion.startOAuth2Authentication$default(this, context, appKey, desiredUid, alreadyAuthedUids, sessionId, webHost, null, null, null, null, null, 1536, null);
        }

        private final void startOAuth2Authentication(Context context, String appKey, String desiredUid, String[] alreadyAuthedUids, String sessionId, String webHost, TokenAccessType tokenAccessType, DbxRequestConfig requestConfig, DbxHost host, Collection<String> scope, IncludeGrantedScopes includeGrantedScopes) {
            String string = appKey;
            Intrinsics.checkNotNull((Object)string);
            if (!AuthActivity.Companion.checkAppBeforeAuth(context, string, true)) {
                return;
            }
            if (!(alreadyAuthedUids == null || !Arrays.asList(Arrays.copyOf(alreadyAuthedUids, alreadyAuthedUids.length)).contains(desiredUid))) {
                boolean $i$a$-require-Auth$Companion$startOAuth2Authentication$22 = false;
                String $i$a$-require-Auth$Companion$startOAuth2Authentication$22 = "desiredUid cannot be present in alreadyAuthedUids";
                throw new IllegalArgumentException($i$a$-require-Auth$Companion$startOAuth2Authentication$22.toString());
            }
            String scopeString = null;
            if (scope != null) {
                scopeString = StringUtil.join(scope, " ");
            }
            String apiType = "1";
            Intent intent = AuthActivity.Companion.makeIntent$dropbox_sdk_java(context, appKey, desiredUid, alreadyAuthedUids, sessionId, webHost, apiType, tokenAccessType, requestConfig, host, scopeString, includeGrantedScopes);
            if (!(context instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            context.startActivity(intent);
        }

        static /* synthetic */ void startOAuth2Authentication$default(Companion companion, Context context, String string, String string2, String[] stringArray, String string3, String string4, TokenAccessType tokenAccessType, DbxRequestConfig dbxRequestConfig, DbxHost dbxHost, Collection collection, IncludeGrantedScopes includeGrantedScopes, int n, Object object) {
            if ((n & 0x200) != 0) {
                collection = null;
            }
            if ((n & 0x400) != 0) {
                includeGrantedScopes = null;
            }
            companion.startOAuth2Authentication(context, string, string2, stringArray, string3, string4, tokenAccessType, dbxRequestConfig, dbxHost, collection, includeGrantedScopes);
        }

        @JvmStatic
        @Nullable
        public final String getOAuth2Token() {
            DbxCredential dbxCredential = this.getDbxCredential();
            if (dbxCredential == null) {
                return null;
            }
            DbxCredential credential = dbxCredential;
            return credential.getAccessToken();
        }

        @JvmStatic
        @Nullable
        public final String getUid() {
            Intent data;
            if (this.getDbxCredential() == null) {
                return null;
            }
            Intent intent = data = AuthActivity.result;
            Intrinsics.checkNotNull((Object)intent);
            return intent.getStringExtra("UID");
        }

        @JvmStatic
        @Nullable
        public final DbxCredential getDbxCredential() {
            Intent intent = AuthActivity.result;
            if (intent == null) {
                return null;
            }
            Intent data = intent;
            String token = data.getStringExtra("ACCESS_TOKEN");
            String secret = data.getStringExtra("ACCESS_SECRET");
            String uid = data.getStringExtra("UID");
            if (token == null || Intrinsics.areEqual((Object)"", (Object)token) || secret == null || Intrinsics.areEqual((Object)"", (Object)secret) || uid == null || Intrinsics.areEqual((Object)"", (Object)uid)) {
                return null;
            }
            String appKey = data.getStringExtra("CONSUMER_KEY");
            String refreshToken = data.getStringExtra("REFRESH_TOKEN");
            long expiresAt = data.getLongExtra("EXPIRES_AT", -1L);
            Long nullableExpiresAt = expiresAt >= 0L ? Long.valueOf(expiresAt) : null;
            return new DbxCredential(secret, nullableExpiresAt, refreshToken, appKey);
        }

        @JvmStatic
        @Nullable
        public final String getScope() {
            Intent intent = AuthActivity.result;
            if (intent == null) {
                return null;
            }
            Intent data = intent;
            return data.getStringExtra("SCOPE");
        }

        @JvmStatic
        @JvmOverloads
        public final void startOAuth2PKCE(@NotNull Context context, @Nullable String appKey, @Nullable DbxRequestConfig requestConfig) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            com.dropbox.core.android.Auth$Companion.startOAuth2PKCE$default(this, context, appKey, requestConfig, null, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

