/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo.plan;

import com.mongodb.client.model.Aggregates;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.Pair;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.common.DrillLimitRelBase;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.mongo.MongoAggregateUtils;
import org.apache.drill.exec.store.mongo.MongoFilterBuilder;
import org.apache.drill.exec.store.mongo.MongoGroupScan;
import org.apache.drill.exec.store.mongo.MongoScanSpec;
import org.apache.drill.exec.store.mongo.MongoStoragePlugin;
import org.apache.drill.exec.store.mongo.plan.RexToMongoTranslator;
import org.apache.drill.exec.store.plan.AbstractPluginImplementor;
import org.apache.drill.exec.store.plan.rel.PluginAggregateRel;
import org.apache.drill.exec.store.plan.rel.PluginFilterRel;
import org.apache.drill.exec.store.plan.rel.PluginLimitRel;
import org.apache.drill.exec.store.plan.rel.PluginProjectRel;
import org.apache.drill.exec.store.plan.rel.PluginSortRel;
import org.apache.drill.exec.store.plan.rel.PluginUnionRel;
import org.apache.drill.exec.store.plan.rel.StoragePluginTableScan;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoPluginImplementor
extends AbstractPluginImplementor {
    private MongoGroupScan groupScan;
    private List<Bson> operations;
    private Document filters;
    private List<SchemaPath> columns;
    private boolean runAggregate;

    public void implement(PluginAggregateRel aggregate) throws IOException {
        this.runAggregate = true;
        this.visitChild(aggregate.getInput());
        this.operations.addAll(MongoAggregateUtils.getAggregateOperations((Aggregate)aggregate, aggregate.getInput().getRowType()));
        List<String> outNames = MongoAggregateUtils.mongoFieldNames(aggregate.getRowType());
        this.columns = outNames.stream().map(SchemaPath::getSimplePath).collect(Collectors.toList());
    }

    public void implement(PluginFilterRel filter) throws IOException {
        this.visitChild(filter.getInput());
        LogicalExpression conditionExp = DrillOptiq.toDrill((DrillParseContext)new DrillParseContext(PrelUtil.getPlannerSettings((RelOptPlanner)filter.getCluster().getPlanner())), (RelNode)filter.getInput(), (RexNode)filter.getCondition());
        MongoFilterBuilder mongoFilterBuilder = new MongoFilterBuilder(conditionExp);
        if (this.runAggregate) {
            BsonDocument convertedFilterExpression = Aggregates.match((Bson)mongoFilterBuilder.parseTree()).toBsonDocument();
            this.operations.add((Bson)convertedFilterExpression);
        } else {
            this.filters = mongoFilterBuilder.parseTree();
        }
    }

    public void implement(PluginLimitRel limit) throws IOException {
        this.runAggregate = true;
        this.visitChild(limit.getInput());
        if (limit.getOffset() != null) {
            this.operations.add((Bson)Aggregates.skip((int)this.rexLiteralIntValue((RexLiteral)limit.getOffset())).toBsonDocument());
        }
        if (limit.getFetch() != null) {
            this.operations.add((Bson)Aggregates.limit((int)this.rexLiteralIntValue((RexLiteral)limit.getFetch())).toBsonDocument());
        }
    }

    public void implement(PluginProjectRel project) throws IOException {
        this.runAggregate = this.runAggregate || project.getProjects().stream().anyMatch(expression -> !expression.isA(SqlKind.INPUT_REF));
        this.visitChild(project.getInput());
        if (this.runAggregate) {
            RexToMongoTranslator translator = new RexToMongoTranslator((JavaTypeFactory)project.getCluster().getTypeFactory(), MongoAggregateUtils.mongoFieldNames(project.getInput().getRowType()));
            ArrayList<BsonElement> items = new ArrayList<BsonElement>();
            for (Pair pair : project.getNamedProjects()) {
                String name = (String)pair.right;
                BsonValue expr = (BsonValue)((RexNode)pair.left).accept((RexVisitor)translator);
                items.add(expr.equals(new BsonString("$" + name)) ? new BsonElement(MongoAggregateUtils.maybeQuote(name), (BsonValue)new BsonInt32(1)) : new BsonElement(MongoAggregateUtils.maybeQuote(name), expr));
            }
            BsonDocument projection = Aggregates.project((Bson)new BsonDocument(items)).toBsonDocument();
            this.operations.add((Bson)projection);
            List<String> outNames = MongoAggregateUtils.mongoFieldNames(project.getRowType());
            this.columns = outNames.stream().map(SchemaPath::getSimplePath).collect(Collectors.toList());
        } else {
            List<String> outNames = MongoAggregateUtils.mongoFieldNames(project.getRowType());
            this.columns = outNames.stream().map(SchemaPath::getSimplePath).collect(Collectors.toList());
        }
    }

    public void implement(PluginSortRel sort) throws IOException {
        this.runAggregate = true;
        this.visitChild(sort.getInput());
        if (!sort.collation.getFieldCollations().isEmpty()) {
            BsonDocument sortKeys = new BsonDocument();
            List fields = sort.getRowType().getFieldList();
            for (RelFieldCollation fieldCollation : sort.collation.getFieldCollations()) {
                String name = ((RelDataTypeField)fields.get(fieldCollation.getFieldIndex())).getName();
                sortKeys.put(name, (BsonValue)new BsonInt32(MongoPluginImplementor.direction(fieldCollation)));
            }
            this.operations.add((Bson)Aggregates.sort((Bson)sortKeys).toBsonDocument());
        }
        if (sort.offset != null) {
            this.operations.add((Bson)Aggregates.skip((int)this.rexLiteralIntValue((RexLiteral)sort.offset)).toBsonDocument());
        }
        if (sort.fetch != null) {
            this.operations.add((Bson)Aggregates.limit((int)this.rexLiteralIntValue((RexLiteral)sort.fetch)).toBsonDocument());
        }
    }

    private int rexLiteralIntValue(RexLiteral offset) {
        return ((BigDecimal)offset.getValue()).intValue();
    }

    public void implement(PluginUnionRel union) throws IOException {
        this.runAggregate = true;
        MongoPluginImplementor childImplementor = new MongoPluginImplementor();
        childImplementor.runAggregate = true;
        boolean firstProcessed = false;
        for (RelNode input : union.getInputs()) {
            if (!firstProcessed) {
                this.visitChild(input);
                firstProcessed = true;
                continue;
            }
            childImplementor.visitChild(input);
            this.operations.add((Bson)Aggregates.unionWith((String)childImplementor.groupScan.getScanSpec().getCollectionName(), childImplementor.operations).toBsonDocument());
        }
    }

    public void implement(StoragePluginTableScan scan) {
        this.groupScan = (MongoGroupScan)scan.getGroupScan();
        this.operations = this.groupScan.getScanSpec().getOperations().stream().map(BsonDocument::parse).collect(Collectors.toList());
        this.filters = Optional.ofNullable(this.groupScan.getScanSpec().getFilters()).map(Document::parse).orElse(null);
        this.columns = this.groupScan.getColumns();
    }

    public boolean canImplement(Aggregate aggregate) {
        return this.hasPluginGroupScan((RelNode)aggregate) && aggregate.getGroupType() == Aggregate.Group.SIMPLE && aggregate.getAggCallList().stream().noneMatch(AggregateCall::isDistinct) && aggregate.getAggCallList().stream().allMatch(MongoAggregateUtils::supportsAggregation);
    }

    public boolean canImplement(Filter filter) {
        if (this.hasPluginGroupScan((RelNode)filter)) {
            LogicalExpression conditionExp = DrillOptiq.toDrill((DrillParseContext)new DrillParseContext(PrelUtil.getPlannerSettings((RelOptPlanner)filter.getCluster().getPlanner())), (RelNode)filter.getInput(), (RexNode)filter.getCondition());
            MongoFilterBuilder filterBuilder = new MongoFilterBuilder(conditionExp);
            filterBuilder.parseTree();
            return filterBuilder.isAllExpressionsConverted();
        }
        return false;
    }

    public boolean canImplement(DrillLimitRelBase limit) {
        return this.hasPluginGroupScan((RelNode)limit);
    }

    public boolean canImplement(Project project) {
        return this.hasPluginGroupScan((RelNode)project) && project.getProjects().stream().allMatch(RexToMongoTranslator::supportsExpression);
    }

    public boolean canImplement(Sort sort) {
        return this.hasPluginGroupScan((RelNode)sort);
    }

    public boolean canImplement(Union union) {
        return union.all && this.hasPluginGroupScan((RelNode)union);
    }

    public boolean canImplement(TableScan scan) {
        return this.hasPluginGroupScan((RelNode)scan);
    }

    protected Class<? extends StoragePlugin> supportedPlugin() {
        return MongoStoragePlugin.class;
    }

    public GroupScan getPhysicalOperator() {
        MongoScanSpec scanSpec = this.groupScan.getScanSpec();
        List<String> operations = this.operations.stream().map(op -> op.toBsonDocument().toJson()).collect(Collectors.toList());
        String filters = Optional.ofNullable(this.filters).map(Document::toJson).orElse(null);
        MongoScanSpec newSpec = new MongoScanSpec(scanSpec.getDbName(), scanSpec.getCollectionName(), filters, operations);
        return new MongoGroupScan(this.groupScan.getUserName(), this.groupScan.getStoragePlugin(), newSpec, this.columns, this.runAggregate);
    }

    protected boolean hasPluginGroupScan(RelNode node) {
        return this.findGroupScan(node) instanceof MongoGroupScan;
    }

    private static int direction(RelFieldCollation fieldCollation) {
        switch (fieldCollation.getDirection()) {
            case DESCENDING: 
            case STRICTLY_DESCENDING: {
                return -1;
            }
        }
        return 1;
    }
}

