/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListReplicationSourcesRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String bucketName;
    private String opcClientRequestId;
    private String page;
    private Integer limit;

    @ConstructorProperties(value={"namespaceName", "bucketName", "opcClientRequestId", "page", "limit"})
    ListReplicationSourcesRequest(String namespaceName, String bucketName, String opcClientRequestId, String page, Integer limit) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.opcClientRequestId = opcClientRequestId;
        this.page = page;
        this.limit = limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).bucketName(this.bucketName).opcClientRequestId(this.opcClientRequestId).page(this.page).limit(this.limit);
    }

    public String toString() {
        return "ListReplicationSourcesRequest(super=" + super.toString() + ", namespaceName=" + this.getNamespaceName() + ", bucketName=" + this.getBucketName() + ", opcClientRequestId=" + this.getOpcClientRequestId() + ", page=" + this.getPage() + ", limit=" + this.getLimit() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListReplicationSourcesRequest)) {
            return false;
        }
        ListReplicationSourcesRequest other = (ListReplicationSourcesRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$namespaceName = this.getNamespaceName();
        String other$namespaceName = other.getNamespaceName();
        if (this$namespaceName == null ? other$namespaceName != null : !this$namespaceName.equals(other$namespaceName)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$opcClientRequestId = this.getOpcClientRequestId();
        String other$opcClientRequestId = other.getOpcClientRequestId();
        if (this$opcClientRequestId == null ? other$opcClientRequestId != null : !this$opcClientRequestId.equals(other$opcClientRequestId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        return !(this$page == null ? other$page != null : !this$page.equals(other$page));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListReplicationSourcesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $namespaceName = this.getNamespaceName();
        result = result * 59 + ($namespaceName == null ? 43 : $namespaceName.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $opcClientRequestId = this.getOpcClientRequestId();
        result = result * 59 + ($opcClientRequestId == null ? 43 : $opcClientRequestId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        return result;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public static class Builder
    implements BmcRequest.Builder<ListReplicationSourcesRequest, Void> {
        private String namespaceName;
        private String bucketName;
        private String opcClientRequestId;
        private String page;
        private Integer limit;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListReplicationSourcesRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListReplicationSourcesRequest build() {
            ListReplicationSourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListReplicationSourcesRequest buildWithoutInvocationCallback() {
            return new ListReplicationSourcesRequest(this.namespaceName, this.bucketName, this.opcClientRequestId, this.page, this.limit);
        }

        public String toString() {
            return "ListReplicationSourcesRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", opcClientRequestId=" + this.opcClientRequestId + ", page=" + this.page + ", limit=" + this.limit + ")";
        }
    }
}

