/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc.clickhouse;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.adapter.jdbc.JdbcTable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;

public class ClickhouseJdbcImplementor
extends JdbcImplementor {
    public ClickhouseJdbcImplementor(SqlDialect dialect, JavaTypeFactory typeFactory) {
        super(dialect, typeFactory);
    }

    public SqlImplementor.Result visit(TableScan scan) {
        SqlIdentifier sqlIdentifier = ClickhouseJdbcImplementor.getSqlTargetTable((RelNode)scan);
        UnmodifiableIterator iter = sqlIdentifier.names.iterator();
        Preconditions.checkArgument((sqlIdentifier.names.size() == 3 ? 1 : 0) != 0, (String)"size of clickhouse table names:[%s] is not 3", (Object)sqlIdentifier.toString());
        iter.next();
        sqlIdentifier.setNames((List)ImmutableList.copyOf((Iterator)iter), null);
        return this.result((SqlNode)sqlIdentifier, (Collection)ImmutableList.of((Object)SqlImplementor.Clause.FROM), (RelNode)scan, null);
    }

    private static SqlIdentifier getSqlTargetTable(RelNode e) {
        RelOptTable table = Objects.requireNonNull(e.getTable());
        return table.maybeUnwrap(JdbcTable.class).map(JdbcTable::tableName).orElseGet(() -> new SqlIdentifier(table.getQualifiedName(), SqlParserPos.ZERO));
    }
}

