/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compat.hbase.coprocessor;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.ScanOptions;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

public class CompatBaseScannerRegionObserver
implements RegionObserver {
    public static final String PHOENIX_MAX_LOOKBACK_AGE_CONF_KEY = "phoenix.max.lookback.age.seconds";
    public static final int DEFAULT_PHOENIX_MAX_LOOKBACK_AGE = 0;

    public void preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanType scanType, ScanOptions options, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        Configuration conf = ((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration();
        if (CompatBaseScannerRegionObserver.isMaxLookbackTimeEnabled(conf)) {
            this.setScanOptionsForFlushesAndCompactions(conf, options, store, scanType);
        }
    }

    public void preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanOptions options, FlushLifeCycleTracker tracker) throws IOException {
        Configuration conf = ((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration();
        if (CompatBaseScannerRegionObserver.isMaxLookbackTimeEnabled(conf)) {
            this.setScanOptionsForFlushesAndCompactions(conf, options, store, ScanType.COMPACT_RETAIN_DELETES);
        }
    }

    public void preMemStoreCompactionCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanOptions options) throws IOException {
        Configuration conf = ((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration();
        if (CompatBaseScannerRegionObserver.isMaxLookbackTimeEnabled(conf)) {
            MemoryCompactionPolicy inMemPolicy = store.getColumnFamilyDescriptor().getInMemoryCompaction();
            ScanType scanType = inMemPolicy.equals((Object)MemoryCompactionPolicy.EAGER) || inMemPolicy.equals((Object)MemoryCompactionPolicy.ADAPTIVE) ? ScanType.COMPACT_DROP_DELETES : ScanType.COMPACT_RETAIN_DELETES;
            this.setScanOptionsForFlushesAndCompactions(conf, options, store, scanType);
        }
    }

    public void preStoreScannerOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, Store store, ScanOptions options) throws IOException {
        if (!this.storeFileScanDoesntNeedAlteration(options)) {
            options.setMinVersions(options.getMinVersions());
            KeepDeletedCells keepDeletedCells = KeepDeletedCells.TRUE;
            if (store.getColumnFamilyDescriptor().getTimeToLive() != Integer.MAX_VALUE) {
                keepDeletedCells = KeepDeletedCells.TTL;
            }
            options.setKeepDeletedCells(keepDeletedCells);
        }
    }

    private boolean storeFileScanDoesntNeedAlteration(ScanOptions options) {
        Scan scan = options.getScan();
        boolean isRaw = scan.isRaw();
        boolean keepDeletedCells = options.getKeepDeletedCells().equals((Object)KeepDeletedCells.TRUE) || options.getKeepDeletedCells().equals((Object)KeepDeletedCells.TTL);
        boolean timeRangeIsLatest = scan.getTimeRange().getMax() == Long.MAX_VALUE;
        boolean timestampIsTransactional = this.isTransactionalTimestamp(scan.getTimeRange().getMax());
        return isRaw || keepDeletedCells || timeRangeIsLatest || timestampIsTransactional;
    }

    private boolean isTransactionalTimestamp(long ts) {
        return ts > (long)((double)EnvironmentEdgeManager.currentTime() * 1.1);
    }

    public KeepDeletedCells getKeepDeletedCells(ScanOptions options, ScanType scanType) {
        return options.getKeepDeletedCells() == KeepDeletedCells.TRUE || scanType.equals((Object)ScanType.COMPACT_RETAIN_DELETES) ? KeepDeletedCells.TRUE : KeepDeletedCells.TTL;
    }

    public int getMinVersions(ScanOptions options, ColumnFamilyDescriptor cfDescriptor) {
        return cfDescriptor.getTimeToLive() != Integer.MAX_VALUE ? options.getMinVersions() : Math.max(Math.max(options.getMinVersions(), cfDescriptor.getMaxVersions()), 1);
    }

    public long getTimeToLiveForCompactions(Configuration conf, ColumnFamilyDescriptor columnDescriptor, ScanOptions options) {
        long ttlConfigured = columnDescriptor.getTimeToLive();
        long ttlInMillis = ttlConfigured * 1000L;
        long maxLookbackTtl = CompatBaseScannerRegionObserver.getMaxLookbackInMillis(conf);
        if (CompatBaseScannerRegionObserver.isMaxLookbackTimeEnabled(maxLookbackTtl)) {
            ttlInMillis = ttlConfigured == Integer.MAX_VALUE && columnDescriptor.getKeepDeletedCells() != KeepDeletedCells.TRUE ? maxLookbackTtl : Math.max(ttlInMillis, maxLookbackTtl);
        }
        return ttlInMillis;
    }

    public void setScanOptionsForFlushesAndCompactions(Configuration conf, ScanOptions options, Store store, ScanType type) {
        ColumnFamilyDescriptor cfDescriptor = store.getColumnFamilyDescriptor();
        options.setTTL(this.getTimeToLiveForCompactions(conf, cfDescriptor, options));
        options.setKeepDeletedCells(this.getKeepDeletedCells(options, type));
        options.setMaxVersions(Integer.MAX_VALUE);
        options.setMinVersions(this.getMinVersions(options, cfDescriptor));
    }

    public static long getMaxLookbackInMillis(Configuration conf) {
        return conf.getLong(PHOENIX_MAX_LOOKBACK_AGE_CONF_KEY, 0L) * 1000L;
    }

    public static boolean isMaxLookbackTimeEnabled(Configuration conf) {
        return CompatBaseScannerRegionObserver.isMaxLookbackTimeEnabled(conf.getLong(PHOENIX_MAX_LOOKBACK_AGE_CONF_KEY, 0L));
    }

    public static boolean isMaxLookbackTimeEnabled(long maxLookbackTime) {
        return maxLookbackTime > 0L;
    }
}

