/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.inject.Module;
import org.apache.omid.NetworkUtils;
import org.apache.omid.YAMLUtils;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.tools.hbase.SecureHBaseConfig;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSOServerConfig
extends SecureHBaseConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TSOServerConfig.class);
    private static final String CONFIG_FILE_NAME = "omid-server-configuration.yml";
    private static final String DEFAULT_CONFIG_FILE_NAME = "default-omid-server-configuration.yml";
    private Module timestampStoreModule;
    private Module commitTableStoreModule;
    private Module leaseModule;
    private int port;
    private MetricsRegistry metrics;
    private int conflictMapSize;
    private int numConcurrentCTWriters;
    private int batchSizePerCTWriter;
    private int batchPersistTimeoutInMs;
    private String waitStrategy;
    private String networkIfaceName = NetworkUtils.getDefaultNetworkInterface();
    private String timestampType;
    private Boolean lowLatency;
    public boolean monitorContext;

    public TSOServerConfig() {
        this(CONFIG_FILE_NAME);
    }

    @VisibleForTesting
    TSOServerConfig(String configFileName) {
        new YAMLUtils().loadSettings(configFileName, DEFAULT_CONFIG_FILE_NAME, (Object)this);
    }

    public boolean getMonitorContext() {
        return this.monitorContext;
    }

    public void setMonitorContext(boolean monitorContext) {
        this.monitorContext = monitorContext;
    }

    public Boolean getLowLatency() {
        return this.lowLatency;
    }

    public void setLowLatency(Boolean lowLatency) {
        this.lowLatency = lowLatency;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getConflictMapSize() {
        return this.conflictMapSize;
    }

    public void setConflictMapSize(int conflictMapSize) {
        this.conflictMapSize = conflictMapSize;
    }

    public int getNumConcurrentCTWriters() {
        return this.numConcurrentCTWriters;
    }

    public void setNumConcurrentCTWriters(int numConcurrentCTWriters) {
        this.numConcurrentCTWriters = numConcurrentCTWriters;
    }

    public int getBatchSizePerCTWriter() {
        return this.batchSizePerCTWriter;
    }

    public void setBatchSizePerCTWriter(int batchSizePerCTWriter) {
        this.batchSizePerCTWriter = batchSizePerCTWriter;
    }

    public int getBatchPersistTimeoutInMs() {
        return this.batchPersistTimeoutInMs;
    }

    public void setBatchPersistTimeoutInMs(int value) {
        this.batchPersistTimeoutInMs = value;
    }

    public String getNetworkIfaceName() {
        return this.networkIfaceName;
    }

    public void setNetworkIfaceName(String networkIfaceName) {
        this.networkIfaceName = networkIfaceName;
    }

    public String getTimestampType() {
        return this.timestampType;
    }

    public void setTimestampType(String type) {
        this.timestampType = type;
    }

    public TIMESTAMP_TYPE getTimestampTypeEnum() {
        return TIMESTAMP_TYPE.valueOf(this.timestampType);
    }

    public Module getTimestampStoreModule() {
        return this.timestampStoreModule;
    }

    public void setTimestampStoreModule(Module timestampStoreModule) {
        this.timestampStoreModule = timestampStoreModule;
    }

    public Module getCommitTableStoreModule() {
        return this.commitTableStoreModule;
    }

    public void setCommitTableStoreModule(Module commitTableStoreModule) {
        this.commitTableStoreModule = commitTableStoreModule;
    }

    public Module getLeaseModule() {
        return this.leaseModule;
    }

    public void setLeaseModule(Module leaseModule) {
        this.leaseModule = leaseModule;
    }

    public MetricsRegistry getMetrics() {
        return this.metrics;
    }

    public void setMetrics(MetricsRegistry metrics) {
        this.metrics = metrics;
    }

    public String getWaitStrategy() {
        return this.waitStrategy;
    }

    public WAIT_STRATEGY getWaitStrategyEnum() {
        return WAIT_STRATEGY.valueOf(this.waitStrategy);
    }

    public void setWaitStrategy(String waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    public static enum TIMESTAMP_TYPE {
        INCREMENTAL,
        WORLD_TIME;

    }

    public static enum WAIT_STRATEGY {
        HIGH_THROUGHPUT,
        LOW_CPU;

    }
}

