/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.esri.core.geometry;

import com.datastax.oss.driver.shaded.esri.core.geometry.VertexDescription;
import com.datastax.oss.driver.shaded.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

final class VertexDescriptionHash {
    Map<Integer, WeakReference<VertexDescription>> map = new HashMap<Integer, WeakReference<VertexDescription>>();
    private static VertexDescription m_vd2D;
    private static VertexDescription m_vd3D;
    private static final VertexDescriptionHash INSTANCE;

    private VertexDescriptionHash() {
        VertexDescriptionDesignerImpl vdd2D = new VertexDescriptionDesignerImpl();
        this.add(vdd2D);
        VertexDescriptionDesignerImpl vdd3D = new VertexDescriptionDesignerImpl();
        vdd3D.addAttribute(1);
        this.add(vdd3D);
    }

    public static VertexDescriptionHash getInstance() {
        return INSTANCE;
    }

    public VertexDescription getVD2D() {
        return m_vd2D;
    }

    public VertexDescription getVD3D() {
        return m_vd3D;
    }

    public synchronized VertexDescription add(VertexDescriptionDesignerImpl vdd) {
        WeakReference<VertexDescription> vdweak;
        int h = vdd.hashCode();
        if (m_vd2D != null && m_vd2D.hashCode() == h && vdd.isDesignerFor(m_vd2D)) {
            return m_vd2D;
        }
        if (m_vd3D != null && m_vd3D.hashCode() == h && vdd.isDesignerFor(m_vd3D)) {
            return m_vd3D;
        }
        VertexDescription vd = null;
        if (this.map.containsKey(h) && (vd = (VertexDescription)(vdweak = this.map.get(h)).get()) == null) {
            this.map.remove(h);
        }
        if (vd == null) {
            vd = vdd._createInternal();
            if (vd.getAttributeCount() == 1) {
                m_vd2D = vd;
            } else if (vd.getAttributeCount() == 2 && vd.getSemantics(1) == 1) {
                m_vd3D = vd;
            } else {
                vdweak = new WeakReference<VertexDescription>(vd);
                this.map.put(h, vdweak);
            }
        }
        return vd;
    }

    static {
        INSTANCE = new VertexDescriptionHash();
    }
}

