/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DropSchemaFinalStep;
import org.jooq.DropSchemaStep;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.impl.AbstractRowCountQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class DropSchemaImpl
extends AbstractRowCountQuery
implements DropSchemaStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_SCHEMA};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> REQUIRES_RESTRICT = SQLDialect.supportedBy(SQLDialect.DERBY);
    private final Schema schema;
    private final boolean ifExists;
    private boolean cascade;

    DropSchemaImpl(Configuration configuration, Schema schema) {
        this(configuration, schema, false);
    }

    DropSchemaImpl(Configuration configuration, Schema schema, boolean ifExists) {
        super(configuration);
        this.schema = schema;
        this.ifExists = ifExists;
    }

    final Schema $schema() {
        return this.schema;
    }

    final boolean $ifExists() {
        return this.ifExists;
    }

    final boolean $cascade() {
        return this.cascade;
    }

    @Override
    public final DropSchemaFinalStep cascade() {
        this.cascade = true;
        return this;
    }

    @Override
    public final DropSchemaFinalStep restrict() {
        this.cascade = false;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.DROP_SCHEMA);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.DROP_SCHEMA);
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.start(Clause.DROP_SCHEMA_SCHEMA).visit(Keywords.K_DROP);
        ctx.sql(' ').visit(Keywords.K_SCHEMA);
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.schema);
        if (this.cascade) {
            ctx.sql(' ').visit(Keywords.K_CASCADE);
        } else if (REQUIRES_RESTRICT.contains((Object)ctx.family())) {
            ctx.sql(' ').visit(Keywords.K_RESTRICT);
        }
        ctx.end(Clause.DROP_SCHEMA_SCHEMA);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

