/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jooq.Catalog;
import org.jooq.Comment;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Meta;
import org.jooq.MetaProvider;
import org.jooq.Name;
import org.jooq.Package;
import org.jooq.Record;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UDT;
import org.jooq.UDTRecord;
import org.jooq.UniqueKey;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractMeta;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.SequenceImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.UDTImpl;

final class DetachedMeta
extends AbstractMeta {
    private static final long serialVersionUID = 5561057000510740144L;
    private Meta delegate;

    static Meta detach(MetaProvider provider) {
        return new DetachedMeta(provider.provide());
    }

    private DetachedMeta(Meta meta) {
        super(meta.configuration());
        this.delegate = meta;
        this.getCatalogs();
        this.delegate = null;
        this.resolveReferences();
    }

    private final void resolveReferences() {
        for (Catalog catalog : this.getCatalogs()) {
            ((DetachedCatalog)catalog).resolveReferences(this);
        }
    }

    @Override
    protected final List<Catalog> getCatalogs0() throws DataAccessException {
        ArrayList<Catalog> result = new ArrayList<Catalog>();
        for (Catalog catalog : this.delegate.getCatalogs()) {
            result.add(DetachedCatalog.copyOf(catalog));
        }
        return result;
    }

    private static class DetachedUDT<R extends UDTRecord<R>>
    extends UDTImpl<R> {
        private static final long serialVersionUID = -5732449514562314202L;

        private DetachedUDT(String name, Schema owner, Package package_, boolean synthetic) {
            super(name, owner, package_, synthetic);
        }

        static DetachedUDT<?> copyOf(UDT<?> udt, Schema owner) {
            Package package_ = null;
            return new DetachedUDT(udt.getName(), owner, package_, udt.isSynthetic());
        }
    }

    private static class DetachedSequence<T extends Number>
    extends SequenceImpl<T> {
        private static final long serialVersionUID = -1607062195966296849L;

        private DetachedSequence(String name, Schema owner, DataType<T> dataType) {
            super(name, owner, dataType);
        }

        static DetachedSequence<?> copyOf(Sequence<?> sequence, Schema owner) {
            return new DetachedSequence(sequence.getName(), owner, sequence.getDataType());
        }
    }

    private static class DetachedTable<R extends Record>
    extends TableImpl<R> {
        private static final long serialVersionUID = -6070726881709997500L;
        private final List<Index> indexes = new ArrayList<Index>();
        private final List<UniqueKey<R>> keys = new ArrayList<UniqueKey<R>>();
        private UniqueKey<R> primaryKey;
        private final List<ForeignKey<R, ?>> references = new ArrayList();

        private DetachedTable(Name name, Schema owner, Comment comment) {
            super(name, owner, null, null, comment);
        }

        @Deprecated
        private final TableField<R, ?>[] fields(TableField<R, ?>[] tableFields) {
            TableField[] result = new TableField[tableFields.length];
            for (int i = 0; i < tableFields.length; ++i) {
                result[i] = (TableField)this.field(tableFields[i].getName());
            }
            return result;
        }

        static <R extends Record> DetachedTable<R> copyOf(Table<R> table, Schema owner) {
            DetachedTable<R> result = new DetachedTable<R>(table.getUnqualifiedName(), owner, DSL.comment(table.getComment()));
            for (Field<?> field : table.fields()) {
                DetachedTable.createField(field.getName(), field.getDataType(), result, field.getComment());
            }
            for (Index index : table.getIndexes()) {
                List<SortField<?>> indexFields = index.getFields();
                SortField[] copiedFields = new SortField[indexFields.size()];
                for (int i = 0; i < indexFields.size(); ++i) {
                    SortField<?> field = indexFields.get(i);
                    copiedFields[i] = result.field(field.getName()).sort(field.getOrder());
                }
                result.indexes.add(Internal.createIndex(index.getName(), result, copiedFields, index.getUnique()));
            }
            for (UniqueKey uniqueKey : table.getKeys()) {
                result.keys.add(Internal.createUniqueKey(result, uniqueKey.getName(), super.fields(uniqueKey.getFieldsArray())));
            }
            UniqueKey<R> pk = table.getPrimaryKey();
            if (pk != null) {
                result.primaryKey = Internal.createUniqueKey(result, pk.getName(), super.fields(pk.getFieldsArray()));
            }
            result.references.addAll(table.getReferences());
            return result;
        }

        final void resolveReferences(Meta meta) {
            for (int i = 0; i < this.references.size(); ++i) {
                ForeignKey<R, ?> ref = this.references.get(i);
                Name name = ref.getKey().getTable().getQualifiedName();
                Table<?> table = this.resolveTable(name, meta);
                UniqueKey<?> pk = table == null ? null : table.getPrimaryKey();
                this.references.set(i, Internal.createForeignKey(pk, this, ref.getName(), this.fields(ref.getFieldsArray())));
            }
        }

        private final Table<?> resolveTable(Name tableName, Meta meta) {
            List<Table<?>> list = meta.getTables(tableName);
            return list.isEmpty() ? null : list.get(0);
        }

        @Override
        public final List<Index> getIndexes() {
            return Collections.unmodifiableList(this.indexes);
        }

        @Override
        public final List<UniqueKey<R>> getKeys() {
            return Collections.unmodifiableList(this.keys);
        }

        @Override
        public final UniqueKey<R> getPrimaryKey() {
            return this.primaryKey;
        }

        @Override
        public final List<ForeignKey<R, ?>> getReferences() {
            return Collections.unmodifiableList(this.references);
        }
    }

    private static class DetachedSchema
    extends SchemaImpl {
        private static final long serialVersionUID = -95755926444275258L;
        private final List<Table<?>> tables = new ArrayList();
        private final List<Sequence<?>> sequences = new ArrayList();
        private final List<UDT<?>> udts = new ArrayList();

        private DetachedSchema(String name, Catalog owner, String comment) {
            super(name, owner, comment);
        }

        static DetachedSchema copyOf(Schema schema, Catalog owner) {
            DetachedSchema result = new DetachedSchema(schema.getName(), owner, schema.getComment());
            for (Table<?> table : schema.getTables()) {
                result.tables.add(DetachedTable.copyOf(table, result));
            }
            for (Sequence sequence : schema.getSequences()) {
                result.sequences.add(DetachedSequence.copyOf(sequence, result));
            }
            for (UDT uDT : schema.getUDTs()) {
                result.udts.add(DetachedUDT.copyOf(uDT, result));
            }
            return result;
        }

        final void resolveReferences(Meta meta) {
            for (Table<?> table : this.tables) {
                ((DetachedTable)table).resolveReferences(meta);
            }
        }

        @Override
        public final List<Table<?>> getTables() {
            return Collections.unmodifiableList(this.tables);
        }

        @Override
        public final List<Sequence<?>> getSequences() {
            return Collections.unmodifiableList(this.sequences);
        }

        @Override
        public final List<UDT<?>> getUDTs() {
            return Collections.unmodifiableList(this.udts);
        }
    }

    private static class DetachedCatalog
    extends CatalogImpl {
        private static final long serialVersionUID = 7979890261252183486L;
        private final List<Schema> schemas = new ArrayList<Schema>();

        private DetachedCatalog(String name, String comment) {
            super(name, comment);
        }

        private final void resolveReferences(Meta meta) {
            for (Schema schema : this.schemas) {
                ((DetachedSchema)schema).resolveReferences(meta);
            }
        }

        static DetachedCatalog copyOf(Catalog catalog) {
            DetachedCatalog result = new DetachedCatalog(catalog.getName(), catalog.getComment());
            for (Schema schema : catalog.getSchemas()) {
                result.schemas.add(DetachedSchema.copyOf(schema, result));
            }
            return result;
        }

        @Override
        public final List<Schema> getSchemas() {
            return Collections.unmodifiableList(this.schemas);
        }
    }
}

