/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.micrometer.core.instrument.binder.jvm;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Counter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Gauge;
import org.apache.kudu.shaded.io.micrometer.core.instrument.MeterRegistry;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Tag;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Timer;
import org.apache.kudu.shaded.io.micrometer.core.instrument.binder.MeterBinder;
import org.apache.kudu.shaded.io.micrometer.core.instrument.binder.jvm.JvmMemory;
import org.apache.kudu.shaded.io.micrometer.core.lang.NonNullApi;
import org.apache.kudu.shaded.io.micrometer.core.lang.NonNullFields;
import org.apache.kudu.shaded.io.micrometer.core.lang.Nullable;
import org.apache.kudu.shaded.io.micrometer.core.util.internal.logging.InternalLogger;
import org.apache.kudu.shaded.io.micrometer.core.util.internal.logging.InternalLoggerFactory;

@NonNullApi
@NonNullFields
public class JvmGcMetrics
implements MeterBinder,
AutoCloseable {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(JvmGcMetrics.class);
    private final boolean managementExtensionsPresent = JvmGcMetrics.isManagementExtensionsPresent();
    private final Iterable<Tag> tags;
    @Nullable
    private String youngGenPoolName;
    @Nullable
    private String oldGenPoolName;
    @Nullable
    private String nonGenerationalMemoryPool;
    private final List<Runnable> notificationListenerCleanUpRunnables = new CopyOnWriteArrayList<Runnable>();

    public JvmGcMetrics() {
        this(Collections.emptyList());
    }

    public JvmGcMetrics(Iterable<Tag> tags) {
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            String name = mbean.getName();
            if (JvmMemory.isYoungGenPool(name)) {
                this.youngGenPoolName = name;
                continue;
            }
            if (JvmMemory.isOldGenPool(name)) {
                this.oldGenPoolName = name;
                continue;
            }
            if (!JvmMemory.isNonGenerationalHeapPool(name)) continue;
            this.nonGenerationalMemoryPool = name;
        }
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        if (!this.managementExtensionsPresent) {
            return;
        }
        double maxLongLivedPoolBytes = JvmMemory.getLongLivedHeapPool().map(mem -> JvmMemory.getUsageValue(mem, MemoryUsage::getMax)).orElse(0.0);
        AtomicLong maxDataSize = new AtomicLong((long)maxLongLivedPoolBytes);
        Gauge.builder("jvm.gc.max.data.size", maxDataSize, AtomicLong::get).tags(this.tags).description("Max size of long-lived heap memory pool").baseUnit("bytes").register(registry);
        AtomicLong liveDataSize = new AtomicLong();
        Gauge.builder("jvm.gc.live.data.size", liveDataSize, AtomicLong::get).tags(this.tags).description("Size of long-lived heap memory pool after reclamation").baseUnit("bytes").register(registry);
        Counter allocatedBytes = Counter.builder("jvm.gc.memory.allocated").tags(this.tags).baseUnit("bytes").description("Incremented for an increase in the size of the (young) heap memory pool after one GC to before the next").register(registry);
        Counter promotedBytes = this.oldGenPoolName == null ? null : Counter.builder("jvm.gc.memory.promoted").tags(this.tags).baseUnit("bytes").description("Count of positive increases in the size of the old generation memory pool before GC to after GC").register(registry);
        AtomicLong heapPoolSizeAfterGc = new AtomicLong();
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            NotificationListener notificationListener = (notification, ref) -> {
                CompositeData cd2 = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from(cd2);
                String gcCause = notificationInfo.getGcCause();
                String gcAction = notificationInfo.getGcAction();
                GcInfo gcInfo = notificationInfo.getGcInfo();
                long duration = gcInfo.getDuration();
                if (JvmMemory.isConcurrentPhase(gcCause, notificationInfo.getGcName())) {
                    ((Timer.Builder)Timer.builder("jvm.gc.concurrent.phase.time").tags((Iterable)this.tags)).tags("action", gcAction, "cause", gcCause).description("Time spent in concurrent phase").register(registry).record(duration, TimeUnit.MILLISECONDS);
                } else {
                    ((Timer.Builder)Timer.builder("jvm.gc.pause").tags((Iterable)this.tags)).tags("action", gcAction, "cause", gcCause).description("Time spent in GC pause").register(registry).record(duration, TimeUnit.MILLISECONDS);
                }
                Map<String, MemoryUsage> before = gcInfo.getMemoryUsageBeforeGc();
                Map<String, MemoryUsage> after = gcInfo.getMemoryUsageAfterGc();
                if (this.nonGenerationalMemoryPool != null) {
                    this.countPoolSizeDelta(gcInfo.getMemoryUsageBeforeGc(), gcInfo.getMemoryUsageAfterGc(), allocatedBytes, heapPoolSizeAfterGc, this.nonGenerationalMemoryPool);
                    if (after.get(this.nonGenerationalMemoryPool).getUsed() < before.get(this.nonGenerationalMemoryPool).getUsed()) {
                        liveDataSize.set(after.get(this.nonGenerationalMemoryPool).getUsed());
                        long longLivedMaxAfter = after.get(this.nonGenerationalMemoryPool).getMax();
                        maxDataSize.set(longLivedMaxAfter);
                    }
                    return;
                }
                if (this.oldGenPoolName != null) {
                    long oldBefore = before.get(this.oldGenPoolName).getUsed();
                    long oldAfter = after.get(this.oldGenPoolName).getUsed();
                    long delta = oldAfter - oldBefore;
                    if (delta > 0L) {
                        promotedBytes.increment(delta);
                    }
                    if (oldAfter < oldBefore || GcGenerationAge.fromName(notificationInfo.getGcName()) == GcGenerationAge.OLD) {
                        liveDataSize.set(oldAfter);
                        long oldMaxAfter = after.get(this.oldGenPoolName).getMax();
                        maxDataSize.set(oldMaxAfter);
                    }
                }
                if (this.youngGenPoolName != null) {
                    this.countPoolSizeDelta(gcInfo.getMemoryUsageBeforeGc(), gcInfo.getMemoryUsageAfterGc(), allocatedBytes, heapPoolSizeAfterGc, this.youngGenPoolName);
                }
            };
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)mbean);
            notificationEmitter.addNotificationListener(notificationListener, notification -> notification.getType().equals("com.sun.management.gc.notification"), null);
            this.notificationListenerCleanUpRunnables.add(() -> {
                try {
                    notificationEmitter.removeNotificationListener(notificationListener);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            });
        }
    }

    private void countPoolSizeDelta(Map<String, MemoryUsage> before, Map<String, MemoryUsage> after, Counter counter, AtomicLong previousPoolSize, String poolName) {
        long beforeBytes = before.get(poolName).getUsed();
        long afterBytes = after.get(poolName).getUsed();
        long delta = beforeBytes - previousPoolSize.get();
        previousPoolSize.set(afterBytes);
        if (delta > 0L) {
            counter.increment(delta);
        }
    }

    private static boolean isManagementExtensionsPresent() {
        if (ManagementFactory.getMemoryPoolMXBeans().isEmpty()) {
            log.warn("GC notifications will not be available because MemoryPoolMXBeans are not provided by the JVM");
            return false;
        }
        try {
            Class.forName("com.sun.management.GarbageCollectionNotificationInfo", false, MemoryPoolMXBean.class.getClassLoader());
            return true;
        }
        catch (Throwable e) {
            log.warn("GC notifications will not be available because com.sun.management.GarbageCollectionNotificationInfo is not present");
            return false;
        }
    }

    @Override
    public void close() {
        this.notificationListenerCleanUpRunnables.forEach(Runnable::run);
    }

    @NonNullApi
    static enum GcGenerationAge {
        OLD,
        YOUNG,
        UNKNOWN;

        private static Map<String, GcGenerationAge> knownCollectors;

        static GcGenerationAge fromName(String name) {
            return knownCollectors.getOrDefault(name, UNKNOWN);
        }

        static {
            knownCollectors = new HashMap<String, GcGenerationAge>(){
                {
                    this.put("ConcurrentMarkSweep", OLD);
                    this.put("Copy", YOUNG);
                    this.put("G1 Old Generation", OLD);
                    this.put("G1 Young Generation", YOUNG);
                    this.put("MarkSweepCompact", OLD);
                    this.put("PS MarkSweep", OLD);
                    this.put("PS Scavenge", YOUNG);
                    this.put("ParNew", YOUNG);
                }
            };
        }
    }
}

