/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import com.google.protobuf.InvalidProtocolBufferException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.client.Table;
import org.apache.omid.proto.TSOProto;
import org.apache.omid.transaction.AbstractTransaction;
import org.apache.omid.transaction.AbstractTransactionManager;
import org.apache.omid.transaction.HBaseCellId;
import org.apache.omid.transaction.HBaseTransaction;
import org.apache.omid.transaction.HBaseTransactionManager;
import org.apache.omid.transaction.RollbackException;
import org.apache.omid.transaction.Transaction;
import org.apache.omid.transaction.TransactionException;
import org.apache.omid.tso.client.CellId;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.transaction.OmidTransactionProvider;
import org.apache.phoenix.transaction.OmidTransactionTable;
import org.apache.phoenix.transaction.PhoenixTransactionClient;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.TransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmidTransactionContext
implements PhoenixTransactionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(OmidTransactionContext.class);
    private HBaseTransactionManager tm;
    private HBaseTransaction tx;

    public OmidTransactionContext() {
        this.tx = null;
        this.tm = null;
    }

    public OmidTransactionContext(PhoenixConnection connection) throws SQLException {
        PhoenixTransactionClient client = connection.getQueryServices().initTransactionClient(this.getProvider());
        assert (client instanceof OmidTransactionProvider.OmidTransactionClient);
        this.tm = ((OmidTransactionProvider.OmidTransactionClient)client).getTransactionClient();
        this.tx = null;
    }

    public OmidTransactionContext(byte[] txnBytes) throws InvalidProtocolBufferException {
        this();
        if (txnBytes != null && txnBytes.length > 0) {
            TSOProto.Transaction transaction = TSOProto.Transaction.parseFrom((byte[])txnBytes);
            this.tx = new HBaseTransaction(transaction.getTimestamp(), transaction.getEpoch(), new HashSet(), new HashSet(), null, this.tm.isLowLatency());
        } else {
            this.tx = null;
        }
    }

    public OmidTransactionContext(PhoenixTransactionContext ctx, boolean subTask) {
        assert (ctx instanceof OmidTransactionContext);
        OmidTransactionContext omidTransactionContext = (OmidTransactionContext)ctx;
        this.tm = omidTransactionContext.tm;
        if (subTask) {
            if (omidTransactionContext.isTransactionRunning()) {
                HBaseTransaction transaction = omidTransactionContext.getTransaction();
                this.tx = new HBaseTransaction(transaction.getTransactionId(), transaction.getEpoch(), new HashSet(), new HashSet(), (AbstractTransactionManager)this.tm, transaction.getReadTimestamp(), transaction.getWriteTimestamp(), this.tm.isLowLatency());
            } else {
                this.tx = null;
            }
            this.tm = null;
        } else {
            this.tx = omidTransactionContext.getTransaction();
        }
    }

    @Override
    public void begin() throws SQLException {
        if (this.tm == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.NULL_TRANSACTION_CONTEXT).build().buildException();
        }
        try {
            this.tx = (HBaseTransaction)this.tm.begin();
        }
        catch (TransactionException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause(e).build().buildException();
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.tx == null || this.tm == null) {
            return;
        }
        try {
            this.tm.commit((Transaction)this.tx);
        }
        catch (TransactionException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause(e).build().buildException();
        }
        catch (RollbackException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_CONFLICT_EXCEPTION).setMessage(e.getMessage()).setRootCause(e).build().buildException();
        }
    }

    @Override
    public void abort() throws SQLException {
        if (this.tx == null || this.tm == null || this.tx.getStatus() != Transaction.Status.RUNNING) {
            return;
        }
        try {
            this.tm.rollback((Transaction)this.tx);
        }
        catch (TransactionException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause(e).build().buildException();
        }
    }

    @Override
    public void checkpoint(boolean hasUncommittedData) throws SQLException {
        try {
            this.tx.checkpoint();
        }
        catch (TransactionException e) {
            throw new SQLException(e);
        }
        this.tx.setVisibilityLevel(AbstractTransaction.VisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT);
    }

    @Override
    public void commitDDLFence(PTable dataTable) throws SQLException {
        try {
            this.tx = (HBaseTransaction)this.tm.fence(dataTable.getName().getBytes());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Added write fence at ~" + this.tx.getReadTimestamp());
            }
        }
        catch (TransactionException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_UNABLE_TO_GET_WRITE_FENCE).setSchemaName(dataTable.getSchemaName().getString()).setTableName(dataTable.getTableName().getString()).build().buildException();
        }
    }

    @Override
    public void join(PhoenixTransactionContext ctx) {
        if (ctx == PhoenixTransactionContext.NULL_CONTEXT) {
            return;
        }
        assert (ctx instanceof OmidTransactionContext);
        OmidTransactionContext omidContext = (OmidTransactionContext)ctx;
        HBaseTransaction transaction = omidContext.getTransaction();
        if (transaction == null || this.tx == null) {
            return;
        }
        Set writeSet = transaction.getWriteSet();
        for (HBaseCellId cell : writeSet) {
            this.tx.addWriteSetElement((CellId)cell);
        }
    }

    @Override
    public boolean isTransactionRunning() {
        return this.tx != null;
    }

    @Override
    public void reset() {
        this.tx = null;
    }

    @Override
    public long getTransactionId() {
        return this.tx.getTransactionId();
    }

    @Override
    public long getReadPointer() {
        return this.tx.getReadTimestamp();
    }

    @Override
    public long getWritePointer() {
        return this.tx.getWriteTimestamp();
    }

    @Override
    public PhoenixTransactionContext.PhoenixVisibilityLevel getVisibilityLevel() {
        PhoenixTransactionContext.PhoenixVisibilityLevel phoenixVisibilityLevel;
        AbstractTransaction.VisibilityLevel visibilityLevel = null;
        assert (this.tx != null);
        visibilityLevel = this.tx.getVisibilityLevel();
        switch (visibilityLevel) {
            case SNAPSHOT: {
                phoenixVisibilityLevel = PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT;
                break;
            }
            case SNAPSHOT_EXCLUDE_CURRENT: {
                phoenixVisibilityLevel = PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT;
                break;
            }
            case SNAPSHOT_ALL: {
                phoenixVisibilityLevel = PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT_ALL;
            }
            default: {
                phoenixVisibilityLevel = null;
            }
        }
        return phoenixVisibilityLevel;
    }

    @Override
    public void setVisibilityLevel(PhoenixTransactionContext.PhoenixVisibilityLevel visibilityLevel) {
        AbstractTransaction.VisibilityLevel omidVisibilityLevel = null;
        switch (visibilityLevel) {
            case SNAPSHOT: {
                omidVisibilityLevel = AbstractTransaction.VisibilityLevel.SNAPSHOT;
                break;
            }
            case SNAPSHOT_EXCLUDE_CURRENT: {
                omidVisibilityLevel = AbstractTransaction.VisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT;
                break;
            }
            case SNAPSHOT_ALL: {
                omidVisibilityLevel = AbstractTransaction.VisibilityLevel.SNAPSHOT_ALL;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        assert (this.tx != null);
        this.tx.setVisibilityLevel(omidVisibilityLevel);
    }

    @Override
    public byte[] encodeTransaction() throws SQLException {
        assert (this.tx != null);
        TSOProto.Transaction.Builder transactionBuilder = TSOProto.Transaction.newBuilder();
        transactionBuilder.setTimestamp(this.tx.getTransactionId());
        transactionBuilder.setEpoch(this.tx.getEpoch());
        byte[] encodedTxBytes = transactionBuilder.build().toByteArray();
        encodedTxBytes = Arrays.copyOf(encodedTxBytes, encodedTxBytes.length + 1);
        encodedTxBytes[encodedTxBytes.length - 1] = this.getProvider().getCode();
        return encodedTxBytes;
    }

    @Override
    public TransactionFactory.Provider getProvider() {
        return TransactionFactory.Provider.OMID;
    }

    @Override
    public PhoenixTransactionContext newTransactionContext(PhoenixTransactionContext context, boolean subTask) {
        return new OmidTransactionContext(context, subTask);
    }

    @Override
    public void markDMLFence(PTable dataTable) {
    }

    public HBaseTransaction getTransaction() {
        return this.tx;
    }

    @Override
    public Table getTransactionalTable(Table htable, boolean isConflictFree) throws SQLException {
        return new OmidTransactionTable(this, htable, isConflictFree);
    }

    @Override
    public Table getTransactionalTableWriter(PhoenixConnection connection, PTable table, Table htable, boolean isIndex) throws SQLException {
        return new OmidTransactionTable(this, htable, table.isImmutableRows() || isIndex, isIndex);
    }
}

