/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnValueEncoder;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class PArrayDataTypeEncoder
implements ColumnValueEncoder {
    private static final int BYTE_ARRAY_DEFAULT_SIZE = 128;
    private PDataType baseType;
    private SortOrder sortOrder;
    private List<Integer> offsetPos;
    private TrustedByteArrayOutputStream byteStream;
    private DataOutputStream oStream;
    private int nulls;
    private byte serializationVersion;
    private boolean rowKeyOrderOptimizable;

    public PArrayDataTypeEncoder(PDataType baseType, SortOrder sortOrder) {
        this(new TrustedByteArrayOutputStream(128), new LinkedList<Integer>(), baseType, sortOrder, true);
    }

    public PArrayDataTypeEncoder(TrustedByteArrayOutputStream byteStream, DataOutputStream oStream, int numElements, PDataType baseType, SortOrder sortOrder, boolean rowKeyOrderOptimizable, byte serializationVersion) {
        this(byteStream, oStream, new ArrayList<Integer>(numElements), baseType, sortOrder, rowKeyOrderOptimizable, serializationVersion);
    }

    public PArrayDataTypeEncoder(TrustedByteArrayOutputStream byteStream, DataOutputStream oStream, int numElements, PDataType baseType, SortOrder sortOrder, boolean rowKeyOrderOptimizable) {
        this(byteStream, oStream, new ArrayList<Integer>(numElements), baseType, sortOrder, rowKeyOrderOptimizable, 1);
    }

    public PArrayDataTypeEncoder(TrustedByteArrayOutputStream byteStream, List<Integer> offsetPos, PDataType baseType, SortOrder sortOrder, boolean rowKeyOrderOptimizable) {
        this(byteStream, new DataOutputStream(byteStream), offsetPos, baseType, sortOrder, rowKeyOrderOptimizable, 1);
    }

    public PArrayDataTypeEncoder(TrustedByteArrayOutputStream byteStream, DataOutputStream oStream, List<Integer> offsetPos, PDataType baseType, SortOrder sortOrder, boolean rowKeyOrderOptimizable, byte serializationVersion) {
        this.baseType = baseType;
        this.sortOrder = sortOrder;
        this.offsetPos = offsetPos;
        this.byteStream = byteStream;
        this.oStream = oStream;
        this.nulls = 0;
        this.serializationVersion = serializationVersion;
        this.rowKeyOrderOptimizable = rowKeyOrderOptimizable;
    }

    private void close() {
        try {
            if (this.byteStream != null) {
                this.byteStream.close();
            }
            if (this.oStream != null) {
                this.oStream.close();
            }
            this.byteStream = null;
            this.oStream = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void appendAbsentValue() {
        if (!(this.serializationVersion != 2 && this.serializationVersion != 3 || this.baseType.isFixedWidth())) {
            this.offsetPos.add(-this.byteStream.size());
            ++this.nulls;
        } else {
            throw new UnsupportedOperationException("Cannot represent an absent element");
        }
    }

    public void appendValue(byte[] bytes) {
        this.appendValue(bytes, 0, bytes.length);
    }

    @Override
    public void appendValue(byte[] bytes, int offset, int len) {
        try {
            if (!this.baseType.isFixedWidth()) {
                if (len == 0) {
                    this.offsetPos.add(this.byteStream.size());
                    ++this.nulls;
                } else {
                    if (this.serializationVersion == 1 || this.serializationVersion == 2) {
                        this.nulls = PArrayDataType.serializeNulls(this.oStream, this.nulls);
                    }
                    this.offsetPos.add(this.byteStream.size());
                    if (this.sortOrder == SortOrder.DESC) {
                        SortOrder.invert(bytes, offset, bytes, offset, len);
                        offset = 0;
                    }
                    this.oStream.write(bytes, offset, len);
                    if (this.serializationVersion == 1) {
                        this.oStream.write(PArrayDataType.getSeparatorByte(this.rowKeyOrderOptimizable, this.sortOrder));
                    }
                }
            } else {
                if (this.sortOrder == SortOrder.DESC) {
                    SortOrder.invert(bytes, offset, bytes, offset, len);
                    offset = 0;
                }
                this.oStream.write(bytes, offset, len);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode() {
        try {
            if (!this.baseType.isFixedWidth()) {
                int noOfElements = this.offsetPos.size();
                int[] offsetPosArray = new int[noOfElements];
                int index = 0;
                int maxOffset = 0;
                for (Integer i : this.offsetPos) {
                    maxOffset = offsetPosArray[index] = i.intValue();
                    ++index;
                }
                if (this.serializationVersion == 1) {
                    PArrayDataType.writeEndSeperatorForVarLengthArray(this.oStream, this.sortOrder, this.rowKeyOrderOptimizable);
                }
                noOfElements = PArrayDataType.serializeOffsetArrayIntoStream(this.oStream, this.byteStream, noOfElements, maxOffset, offsetPosArray, this.serializationVersion);
                PArrayDataType.serializeHeaderInfoIntoStream(this.oStream, noOfElements, this.serializationVersion);
            }
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            ptr.set(this.byteStream.getBuffer(), 0, this.byteStream.size());
            byte[] byArray = ByteUtil.copyKeyBytesIfNecessary(ptr);
            return byArray;
        }
        catch (IOException iOException) {
        }
        finally {
            this.close();
        }
        return null;
    }

    public static int getEstimatedByteSize(PTable table, int rowLength, Map<PColumn, byte[]> colValueMap) {
        int rowSize = 0;
        for (PColumnFamily family : table.getColumnFamilies()) {
            Collection<PColumn> columns = family.getColumns();
            int numColumns = columns.size() + 1;
            int cellSize = 1;
            int nulls = 0;
            int maxOffset = 0;
            for (PColumn column : columns) {
                if (colValueMap.containsKey(column)) {
                    byte[] colValue = colValueMap.get(column);
                    if (colValue == null || colValue.length == 0) {
                        ++nulls;
                        maxOffset = cellSize;
                        continue;
                    }
                    if (nulls > 0) {
                        cellSize = (int)((double)cellSize + (1.0 + Math.ceil(nulls / 255)));
                        nulls = 0;
                    }
                    maxOffset = cellSize;
                    cellSize += colValue.length;
                    continue;
                }
                ++nulls;
                maxOffset = cellSize;
            }
            cellSize += PArrayDataType.useShortForOffsetArray(maxOffset, (byte)2) ? numColumns * 2 : numColumns * 4;
            cellSize += 4;
            rowSize = (int)((long)rowSize + KeyValue.getKeyValueDataStructureSize((int)rowLength, (int)family.getName().getBytes().length, (int)QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES.length, (int)(cellSize += 5)));
        }
        return rowSize;
    }
}

