/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ConcreteTableNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNodeVisitor;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;

public class NamedTableNode
extends ConcreteTableNode {
    private final List<ColumnDef> dynColumns;

    public static NamedTableNode create(String alias, TableName name, List<ColumnDef> dynColumns) {
        return new NamedTableNode(alias, name, dynColumns);
    }

    public static NamedTableNode create(TableName name) {
        return new NamedTableNode(null, name, Collections.emptyList());
    }

    public static NamedTableNode create(String schemaName, String tableName) {
        return new NamedTableNode(null, TableName.create(schemaName, tableName), Collections.emptyList());
    }

    @Deprecated
    NamedTableNode(String alias, TableName name) {
        this(alias, name, ConcreteTableNode.DEFAULT_TABLE_SAMPLING_RATE);
    }

    @Deprecated
    NamedTableNode(String alias, TableName name, List<ColumnDef> dynColumns) {
        this(alias, name, dynColumns, ConcreteTableNode.DEFAULT_TABLE_SAMPLING_RATE);
    }

    NamedTableNode(String alias, TableName name, Double tableSamplingRate) {
        super(alias, name, tableSamplingRate);
        this.dynColumns = Collections.emptyList();
    }

    NamedTableNode(String alias, TableName name, List<ColumnDef> dynColumns, Double tableSamplingRate) {
        super(alias, name, tableSamplingRate);
        this.dynColumns = dynColumns != null ? ImmutableList.copyOf(dynColumns) : Collections.emptyList();
    }

    @Override
    public <T> T accept(TableNodeVisitor<T> visitor) throws SQLException {
        return visitor.visit(this);
    }

    public List<ColumnDef> getDynamicColumns() {
        return this.dynColumns;
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        buf.append(this.getName().toString());
        if (!this.dynColumns.isEmpty()) {
            buf.append('(');
            for (ColumnDef def : this.dynColumns) {
                buf.append(def);
                buf.append(',');
            }
            buf.setLength(buf.length() - 1);
            buf.append(')');
        }
        if (this.getAlias() != null) {
            buf.append(" " + this.getAlias());
        }
        if (this.getTableSamplingRate() != null) {
            buf.append(" TABLESAMPLE " + this.getTableSamplingRate());
        }
        buf.append(' ');
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dynColumns == null ? 0 : this.dynColumns.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedTableNode other = (NamedTableNode)obj;
        return !(this.dynColumns == null ? other.dynColumns != null : !this.dynColumns.equals(other.dynColumns));
    }
}

