/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.MutatingParallelIteratorFactory;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ProjectionCompiler;
import org.apache.phoenix.compile.QueryCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.compile.SubqueryRewriter;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.AggregatePlan;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.AbstractValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.optimize.QueryOptimizer;
import org.apache.phoenix.parse.DeleteStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.DelegateColumn;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.NumberUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;

public class DeleteCompiler {
    private static ParseNodeFactory FACTORY = new ParseNodeFactory();
    private final PhoenixStatement statement;
    private final PhoenixStatement.Operation operation;

    public DeleteCompiler(PhoenixStatement statement, PhoenixStatement.Operation operation) {
        this.statement = statement;
        this.operation = operation;
    }

    private static MutationState deleteRows(StatementContext context, ResultIterator iterator, QueryPlan bestPlan, TableRef projectedTableRef, List<TableRef> otherTableRefs) throws SQLException {
        RowProjector projector = bestPlan.getProjector();
        TableRef tableRef = bestPlan.getTableRef();
        PTable table = tableRef.getTable();
        PhoenixStatement statement = context.getStatement();
        PhoenixConnection connection = statement.getConnection();
        PName tenantId = connection.getTenantId();
        byte[] tenantIdBytes = null;
        if (tenantId != null) {
            tenantIdBytes = ScanUtil.getTenantIdBytes(table.getRowKeySchema(), table.getBucketNum() != null, tenantId, table.getViewIndexId() != null);
        }
        boolean autoFlush = connection.getAutoCommit() || tableRef.getTable().isTransactional();
        ConnectionQueryServices services = connection.getQueryServices();
        int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 500000);
        long maxSizeBytes = services.getProps().getLong("phoenix.mutate.maxSizeBytes", 0x6400000L);
        int batchSize = Math.min(connection.getMutateBatchSize(), maxSize);
        MutationState.MultiRowMutationState mutations = new MutationState.MultiRowMutationState(batchSize);
        ArrayList otherMutations = null;
        if (!otherTableRefs.isEmpty()) {
            otherMutations = Lists.newArrayListWithExpectedSize((int)otherTableRefs.size());
            for (int i = 0; i < otherTableRefs.size(); ++i) {
                otherMutations.add(new MutationState.MultiRowMutationState(batchSize));
            }
        }
        List<PColumn> pkColumns = table.getPKColumns();
        boolean isMultiTenant = table.isMultiTenant() && tenantIdBytes != null;
        boolean isSharedViewIndex = table.getViewIndexId() != null;
        int offset = table.getBucketNum() == null ? 0 : 1;
        byte[][] values = new byte[pkColumns.size()][];
        if (isSharedViewIndex) {
            values[offset++] = table.getviewIndexIdType().toBytes(table.getViewIndexId());
        }
        if (isMultiTenant) {
            values[offset++] = tenantIdBytes;
        }
        try (final PhoenixResultSet rs = new PhoenixResultSet(iterator, projector, context);){
            MutationState state2;
            int i;
            AbstractValueGetter getter = null;
            if (!otherTableRefs.isEmpty()) {
                getter = new AbstractValueGetter(){
                    final ImmutableBytesWritable valuePtr = new ImmutableBytesWritable();
                    final ImmutableBytesWritable rowKeyPtr = new ImmutableBytesWritable();

                    @Override
                    public ImmutableBytesWritable getLatestValue(ColumnReference ref, long ts) throws IOException {
                        Cell cell = rs.getCurrentRow().getValue(ref.getFamily(), ref.getQualifier());
                        if (cell == null) {
                            return null;
                        }
                        this.valuePtr.set(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                        return this.valuePtr;
                    }

                    @Override
                    public byte[] getRowKey() {
                        rs.getCurrentRow().getKey(this.rowKeyPtr);
                        return ByteUtil.copyKeyBytesIfNecessary(this.rowKeyPtr);
                    }
                };
            }
            IndexMaintainer scannedIndexMaintainer = null;
            IndexMaintainer[] maintainers = null;
            PTable dataTable = table;
            if (table.getType() == PTableType.INDEX) {
                if (!otherTableRefs.isEmpty()) {
                    dataTable = otherTableRefs.get(otherTableRefs.size() - 1).getTable();
                    if (!DeleteCompiler.isMaintainedOnClient(table)) {
                        dataTable = PhoenixRuntime.getTable(connection, SchemaUtil.getTableName(dataTable.getSchemaName().getString(), dataTable.getTableName().getString()));
                    }
                    scannedIndexMaintainer = IndexMaintainer.create(dataTable, table, connection);
                }
                maintainers = new IndexMaintainer[otherTableRefs.size()];
                for (i = 0; i < otherTableRefs.size(); ++i) {
                    PTable otherTable = otherTableRefs.get(i).getTable();
                    maintainers[i] = otherTable.getType() == PTableType.INDEX ? IndexMaintainer.create(dataTable, otherTable, connection) : scannedIndexMaintainer;
                }
            } else if (!otherTableRefs.isEmpty()) {
                dataTable = table;
                maintainers = new IndexMaintainer[otherTableRefs.size()];
                for (i = 0; i < otherTableRefs.size(); ++i) {
                    maintainers[i] = IndexMaintainer.create(projectedTableRef.getTable(), otherTableRefs.get(i).getTable(), connection);
                }
            }
            byte[][] viewConstants = IndexUtil.getViewConstants(dataTable);
            int rowCount = 0;
            while (rs.next()) {
                ImmutableBytesPtr rowKeyPtr = new ImmutableBytesPtr();
                rs.getCurrentRow().getKey(rowKeyPtr);
                if (otherTableRefs.isEmpty() || DeleteCompiler.isMaintainedOnClient(table)) {
                    mutations.put(rowKeyPtr, new MutationState.RowMutationState(PRow.DELETE_MARKER, 0L, statement.getConnection().getStatementExecutionCounter(), MutationState.RowTimestampColInfo.NULL_ROWTIMESTAMP_INFO, null));
                }
                for (int i2 = 0; i2 < otherTableRefs.size(); ++i2) {
                    PTable otherTable = otherTableRefs.get(i2).getTable();
                    ImmutableBytesPtr otherRowKeyPtr = new ImmutableBytesPtr();
                    if (table.getType() == PTableType.INDEX) {
                        otherRowKeyPtr.set(scannedIndexMaintainer.buildDataRowKey(rowKeyPtr, viewConstants));
                        if (otherTable.getType() == PTableType.INDEX) {
                            otherRowKeyPtr.set(maintainers[i2].buildRowKey(getter, otherRowKeyPtr, null, null, rs.getCurrentRow().getValue(0).getTimestamp()));
                        }
                    } else {
                        otherRowKeyPtr.set(maintainers[i2].buildRowKey(getter, rowKeyPtr, null, null, rs.getCurrentRow().getValue(0).getTimestamp()));
                    }
                    ((MutationState.MultiRowMutationState)otherMutations.get(i2)).put(otherRowKeyPtr, new MutationState.RowMutationState(PRow.DELETE_MARKER, 0L, statement.getConnection().getStatementExecutionCounter(), MutationState.RowTimestampColInfo.NULL_ROWTIMESTAMP_INFO, null));
                }
                if (mutations.size() > maxSize) {
                    throw new IllegalArgumentException("MutationState size of " + mutations.size() + " is bigger than max allowed size of " + maxSize);
                }
                if (!autoFlush || ++rowCount % batchSize != 0) continue;
                MutationState state3 = new MutationState(tableRef, mutations, 0L, maxSize, maxSizeBytes, connection);
                connection.getMutationState().join(state3);
                for (int i3 = 0; i3 < otherTableRefs.size(); ++i3) {
                    MutationState indexState = new MutationState(otherTableRefs.get(i3), (MutationState.MultiRowMutationState)otherMutations.get(i3), 0L, maxSize, maxSizeBytes, connection);
                    connection.getMutationState().join(indexState);
                }
                connection.getMutationState().send();
                mutations.clear();
                if (otherMutations == null) continue;
                for (MutationState.MultiRowMutationState multiRowMutationState : otherMutations) {
                    multiRowMutationState.clear();
                }
            }
            int nCommittedRows = autoFlush ? rowCount / batchSize * batchSize : 0;
            MutationState tableState = new MutationState(tableRef, mutations, nCommittedRows, maxSize, maxSizeBytes, connection);
            if (otherTableRefs.isEmpty()) {
                state2 = tableState;
            } else {
                state2 = new MutationState(maxSize, maxSizeBytes, connection);
                state2.join(tableState);
            }
            for (int i4 = 0; i4 < otherTableRefs.size(); ++i4) {
                MutationState indexState = new MutationState(otherTableRefs.get(i4), (MutationState.MultiRowMutationState)otherMutations.get(i4), 0L, maxSize, maxSizeBytes, connection);
                state2.join(indexState);
            }
            MutationState mutationState = state2;
            return mutationState;
        }
    }

    private List<PTable> getClientSideMaintainedIndexes(TableRef tableRef) {
        PTable table = tableRef.getTable();
        if (!table.getIndexes().isEmpty()) {
            ArrayList nonDisabledIndexes = Lists.newArrayListWithExpectedSize((int)table.getIndexes().size());
            for (PTable index : table.getIndexes()) {
                if (index.getIndexState() == PIndexState.DISABLE || !DeleteCompiler.isMaintainedOnClient(index)) continue;
                nonDisabledIndexes.add(index);
            }
            return nonDisabledIndexes;
        }
        return Collections.emptyList();
    }

    public MutationPlan compile(DeleteStatement delete) throws SQLException {
        boolean hasPreProcessing;
        PColumn column;
        int i;
        int pkColumnCount;
        PhoenixConnection connection = this.statement.getConnection();
        boolean isAutoCommit = connection.getAutoCommit();
        boolean hasPostProcessing = delete.getLimit() != null;
        ConnectionQueryServices services = connection.getQueryServices();
        boolean allowServerMutations = services.getProps().getBoolean("phoenix.client.enable.server.delete.mutations", true);
        NamedTableNode tableNode = delete.getTable();
        String tableName = tableNode.getName().getTableName();
        String schemaName = tableNode.getName().getSchemaName();
        SelectStatement select = null;
        ColumnResolver resolverToBe = null;
        resolverToBe = FromCompiler.getResolverForMutation(delete, connection);
        TableRef targetTableRef = resolverToBe.getTables().get(0);
        PTable table = targetTableRef.getTable();
        if (table.getType() == PTableType.VIEW && table.getViewType().isReadOnly()) {
            throw new ReadOnlyTableException(schemaName, tableName);
        }
        if (table.isTransactional() && connection.getSCN() != null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SPECIFY_SCN_FOR_TXN_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
        }
        List<PTable> clientSideIndexes = this.getClientSideMaintainedIndexes(targetTableRef);
        boolean hasClientSideIndexes = !clientSideIndexes.isEmpty();
        boolean isSalted = table.getBucketNum() != null;
        boolean isMultiTenant = connection.getTenantId() != null && table.isMultiTenant();
        boolean isSharedViewIndex = table.getViewIndexId() != null;
        int pkColumnOffset = (isSalted ? 1 : 0) + (isMultiTenant ? 1 : 0) + (isSharedViewIndex ? 1 : 0);
        int selectColumnCount = pkColumnCount = table.getPKColumns().size() - pkColumnOffset;
        for (PTable index : clientSideIndexes) {
            selectColumnCount += index.getPKColumns().size() - pkColumnCount;
        }
        LinkedHashSet<PColumn> projectedColumns = new LinkedHashSet<PColumn>(selectColumnCount + pkColumnOffset);
        ArrayList aliasedNodes = Lists.newArrayListWithExpectedSize((int)selectColumnCount);
        int n = i = isSalted ? 1 : 0;
        while (i < pkColumnOffset) {
            column = table.getPKColumns().get(i);
            projectedColumns.add(column);
            ++i;
        }
        for (i = pkColumnOffset; i < table.getPKColumns().size(); ++i) {
            column = table.getPKColumns().get(i);
            projectedColumns.add(column);
            aliasedNodes.add(FACTORY.aliasedNode(null, FACTORY.column(null, '\"' + column.getName().getString() + '\"', null)));
        }
        for (PTable index : table.getIndexes()) {
            if (!DeleteCompiler.isMaintainedOnClient(index)) continue;
            IndexMaintainer maintainer = index.getIndexMaintainer(table, connection);
            for (Pair<String, String> columnInfo : maintainer.getIndexedColumnInfo()) {
                String familyName = (String)columnInfo.getFirst();
                if (familyName == null) continue;
                String columnName = (String)columnInfo.getSecond();
                boolean hasNoColumnFamilies = table.getColumnFamilies().isEmpty();
                PColumn column2 = hasNoColumnFamilies ? table.getColumnForColumnName(columnName) : table.getColumnFamily(familyName).getPColumnForColumnName(columnName);
                if (projectedColumns.contains(column2)) continue;
                projectedColumns.add(column2);
                aliasedNodes.add(FACTORY.aliasedNode(null, FACTORY.column(hasNoColumnFamilies ? null : TableName.create(null, familyName), '\"' + columnName + '\"', null)));
            }
        }
        select = FACTORY.select(delete.getTable(), delete.getHint(), false, aliasedNodes, delete.getWhere(), Collections.emptyList(), null, delete.getOrderBy(), delete.getLimit(), null, delete.getBindCount(), false, false, Collections.emptyList(), delete.getUdfParseNodes());
        SelectStatement transformedSelect = SubqueryRewriter.transform(select = StatementNormalizer.normalize(select, resolverToBe), resolverToBe, connection);
        boolean bl = hasPreProcessing = transformedSelect != select;
        if (transformedSelect != select) {
            resolverToBe = FromCompiler.getResolverForQuery(transformedSelect, connection, false, delete.getTable().getName());
            select = StatementNormalizer.normalize(transformedSelect, resolverToBe);
        }
        boolean hasPreOrPostProcessing = hasPreProcessing || hasPostProcessing;
        boolean noQueryReqd = !hasPreOrPostProcessing;
        boolean runOnServer = isAutoCommit && !hasPreOrPostProcessing && !table.isTransactional() && !hasClientSideIndexes && allowServerMutations;
        HintNode hint = delete.getHint();
        if (runOnServer && !delete.getHint().hasHint(HintNode.Hint.USE_INDEX_OVER_DATA_TABLE)) {
            select = SelectStatement.create(select, HintNode.create(hint, HintNode.Hint.USE_DATA_OVER_INDEX_TABLE));
        }
        DeletingParallelIteratorFactory parallelIteratorFactoryToBe = hasPreOrPostProcessing ? null : new DeletingParallelIteratorFactory(connection);
        QueryOptimizer optimizer = new QueryOptimizer(services);
        QueryCompiler compiler = new QueryCompiler(this.statement, select, resolverToBe, Collections.emptyList(), parallelIteratorFactoryToBe, new SequenceManager(this.statement));
        QueryPlan dataPlan = compiler.compile();
        ArrayList queryPlans = Lists.newArrayList(!clientSideIndexes.isEmpty() ? optimizer.getApplicablePlans(dataPlan, this.statement, select, resolverToBe, Collections.emptyList(), parallelIteratorFactoryToBe) : optimizer.getBestPlan(dataPlan, this.statement, select, resolverToBe, Collections.emptyList(), parallelIteratorFactoryToBe));
        runOnServer &= ((QueryPlan)queryPlans.get(0)).getTableRef().getTable().getType() != PTableType.INDEX;
        noQueryReqd &= queryPlans.size() == 1 + clientSideIndexes.size();
        int queryPlanIndex = 0;
        while (noQueryReqd && queryPlanIndex < queryPlans.size()) {
            QueryPlan plan;
            StatementContext context;
            noQueryReqd &= (!(context = (plan = (QueryPlan)queryPlans.get(queryPlanIndex++)).getContext()).getScan().hasFilter() || context.getScan().getFilter() instanceof SkipScanFilter) && context.getScanRanges().isPointLookup();
        }
        int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 500000);
        long maxSizeBytes = services.getProps().getLong("phoenix.mutate.maxSizeBytes", 0x6400000L);
        if (noQueryReqd) {
            ArrayList mutationPlans = Lists.newArrayListWithExpectedSize((int)queryPlans.size());
            for (QueryPlan plan : queryPlans) {
                mutationPlans.add(new SingleRowDeleteMutationPlan(plan, connection, maxSize, maxSizeBytes));
            }
            return new MultiRowDeleteMutationPlan(dataPlan, mutationPlans);
        }
        if (runOnServer) {
            StatementContext context = dataPlan.getContext();
            Scan scan = context.getScan();
            scan.setAttribute("_DeleteAgg", QueryConstants.TRUE);
            SelectStatement aggSelect = SelectStatement.create(SelectStatement.COUNT_ONE, delete.getHint());
            RowProjector projectorToBe = ProjectionCompiler.compile(context, aggSelect, GroupByCompiler.GroupBy.EMPTY_GROUP_BY);
            context.getAggregationManager().compile(context, GroupByCompiler.GroupBy.EMPTY_GROUP_BY);
            if (dataPlan.getProjector().projectEveryRow()) {
                projectorToBe = new RowProjector(projectorToBe, true);
            }
            RowProjector projector = projectorToBe;
            AggregatePlan aggPlan = new AggregatePlan(context, select, dataPlan.getTableRef(), projector, null, null, OrderByCompiler.OrderBy.EMPTY_ORDER_BY, null, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, null, dataPlan);
            return new ServerSelectDeleteMutationPlan(dataPlan, connection, aggPlan, projector, maxSize, maxSizeBytes);
        }
        DeletingParallelIteratorFactory parallelIteratorFactory = parallelIteratorFactoryToBe;
        ArrayList adjustedProjectedColumns = Lists.newArrayListWithExpectedSize((int)projectedColumns.size());
        final int offset = table.getBucketNum() == null ? 0 : 1;
        Iterator projectedColsItr = projectedColumns.iterator();
        int i2 = 0;
        while (projectedColsItr.hasNext()) {
            final int position = i2++;
            adjustedProjectedColumns.add(new DelegateColumn((PColumn)projectedColsItr.next()){

                @Override
                public int getPosition() {
                    return position + offset;
                }
            });
        }
        PTableImpl projectedTable = PTableImpl.builderWithColumns(table, adjustedProjectedColumns).setType(PTableType.PROJECTED).build();
        TableRef projectedTableRef = new TableRef(projectedTable, targetTableRef.getLowerBoundTimeStamp(), targetTableRef.getTimeStamp());
        QueryPlan bestPlanToBe = dataPlan;
        for (QueryPlan plan : queryPlans) {
            PTable planTable = plan.getTableRef().getTable();
            if (planTable.getIndexState() == PIndexState.BUILDING) continue;
            bestPlanToBe = plan;
            break;
        }
        QueryPlan bestPlan = bestPlanToBe;
        ArrayList otherTableRefs = Lists.newArrayListWithExpectedSize((int)clientSideIndexes.size());
        for (PTable index : clientSideIndexes) {
            if (bestPlan.getTableRef().getTable().equals(index)) continue;
            otherTableRefs.add(new TableRef(index, targetTableRef.getLowerBoundTimeStamp(), targetTableRef.getTimeStamp()));
        }
        if (!bestPlan.getTableRef().getTable().equals(targetTableRef.getTable())) {
            otherTableRefs.add(projectedTableRef);
        }
        return new ClientSelectDeleteMutationPlan(targetTableRef, dataPlan, bestPlan, hasPreOrPostProcessing, parallelIteratorFactory, otherTableRefs, projectedTableRef, maxSize, maxSizeBytes, connection);
    }

    private static boolean isMaintainedOnClient(PTable table) {
        return table.getIndexType() != PTable.IndexType.LOCAL && (table.isTransactional() || table.isImmutableRows()) || table.getIndexType() == PTable.IndexType.LOCAL && table.isTransactional() && table.getTransactionProvider().getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.MAINTAIN_LOCAL_INDEX_ON_SERVER);
    }

    public class ClientSelectDeleteMutationPlan
    implements MutationPlan {
        private final StatementContext context;
        private final TableRef targetTableRef;
        private final QueryPlan dataPlan;
        private final QueryPlan bestPlan;
        private final boolean hasPreOrPostProcessing;
        private final DeletingParallelIteratorFactory parallelIteratorFactory;
        private final List<TableRef> otherTableRefs;
        private final TableRef projectedTableRef;
        private final int maxSize;
        private final long maxSizeBytes;
        private final PhoenixConnection connection;

        public ClientSelectDeleteMutationPlan(TableRef targetTableRef, QueryPlan dataPlan, QueryPlan bestPlan, boolean hasPreOrPostProcessing, DeletingParallelIteratorFactory parallelIteratorFactory, List<TableRef> otherTableRefs, TableRef projectedTableRef, int maxSize, long maxSizeBytes, PhoenixConnection connection) {
            this.context = bestPlan.getContext();
            this.targetTableRef = targetTableRef;
            this.dataPlan = dataPlan;
            this.bestPlan = bestPlan;
            this.hasPreOrPostProcessing = hasPreOrPostProcessing;
            this.parallelIteratorFactory = parallelIteratorFactory;
            this.otherTableRefs = otherTableRefs;
            this.projectedTableRef = projectedTableRef;
            this.maxSize = maxSize;
            this.maxSizeBytes = maxSizeBytes;
            this.connection = connection;
        }

        @Override
        public ParameterMetaData getParameterMetaData() {
            return this.context.getBindManager().getParameterMetaData();
        }

        @Override
        public StatementContext getContext() {
            return this.context;
        }

        @Override
        public TableRef getTargetRef() {
            return this.targetTableRef;
        }

        @Override
        public Set<TableRef> getSourceRefs() {
            return this.dataPlan.getSourceRefs();
        }

        @Override
        public PhoenixStatement.Operation getOperation() {
            return DeleteCompiler.this.operation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MutationState execute() throws SQLException {
            try (ResultIterator iterator = this.bestPlan.iterator();){
                if (!this.hasPreOrPostProcessing) {
                    Tuple tuple;
                    long totalRowCount = 0L;
                    if (this.parallelIteratorFactory != null) {
                        this.parallelIteratorFactory.setQueryPlan(this.bestPlan);
                        this.parallelIteratorFactory.setOtherTableRefs(this.otherTableRefs);
                        this.parallelIteratorFactory.setProjectedTableRef(this.projectedTableRef);
                    }
                    while ((tuple = iterator.next()) != null) {
                        Cell kv = tuple.getValue(0);
                        totalRowCount += PLong.INSTANCE.getCodec().decodeLong(kv.getValueArray(), kv.getValueOffset(), SortOrder.getDefault());
                    }
                    MutationState state2 = new MutationState(this.maxSize, this.maxSizeBytes, this.connection, totalRowCount);
                    state2.setReadMetricQueue(this.context.getReadMetricsQueue());
                    MutationState mutationState = state2;
                    return mutationState;
                }
                MutationState mutationState = DeleteCompiler.deleteRows(this.context, iterator, this.bestPlan, this.projectedTableRef, this.otherTableRefs);
                return mutationState;
            }
        }

        @Override
        public ExplainPlan getExplainPlan() throws SQLException {
            ExplainPlan explainPlan = this.bestPlan.getExplainPlan();
            List<String> queryPlanSteps = explainPlan.getPlanSteps();
            ExplainPlanAttributes explainPlanAttributes = explainPlan.getPlanStepsAsAttributes();
            ArrayList planSteps = Lists.newArrayListWithExpectedSize((int)(queryPlanSteps.size() + 1));
            ExplainPlanAttributes.ExplainPlanAttributesBuilder newBuilder = new ExplainPlanAttributes.ExplainPlanAttributesBuilder(explainPlanAttributes);
            newBuilder.setAbstractExplainPlan("DELETE ROWS CLIENT SELECT");
            planSteps.add("DELETE ROWS CLIENT SELECT");
            planSteps.addAll(queryPlanSteps);
            return new ExplainPlan(planSteps, newBuilder.build());
        }

        @Override
        public Long getEstimatedRowsToScan() throws SQLException {
            return this.bestPlan.getEstimatedRowsToScan();
        }

        @Override
        public Long getEstimatedBytesToScan() throws SQLException {
            return this.bestPlan.getEstimatedBytesToScan();
        }

        @Override
        public Long getEstimateInfoTimestamp() throws SQLException {
            return this.bestPlan.getEstimateInfoTimestamp();
        }

        @Override
        public QueryPlan getQueryPlan() {
            return this.bestPlan;
        }
    }

    public class ServerSelectDeleteMutationPlan
    implements MutationPlan {
        private final StatementContext context;
        private final QueryPlan dataPlan;
        private final PhoenixConnection connection;
        private final QueryPlan aggPlan;
        private final RowProjector projector;
        private final int maxSize;
        private final long maxSizeBytes;

        public ServerSelectDeleteMutationPlan(QueryPlan dataPlan, PhoenixConnection connection, QueryPlan aggPlan, RowProjector projector, int maxSize, long maxSizeBytes) {
            this.context = dataPlan.getContext();
            this.dataPlan = dataPlan;
            this.connection = connection;
            this.aggPlan = aggPlan;
            this.projector = projector;
            this.maxSize = maxSize;
            this.maxSizeBytes = maxSizeBytes;
        }

        @Override
        public ParameterMetaData getParameterMetaData() {
            return this.context.getBindManager().getParameterMetaData();
        }

        @Override
        public StatementContext getContext() {
            return this.context;
        }

        @Override
        public TableRef getTargetRef() {
            return this.dataPlan.getTableRef();
        }

        @Override
        public Set<TableRef> getSourceRefs() {
            return this.dataPlan.getSourceRefs();
        }

        @Override
        public PhoenixStatement.Operation getOperation() {
            return DeleteCompiler.this.operation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MutationState execute() throws SQLException {
            ImmutableBytesWritable ptr = this.context.getTempPtr();
            PTable table = this.dataPlan.getTableRef().getTable();
            table.getIndexMaintainers(ptr, this.context.getConnection());
            ScanUtil.setWALAnnotationAttributes(table, this.context.getScan());
            byte[] txState = table.isTransactional() ? this.connection.getMutationState().encodeTransaction() : ByteUtil.EMPTY_BYTE_ARRAY;
            try (ServerCacheClient.ServerCache cache = null;){
                MutationState mutationState;
                if (ptr.getLength() > 0) {
                    byte[] uuidValue = ServerCacheClient.generateId();
                    this.context.getScan().setAttribute("IdxUUID", uuidValue);
                    this.context.getScan().setAttribute("IdxProtoMD", ptr.get());
                    this.context.getScan().setAttribute("_TxState", txState);
                    ScanUtil.setClientVersion(this.context.getScan(), MetaDataProtocol.PHOENIX_VERSION);
                    String sourceOfDelete = DeleteCompiler.this.statement.getConnection().getSourceOfOperation();
                    if (sourceOfDelete != null) {
                        this.context.getScan().setAttribute("phoenix.source.operation", Bytes.toBytes((String)sourceOfDelete));
                    }
                }
                ResultIterator iterator = this.aggPlan.iterator();
                try {
                    Tuple row = iterator.next();
                    final long mutationCount = (Long)this.projector.getColumnProjector(0).getValue(row, PLong.INSTANCE, ptr);
                    mutationState = new MutationState(this.maxSize, this.maxSizeBytes, this.connection){

                        @Override
                        public long getUpdateCount() {
                            return mutationCount;
                        }
                    };
                }
                catch (Throwable throwable) {
                    iterator.close();
                    throw throwable;
                }
                iterator.close();
                return mutationState;
            }
        }

        @Override
        public ExplainPlan getExplainPlan() throws SQLException {
            ExplainPlan explainPlan = this.aggPlan.getExplainPlan();
            List<String> queryPlanSteps = explainPlan.getPlanSteps();
            ExplainPlanAttributes explainPlanAttributes = explainPlan.getPlanStepsAsAttributes();
            ArrayList planSteps = Lists.newArrayListWithExpectedSize((int)(queryPlanSteps.size() + 1));
            ExplainPlanAttributes.ExplainPlanAttributesBuilder newBuilder = new ExplainPlanAttributes.ExplainPlanAttributesBuilder(explainPlanAttributes);
            newBuilder.setAbstractExplainPlan("DELETE ROWS SERVER SELECT");
            planSteps.add("DELETE ROWS SERVER SELECT");
            planSteps.addAll(queryPlanSteps);
            return new ExplainPlan(planSteps, newBuilder.build());
        }

        @Override
        public Long getEstimatedRowsToScan() throws SQLException {
            return this.aggPlan.getEstimatedRowsToScan();
        }

        @Override
        public Long getEstimatedBytesToScan() throws SQLException {
            return this.aggPlan.getEstimatedBytesToScan();
        }

        @Override
        public Long getEstimateInfoTimestamp() throws SQLException {
            return this.aggPlan.getEstimateInfoTimestamp();
        }

        @Override
        public QueryPlan getQueryPlan() {
            return this.aggPlan;
        }
    }

    private class SingleRowDeleteMutationPlan
    implements MutationPlan {
        private final QueryPlan dataPlan;
        private final PhoenixConnection connection;
        private final int maxSize;
        private final StatementContext context;
        private final long maxSizeBytes;

        public SingleRowDeleteMutationPlan(QueryPlan dataPlan, PhoenixConnection connection, int maxSize, long maxSizeBytes) {
            this.dataPlan = dataPlan;
            this.connection = connection;
            this.maxSize = maxSize;
            this.context = dataPlan.getContext();
            this.maxSizeBytes = maxSizeBytes;
        }

        @Override
        public ParameterMetaData getParameterMetaData() {
            return this.context.getBindManager().getParameterMetaData();
        }

        @Override
        public MutationState execute() throws SQLException {
            ScanRanges ranges = this.context.getScanRanges();
            Iterator<KeyRange> iterator = ranges.getPointLookupKeyIterator();
            MutationState.MultiRowMutationState mutation = new MutationState.MultiRowMutationState(ranges.getPointLookupCount());
            while (iterator.hasNext()) {
                mutation.put(new ImmutableBytesPtr(iterator.next().getLowerRange()), new MutationState.RowMutationState(PRow.DELETE_MARKER, 0L, DeleteCompiler.this.statement.getConnection().getStatementExecutionCounter(), MutationState.RowTimestampColInfo.NULL_ROWTIMESTAMP_INFO, null));
            }
            return new MutationState(this.dataPlan.getTableRef(), mutation, 0L, this.maxSize, this.maxSizeBytes, this.connection);
        }

        @Override
        public ExplainPlan getExplainPlan() throws SQLException {
            return new ExplainPlan(Collections.singletonList("DELETE SINGLE ROW"));
        }

        @Override
        public QueryPlan getQueryPlan() {
            return this.dataPlan;
        }

        @Override
        public StatementContext getContext() {
            return this.context;
        }

        @Override
        public TableRef getTargetRef() {
            return this.dataPlan.getTableRef();
        }

        @Override
        public Set<TableRef> getSourceRefs() {
            return Collections.emptySet();
        }

        @Override
        public PhoenixStatement.Operation getOperation() {
            return DeleteCompiler.this.operation;
        }

        @Override
        public Long getEstimatedRowsToScan() throws SQLException {
            return 0L;
        }

        @Override
        public Long getEstimatedBytesToScan() throws SQLException {
            return 0L;
        }

        @Override
        public Long getEstimateInfoTimestamp() throws SQLException {
            return 0L;
        }
    }

    public class MultiRowDeleteMutationPlan
    implements MutationPlan {
        private final List<MutationPlan> plans;
        private final MutationPlan firstPlan;
        private final QueryPlan dataPlan;

        public MultiRowDeleteMutationPlan(@NonNull QueryPlan dataPlan, List<MutationPlan> plans) {
            Preconditions.checkArgument((!plans.isEmpty() ? 1 : 0) != 0);
            this.plans = plans;
            this.firstPlan = plans.get(0);
            this.dataPlan = dataPlan;
        }

        @Override
        public StatementContext getContext() {
            return this.firstPlan.getContext();
        }

        @Override
        public ParameterMetaData getParameterMetaData() {
            return this.firstPlan.getParameterMetaData();
        }

        @Override
        public ExplainPlan getExplainPlan() throws SQLException {
            return this.firstPlan.getExplainPlan();
        }

        @Override
        public MutationState execute() throws SQLException {
            MutationState state2 = this.firstPlan.execute();
            DeleteCompiler.this.statement.getConnection().getMutationState().join(state2);
            for (MutationPlan plan : this.plans.subList(1, this.plans.size())) {
                DeleteCompiler.this.statement.getConnection().getMutationState().join(plan.execute());
            }
            return state2;
        }

        @Override
        public TableRef getTargetRef() {
            return this.firstPlan.getTargetRef();
        }

        @Override
        public Set<TableRef> getSourceRefs() {
            return this.firstPlan.getSourceRefs();
        }

        @Override
        public PhoenixStatement.Operation getOperation() {
            return DeleteCompiler.this.operation;
        }

        @Override
        public Long getEstimatedRowsToScan() throws SQLException {
            Long estRows = null;
            for (MutationPlan plan : this.plans) {
                if (plan.getEstimatedRowsToScan() == null) {
                    return null;
                }
                estRows = NumberUtil.add(estRows, plan.getEstimatedRowsToScan());
            }
            return estRows;
        }

        @Override
        public Long getEstimatedBytesToScan() throws SQLException {
            Long estBytes = null;
            for (MutationPlan plan : this.plans) {
                if (plan.getEstimatedBytesToScan() == null) {
                    return null;
                }
                estBytes = NumberUtil.add(estBytes, plan.getEstimatedBytesToScan());
            }
            return estBytes;
        }

        @Override
        public Long getEstimateInfoTimestamp() throws SQLException {
            Long estInfoTimestamp = Long.MAX_VALUE;
            for (MutationPlan plan : this.plans) {
                Long timestamp = plan.getEstimateInfoTimestamp();
                if (timestamp == null) {
                    return timestamp;
                }
                estInfoTimestamp = Math.min(estInfoTimestamp, timestamp);
            }
            return estInfoTimestamp;
        }

        @Override
        public QueryPlan getQueryPlan() {
            return this.dataPlan;
        }
    }

    private static class DeletingParallelIteratorFactory
    extends MutatingParallelIteratorFactory {
        private QueryPlan queryPlan;
        private List<TableRef> otherTableRefs;
        private TableRef projectedTableRef;

        private DeletingParallelIteratorFactory(PhoenixConnection connection) {
            super(connection);
        }

        @Override
        protected MutationState mutate(StatementContext parentContext, ResultIterator iterator, PhoenixConnection connection) throws SQLException {
            PhoenixStatement statement = new PhoenixStatement(connection);
            StatementContext context = new StatementContext(statement, false);
            MutationState state2 = DeleteCompiler.deleteRows(context, iterator, this.queryPlan, this.projectedTableRef, this.otherTableRefs);
            return state2;
        }

        public void setQueryPlan(QueryPlan queryPlan) {
            this.queryPlan = queryPlan;
        }

        public void setOtherTableRefs(List<TableRef> otherTableRefs) {
            this.otherTableRefs = otherTableRefs;
        }

        public void setProjectedTableRef(TableRef projectedTableRef) {
            this.projectedTableRef = projectedTableRef;
        }
    }
}

