/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfTypeException;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.OrderedDataType;
import io.jhdf.storage.HdfBackingStorage;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class FixedPoint
extends DataType
implements OrderedDataType {
    private final ByteOrder order;
    private final boolean lowPadding;
    private final boolean highPadding;
    private final boolean signed;
    private final short bitOffset;
    private final short bitPrecision;

    public FixedPoint(ByteBuffer bb) {
        super(bb);
        this.order = this.classBits.get(0) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.lowPadding = this.classBits.get(1);
        this.highPadding = this.classBits.get(2);
        this.signed = this.classBits.get(3);
        this.bitOffset = bb.getShort();
        this.bitPrecision = bb.getShort();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.order;
    }

    public boolean isLowPadding() {
        return this.lowPadding;
    }

    public boolean isHighPadding() {
        return this.highPadding;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public short getBitOffset() {
        return this.bitOffset;
    }

    public short getBitPrecision() {
        return this.bitPrecision;
    }

    @Override
    public Class<?> getJavaType() {
        if (this.signed) {
            switch (this.bitPrecision) {
                case 8: {
                    return Byte.TYPE;
                }
                case 16: {
                    return Short.TYPE;
                }
                case 32: {
                    return Integer.TYPE;
                }
                case 64: {
                    return Long.TYPE;
                }
            }
            throw new HdfTypeException("Unsupported signed fixed point data type");
        }
        switch (this.bitPrecision) {
            case 8: 
            case 16: {
                return Integer.TYPE;
            }
            case 32: {
                return Long.TYPE;
            }
            case 64: {
                return BigInteger.class;
            }
        }
        throw new HdfTypeException("Unsupported signed fixed point data type");
    }

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfBackingStorage hdfBackingStorage) {
        Object data;
        block13: {
            ByteOrder byteOrder;
            block12: {
                data = Array.newInstance(this.getJavaType(), dimensions);
                byteOrder = this.getByteOrder();
                if (!this.isSigned()) break block12;
                switch (this.getSize()) {
                    case 1: {
                        FixedPoint.fillData(data, dimensions, buffer.order(byteOrder));
                        break block13;
                    }
                    case 2: {
                        FixedPoint.fillData(data, dimensions, buffer.order(byteOrder).asShortBuffer());
                        break block13;
                    }
                    case 4: {
                        FixedPoint.fillData(data, dimensions, buffer.order(byteOrder).asIntBuffer());
                        break block13;
                    }
                    case 8: {
                        FixedPoint.fillData(data, dimensions, buffer.order(byteOrder).asLongBuffer());
                        break block13;
                    }
                    default: {
                        throw new HdfTypeException("Unsupported signed integer type size " + this.getSize() + " bytes");
                    }
                }
            }
            switch (this.getSize()) {
                case 1: {
                    FixedPoint.fillDataUnsigned(data, dimensions, buffer.order(byteOrder));
                    break;
                }
                case 2: {
                    FixedPoint.fillDataUnsigned(data, dimensions, buffer.order(byteOrder).asShortBuffer());
                    break;
                }
                case 4: {
                    FixedPoint.fillDataUnsigned(data, dimensions, buffer.order(byteOrder).asIntBuffer());
                    break;
                }
                case 8: {
                    FixedPoint.fillDataUnsigned(data, dimensions, buffer.order(byteOrder).asLongBuffer());
                    break;
                }
                default: {
                    throw new HdfTypeException("Unsupported unsigned integer type size " + this.getSize() + " bytes");
                }
            }
        }
        return data;
    }

    private static void fillData(Object data, int[] dims, ByteBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            buffer.get((byte[])data);
        }
    }

    private static void fillData(Object data, int[] dims, ShortBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            buffer.get((short[])data);
        }
    }

    private static void fillData(Object data, int[] dims, IntBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            buffer.get((int[])data);
        }
    }

    private static void fillData(Object data, int[] dims, LongBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            buffer.get((long[])data);
        }
    }

    private static void fillDataUnsigned(Object data, int[] dims, ByteBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillDataUnsigned(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            byte[] tempBuffer = new byte[dims[0]];
            buffer.get(tempBuffer);
            int[] intData = (int[])data;
            for (int i = 0; i < tempBuffer.length; ++i) {
                intData[i] = Byte.toUnsignedInt(tempBuffer[i]);
            }
        }
    }

    private static void fillDataUnsigned(Object data, int[] dims, ShortBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillDataUnsigned(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            short[] tempBuffer = new short[dims[0]];
            buffer.get(tempBuffer);
            int[] intData = (int[])data;
            for (int i = 0; i < tempBuffer.length; ++i) {
                intData[i] = Short.toUnsignedInt(tempBuffer[i]);
            }
        }
    }

    private static void fillDataUnsigned(Object data, int[] dims, IntBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillDataUnsigned(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            int[] tempBuffer = new int[dims[0]];
            buffer.get(tempBuffer);
            long[] longData = (long[])data;
            for (int i = 0; i < tempBuffer.length; ++i) {
                longData[i] = Integer.toUnsignedLong(tempBuffer[i]);
            }
        }
    }

    private static void fillDataUnsigned(Object data, int[] dims, LongBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillDataUnsigned(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            long[] tempBuffer = new long[dims[0]];
            ByteBuffer tempByteBuffer = ByteBuffer.allocate(8);
            buffer.get(tempBuffer);
            BigInteger[] bigIntData = (BigInteger[])data;
            for (int i = 0; i < tempBuffer.length; ++i) {
                tempByteBuffer.putLong(0, tempBuffer[i]);
                bigIntData[i] = new BigInteger(1, tempByteBuffer.array());
            }
        }
    }
}

