/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.filter;

import io.jhdf.exceptions.HdfFilterException;
import io.jhdf.filter.Filter;
import java.io.ByteArrayOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeflatePipelineFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(DeflatePipelineFilter.class);

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public String getName() {
        return "deflate";
    }

    @Override
    public byte[] decode(byte[] compressedData, int[] filterData) {
        try {
            Inflater inflater = new Inflater();
            inflater.setInput(compressedData);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(compressedData.length * 3);
            byte[] buffer = new byte[4096];
            while (!inflater.finished()) {
                int read = inflater.inflate(buffer);
                baos.write(buffer, 0, read);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Decompressed chunk. Compressed size = {} bytes, Decompressed size = {}", (Object)inflater.getBytesRead(), (Object)inflater.getBytesWritten());
            }
            inflater.end();
            return baos.toByteArray();
        }
        catch (DataFormatException e) {
            throw new HdfFilterException("Inflating failed", e);
        }
    }
}

