/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log;

import hive.com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="HiveEventCounter", category="Core", elementType="appender", printObject=true)
public class HiveEventCounter
extends AbstractAppender {
    private static LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
    private static Configuration configuration = context.getConfiguration();
    private static final String APPENDER_NAME = "HiveEventCounter";
    private static final int FATAL = 0;
    private static final int ERROR = 1;
    private static final int WARN = 2;
    private static final int INFO = 3;
    private static EventCounts counts = new EventCounts();

    protected HiveEventCounter(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
    }

    @PluginFactory
    public static HiveEventCounter createInstance(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginElement(value="Layout") Layout layout, @PluginElement(value="Filters") Filter filter) {
        if (name == null) {
            name = APPENDER_NAME;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new HiveEventCounter(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions);
    }

    @InterfaceAudience.Private
    public static long getFatal() {
        return counts.get(0);
    }

    @InterfaceAudience.Private
    public static long getError() {
        return counts.get(1);
    }

    @InterfaceAudience.Private
    public static long getWarn() {
        return counts.get(2);
    }

    @InterfaceAudience.Private
    public static long getInfo() {
        return counts.get(3);
    }

    @VisibleForTesting
    public void addToLogger(String loggerName, Level level) {
        LoggerConfig loggerConfig = configuration.getLoggerConfig(loggerName);
        loggerConfig.addAppender((Appender)this, level, null);
        context.updateLoggers();
    }

    @VisibleForTesting
    public void removeFromLogger(String loggerName) {
        LoggerConfig loggerConfig = configuration.getLoggerConfig(loggerName);
        loggerConfig.removeAppender(APPENDER_NAME);
        context.updateLoggers();
    }

    public void append(LogEvent event) {
        Level level = event.getLevel();
        if (level.equals((Object)Level.INFO)) {
            counts.incr(3);
        } else if (level.equals((Object)Level.WARN)) {
            counts.incr(2);
        } else if (level.equals((Object)Level.ERROR)) {
            counts.incr(1);
        } else if (level.equals((Object)Level.FATAL)) {
            counts.incr(0);
        }
    }

    private static class EventCounts {
        private final AtomicLongArray counts = new AtomicLongArray(4);

        private EventCounts() {
        }

        private void incr(int i) {
            this.counts.incrementAndGet(i);
        }

        private long get(int i) {
            return this.counts.get(i);
        }
    }
}

