/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import hive.org.apache.parquet.io.api.Converter;
import hive.org.apache.parquet.schema.GroupType;
import hive.org.apache.parquet.schema.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.io.parquet.convert.ConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveGroupConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.Repeated;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;

public class HiveStructConverter
extends HiveGroupConverter {
    private final int totalFieldCount;
    private Converter[] converters;
    private final ConverterParent parent;
    private final int index;
    private Writable[] writables;
    private List<Repeated> repeatedConverters;
    private boolean reuseWritableArray = false;
    private List<String> hiveFieldNames;
    private List<TypeInfo> hiveFieldTypeInfos;

    public HiveStructConverter(GroupType requestedSchema, GroupType tableSchema, Map<String, String> metadata, TypeInfo hiveTypeInfo) {
        this.setMetadata(metadata);
        this.reuseWritableArray = true;
        this.writables = new Writable[tableSchema.getFieldCount()];
        this.parent = null;
        this.index = 0;
        this.totalFieldCount = tableSchema.getFieldCount();
        this.init(requestedSchema, null, 0, tableSchema, hiveTypeInfo);
    }

    public HiveStructConverter(GroupType groupType, ConverterParent parent, int index, TypeInfo hiveTypeInfo) {
        this(groupType, parent, index, groupType, hiveTypeInfo);
    }

    public HiveStructConverter(GroupType selectedGroupType, ConverterParent parent, int index, GroupType containingGroupType, TypeInfo hiveTypeInfo) {
        this.parent = parent;
        this.index = index;
        this.totalFieldCount = containingGroupType.getFieldCount();
        this.init(selectedGroupType, parent, index, containingGroupType, hiveTypeInfo);
    }

    private void init(GroupType selectedGroupType, ConverterParent parent, int index, GroupType containingGroupType, TypeInfo hiveTypeInfo) {
        if (parent != null) {
            this.setMetadata(parent.getMetadata());
        }
        int selectedFieldCount = selectedGroupType.getFieldCount();
        this.converters = new Converter[selectedFieldCount];
        this.repeatedConverters = new ArrayList<Repeated>();
        if (hiveTypeInfo != null && hiveTypeInfo.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            this.hiveFieldNames = ((StructTypeInfo)hiveTypeInfo).getAllStructFieldNames();
            this.hiveFieldTypeInfos = ((StructTypeInfo)hiveTypeInfo).getAllStructFieldTypeInfos();
        }
        List<Type> selectedFields = selectedGroupType.getFields();
        for (int i = 0; i < selectedFieldCount; ++i) {
            Type subtype = selectedFields.get(i);
            if (!this.isSubType(containingGroupType, subtype)) {
                throw new IllegalStateException("Group type [" + containingGroupType + "] does not contain requested field: " + subtype);
            }
            int fieldIndex = containingGroupType.getFieldIndex(subtype.getName());
            TypeInfo _hiveTypeInfo = this.getFieldTypeIgnoreCase(hiveTypeInfo, subtype.getName(), fieldIndex);
            this.converters[i] = this.getFieldConverter(subtype, fieldIndex, _hiveTypeInfo);
        }
    }

    private boolean isSubType(GroupType groupType, Type subtype) {
        if (subtype.isPrimitive() || subtype.isRepetition(Type.Repetition.REPEATED)) {
            return groupType.getFields().contains(subtype);
        }
        for (Type g : groupType.getFields()) {
            if (g.isPrimitive() || !g.getName().equals(subtype.getName())) continue;
            boolean containsAll = false;
            for (Type subSubType : subtype.asGroupType().getFields()) {
                containsAll = this.isSubType(g.asGroupType(), subSubType);
                if (containsAll) continue;
                break;
            }
            if (!containsAll) continue;
            return containsAll;
        }
        return false;
    }

    private TypeInfo getFieldTypeIgnoreCase(TypeInfo hiveTypeInfo, String fieldName, int fieldIndex) {
        if (hiveTypeInfo == null) {
            return null;
        }
        if (hiveTypeInfo.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            return this.getStructFieldTypeInfo(fieldName, fieldIndex);
        }
        if (hiveTypeInfo.getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            if (fieldIndex == 0) {
                return ((MapTypeInfo)hiveTypeInfo).getMapKeyTypeInfo();
            }
            if (fieldIndex == 1) {
                return ((MapTypeInfo)hiveTypeInfo).getMapValueTypeInfo();
            }
            return null;
        }
        throw new RuntimeException("Unknown hive type info " + hiveTypeInfo + " when searching for field " + fieldName);
    }

    private TypeInfo getStructFieldTypeInfo(String field, int fieldIndex) {
        String fieldLowerCase = field.toLowerCase();
        if (Boolean.parseBoolean(this.getMetadata().get("parquet.column.index.access")) && fieldIndex < this.hiveFieldNames.size()) {
            return this.hiveFieldTypeInfos.get(fieldIndex);
        }
        for (int i = 0; i < this.hiveFieldNames.size(); ++i) {
            if (!fieldLowerCase.equalsIgnoreCase(this.hiveFieldNames.get(i))) continue;
            return this.hiveFieldTypeInfos.get(i);
        }
        return null;
    }

    private Converter getFieldConverter(Type type, int fieldIndex, TypeInfo hiveTypeInfo) {
        Converter converter;
        if (type.isRepetition(Type.Repetition.REPEATED)) {
            converter = type.isPrimitive() ? new Repeated.RepeatedPrimitiveConverter(type.asPrimitiveType(), this, fieldIndex, hiveTypeInfo) : new Repeated.RepeatedGroupConverter(type.asGroupType(), this, fieldIndex, hiveTypeInfo == null ? null : ((ListTypeInfo)hiveTypeInfo).getListElementTypeInfo());
            this.repeatedConverters.add((Repeated)((Object)converter));
        } else {
            converter = HiveStructConverter.getConverterFromDescription(type, fieldIndex, (ConverterParent)this, hiveTypeInfo);
        }
        return converter;
    }

    public final ArrayWritable getCurrentArray() {
        return new ArrayWritable(Writable.class, this.writables);
    }

    @Override
    public void set(int fieldIndex, Writable value) {
        this.writables[fieldIndex] = value;
    }

    @Override
    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    @Override
    public void start() {
        if (this.reuseWritableArray) {
            for (int i = 0; i < this.writables.length; ++i) {
                this.writables[i] = null;
            }
        } else {
            this.writables = new Writable[this.totalFieldCount];
        }
        for (Repeated repeated : this.repeatedConverters) {
            repeated.parentStart();
        }
    }

    @Override
    public void end() {
        for (Repeated repeated : this.repeatedConverters) {
            repeated.parentEnd();
        }
        if (this.parent != null) {
            this.parent.set(this.index, (Writable)this.getCurrentArray());
        }
    }
}

