/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.format.event;

import hive.org.apache.parquet.format.event.DelegatingListElementsConsumer;
import hive.org.apache.parquet.format.event.EventBasedThriftReader;
import hive.org.apache.parquet.format.event.FieldConsumer;
import hive.org.apache.parquet.format.event.SkippingFieldConsumer;
import hive.org.apache.parquet.format.event.TBaseStructConsumer;
import hive.org.apache.parquet.format.event.TypedConsumer;
import hive.shaded.parquet.org.apache.thrift.TBase;
import hive.shaded.parquet.org.apache.thrift.TException;
import hive.shaded.parquet.org.apache.thrift.TFieldIdEnum;
import hive.shaded.parquet.org.apache.thrift.protocol.TList;
import hive.shaded.parquet.org.apache.thrift.protocol.TProtocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Consumers {
    public static DelegatingFieldConsumer fieldConsumer() {
        return new DelegatingFieldConsumer();
    }

    public static <T extends TBase<T, ? extends TFieldIdEnum>> TypedConsumer.ListConsumer listOf(Class<T> c, final Consumer<List<T>> consumer) {
        class ListConsumer
        implements Consumer<T> {
            List<T> list;

            ListConsumer() {
            }

            @Override
            public void consume(T t) {
                this.list.add(t);
            }
        }
        final ListConsumer co = new ListConsumer();
        return new DelegatingListElementsConsumer(Consumers.struct(c, co)){
            {
                super(consumer3);
            }

            @Override
            public void consumeList(TProtocol protocol, EventBasedThriftReader reader, TList tList) throws TException {
                co.list = new ArrayList();
                super.consumeList(protocol, reader, tList);
                consumer.consume(co.list);
            }
        };
    }

    public static TypedConsumer.ListConsumer listElementsOf(TypedConsumer consumer) {
        return new DelegatingListElementsConsumer(consumer);
    }

    public static <T extends TBase<T, ? extends TFieldIdEnum>> TypedConsumer.StructConsumer struct(Class<T> c, Consumer<T> consumer) {
        return new TBaseStructConsumer<T>(c, consumer);
    }

    public static class DelegatingFieldConsumer
    implements FieldConsumer {
        private final Map<Short, TypedConsumer> contexts;
        private final FieldConsumer defaultFieldEventConsumer;

        private DelegatingFieldConsumer(FieldConsumer defaultFieldEventConsumer, Map<Short, TypedConsumer> contexts) {
            this.defaultFieldEventConsumer = defaultFieldEventConsumer;
            this.contexts = Collections.unmodifiableMap(contexts);
        }

        private DelegatingFieldConsumer() {
            this(new SkippingFieldConsumer());
        }

        private DelegatingFieldConsumer(FieldConsumer defaultFieldEventConsumer) {
            this(defaultFieldEventConsumer, Collections.emptyMap());
        }

        public DelegatingFieldConsumer onField(TFieldIdEnum e, TypedConsumer typedConsumer) {
            HashMap<Short, TypedConsumer> newContexts = new HashMap<Short, TypedConsumer>(this.contexts);
            newContexts.put(e.getThriftFieldId(), typedConsumer);
            return new DelegatingFieldConsumer(this.defaultFieldEventConsumer, newContexts);
        }

        @Override
        public void consumeField(TProtocol protocol, EventBasedThriftReader reader, short id, byte type) throws TException {
            TypedConsumer delegate = this.contexts.get(id);
            if (delegate != null) {
                delegate.read(protocol, reader, type);
            } else {
                this.defaultFieldEventConsumer.consumeField(protocol, reader, id, type);
            }
        }
    }

    public static interface Consumer<T> {
        public void consume(T var1);
    }
}

