/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.impl;

import hive.org.apache.parquet.bytes.BytesInput;
import hive.org.apache.parquet.column.ColumnDescriptor;
import hive.org.apache.parquet.column.ParquetProperties;
import hive.org.apache.parquet.column.impl.ColumnWriterBase;
import hive.org.apache.parquet.column.page.PageWriter;
import hive.org.apache.parquet.column.statistics.Statistics;
import hive.org.apache.parquet.column.values.ValuesWriter;
import java.io.IOException;

final class ColumnWriterV1
extends ColumnWriterBase {
    ColumnWriterV1(ColumnDescriptor path, PageWriter pageWriter, ParquetProperties props) {
        super(path, pageWriter, props);
    }

    @Override
    ValuesWriter createRLWriter(ParquetProperties props, ColumnDescriptor path) {
        return props.newRepetitionLevelWriter(path);
    }

    @Override
    ValuesWriter createDLWriter(ParquetProperties props, ColumnDescriptor path) {
        return props.newDefinitionLevelWriter(path);
    }

    @Override
    void writePage(int rowCount, int valueCount, Statistics<?> statistics, ValuesWriter repetitionLevels, ValuesWriter definitionLevels, ValuesWriter values) throws IOException {
        this.pageWriter.writePage(BytesInput.concat(repetitionLevels.getBytes(), definitionLevels.getBytes(), values.getBytes()), valueCount, rowCount, statistics, repetitionLevels.getEncoding(), definitionLevels.getEncoding(), values.getEncoding());
    }
}

