/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.mapreduce;

import hive.org.apache.avro.Schema;
import hive.org.apache.avro.file.CodecFactory;
import hive.org.apache.avro.generic.GenericData;
import hive.org.apache.avro.hadoop.io.AvroSerialization;
import hive.org.apache.avro.mapred.AvroKey;
import hive.org.apache.avro.mapreduce.AvroJob;
import hive.org.apache.avro.mapreduce.AvroKeyRecordWriter;
import hive.org.apache.avro.mapreduce.AvroOutputFormatBase;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class AvroKeyOutputFormat<T>
extends AvroOutputFormatBase<AvroKey<T>, NullWritable> {
    private final RecordWriterFactory mRecordWriterFactory;

    public AvroKeyOutputFormat() {
        this(new RecordWriterFactory());
    }

    protected AvroKeyOutputFormat(RecordWriterFactory recordWriterFactory) {
        this.mRecordWriterFactory = recordWriterFactory;
    }

    public RecordWriter<AvroKey<T>, NullWritable> getRecordWriter(TaskAttemptContext context) throws IOException {
        Schema mapOutputSchema;
        boolean isMapOnly;
        Configuration conf = context.getConfiguration();
        Schema writerSchema = AvroJob.getOutputKeySchema(conf);
        boolean bl = isMapOnly = context.getNumReduceTasks() == 0;
        if (isMapOnly && (mapOutputSchema = AvroJob.getMapOutputKeySchema(conf)) != null) {
            writerSchema = mapOutputSchema;
        }
        if (null == writerSchema) {
            throw new IOException("AvroKeyOutputFormat requires an output schema. Use AvroJob.setOutputKeySchema().");
        }
        GenericData dataModel = AvroSerialization.createDataModel(conf);
        OutputStream out = this.getAvroFileOutputStream(context);
        try {
            return this.mRecordWriterFactory.create(writerSchema, dataModel, AvroKeyOutputFormat.getCompressionCodec(context), out, AvroKeyOutputFormat.getSyncInterval(context));
        }
        catch (IOException e) {
            out.close();
            throw e;
        }
    }

    protected static class RecordWriterFactory<T> {
        protected RecordWriterFactory() {
        }

        protected RecordWriter<AvroKey<T>, NullWritable> create(Schema writerSchema, GenericData dataModel, CodecFactory compressionCodec, OutputStream outputStream, int syncInterval) throws IOException {
            return new AvroKeyRecordWriter(writerSchema, dataModel, compressionCodec, outputStream, syncInterval);
        }
    }
}

