/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kudu;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal28DenseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38DenseHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.store.AbstractRecordWriter;
import org.apache.drill.exec.store.EventBasedRecordWriter;
import org.apache.drill.exec.store.RecordWriter;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.kudu.client.PartialRow;

public abstract class KuduRecordWriter
extends AbstractRecordWriter
implements RecordWriter {
    private PartialRow row;

    public void setUp(PartialRow row) {
        this.row = row;
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableIntKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new IntKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableFloat4KuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
        return new Float4KuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableBigIntKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new BigIntKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableUInt8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableUInt8KuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewUInt8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new UInt8KuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableFloat8KuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new Float8KuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableTimeStampKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
        return new TimeStampKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableDecimal28DenseKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new Decimal28DenseKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableDecimal38DenseKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new Decimal38DenseKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableVarBinaryKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
        return new VarBinaryKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableVarCharKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new VarCharKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableVar16CharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableVar16CharKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewVar16CharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new Var16CharKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableVarDecimalKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewVarDecimalConverter(int fieldId, String fieldName, FieldReader reader) {
        return new VarDecimalKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewNullableBitConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableBitKuduConverter(fieldId, fieldName, reader);
    }

    public EventBasedRecordWriter.FieldConverter getNewBitConverter(int fieldId, String fieldName, FieldReader reader) {
        return new BitKuduConverter(fieldId, fieldName, reader);
    }

    public class BitKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableBitHolder holder;

        public BitKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableBitHolder();
        }

        public void writeField() throws IOException {
            this.reader.read(this.holder);
            KuduRecordWriter.this.row.addBoolean(this.fieldId, this.holder.value == 1);
        }
    }

    public class NullableBitKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableBitHolder holder;

        public NullableBitKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableBitHolder();
        }

        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            KuduRecordWriter.this.row.addBoolean(this.fieldId, this.holder.value == 1);
        }
    }

    public class VarDecimalKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVarDecimalHolder holder;

        public VarDecimalKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarDecimalHolder();
        }

        public void writeField() throws IOException {
            this.reader.read(this.holder);
            throw new UnsupportedOperationException();
        }
    }

    public class NullableVarDecimalKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVarDecimalHolder holder;

        public NullableVarDecimalKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarDecimalHolder();
        }

        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            throw new UnsupportedOperationException();
        }
    }

    public class Var16CharKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVar16CharHolder holder;

        public Var16CharKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVar16CharHolder();
        }

        public void writeField() throws IOException {
            this.reader.read(this.holder);
            throw new UnsupportedOperationException();
        }
    }

    public class NullableVar16CharKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVar16CharHolder holder;

        public NullableVar16CharKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVar16CharHolder();
        }

        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            throw new UnsupportedOperationException();
        }
    }

    public class VarCharKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVarCharHolder holder;

        public VarCharKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarCharHolder();
        }

        public void writeField() throws IOException {
            this.reader.read(this.holder);
            byte[] bytes = new byte[this.holder.end - this.holder.start];
            this.holder.buffer.getBytes(this.holder.start, bytes);
            KuduRecordWriter.this.row.addString(this.fieldId, new String(bytes, StandardCharsets.UTF_8));
        }
    }

    public class NullableVarCharKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVarCharHolder holder;

        public NullableVarCharKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarCharHolder();
        }

        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            byte[] bytes = new byte[this.holder.end - this.holder.start];
            this.holder.buffer.getBytes(this.holder.start, bytes);
            KuduRecordWriter.this.row.addString(this.fieldId, new String(bytes, StandardCharsets.UTF_8));
        }
    }

    public class VarBinaryKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVarBinaryHolder holder;

        public VarBinaryKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarBinaryHolder();
        }

        public void writeField() throws IOException {
            this.reader.read(this.holder);
            byte[] bytes = new byte[this.holder.end - this.holder.start];
            this.holder.buffer.getBytes(this.holder.start, bytes);
            KuduRecordWriter.this.row.addBinary(this.fieldId, bytes);
            this.reader.read(this.holder);
        }
    }

    public class NullableVarBinaryKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVarBinaryHolder holder;

        public NullableVarBinaryKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarBinaryHolder();
        }

        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            byte[] bytes = new byte[this.holder.end - this.holder.start];
            this.holder.buffer.getBytes(this.holder.start, bytes);
            KuduRecordWriter.this.row.addBinary(this.fieldId, bytes);
            this.reader.read(this.holder);
        }
    }

    public class Decimal38DenseKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal38DenseHolder holder;

        public Decimal38DenseKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal38DenseHolder();
        }

        public void writeField() throws IOException {
            this.reader.read(this.holder);
            throw new UnsupportedOperationException();
        }
    }

    public class NullableDecimal38DenseKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal38DenseHolder holder;

        public NullableDecimal38DenseKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal38DenseHolder();
        }

        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            throw new UnsupportedOperationException();
        }
    }

    public class Decimal28DenseKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal28DenseHolder holder;

        public Decimal28DenseKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal28DenseHolder();
        }

        public void writeField() throws IOException {
            this.reader.read(this.holder);
            throw new UnsupportedOperationException();
        }
    }

    public class NullableDecimal28DenseKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal28DenseHolder holder;

        public NullableDecimal28DenseKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal28DenseHolder();
        }

        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            throw new UnsupportedOperationException();
        }
    }

    public class TimeStampKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableTimeStampHolder holder;

        public TimeStampKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableTimeStampHolder();
        }

        public void writeField() throws IOException {
            this.reader.read(this.holder);
            KuduRecordWriter.this.row.addLong(this.fieldId, this.holder.value * 1000L);
        }
    }

    public class NullableTimeStampKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableTimeStampHolder holder;

        public NullableTimeStampKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableTimeStampHolder();
        }

        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            KuduRecordWriter.this.row.addLong(this.fieldId, this.holder.value * 1000L);
        }
    }

    public class Float8KuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableFloat8Holder holder;

        public Float8KuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableFloat8Holder();
        }

        public void writeField() throws IOException {
            this.reader.read(this.holder);
            KuduRecordWriter.this.row.addDouble(this.fieldId, this.holder.value);
        }
    }

    public class NullableFloat8KuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableFloat8Holder holder;

        public NullableFloat8KuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableFloat8Holder();
        }

        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            KuduRecordWriter.this.row.addDouble(this.fieldId, this.holder.value);
        }
    }

    public class UInt8KuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableUInt8Holder holder;

        public UInt8KuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt8Holder();
        }

        public void writeField() throws IOException {
            this.reader.read(this.holder);
            throw new UnsupportedOperationException();
        }
    }

    public class NullableUInt8KuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableUInt8Holder holder;

        public NullableUInt8KuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt8Holder();
        }

        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            throw new UnsupportedOperationException();
        }
    }

    public class BigIntKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableBigIntHolder holder;

        public BigIntKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableBigIntHolder();
        }

        public void writeField() throws IOException {
            this.reader.read(this.holder);
            KuduRecordWriter.this.row.addLong(this.fieldId, this.holder.value);
        }
    }

    public class NullableBigIntKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableBigIntHolder holder;

        public NullableBigIntKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableBigIntHolder();
        }

        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            KuduRecordWriter.this.row.addLong(this.fieldId, this.holder.value);
        }
    }

    public class Float4KuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableFloat4Holder holder;

        public Float4KuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableFloat4Holder();
        }

        public void writeField() throws IOException {
            this.reader.read(this.holder);
            KuduRecordWriter.this.row.addFloat(this.fieldId, this.holder.value);
        }
    }

    public class NullableFloat4KuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableFloat4Holder holder;

        public NullableFloat4KuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableFloat4Holder();
        }

        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            KuduRecordWriter.this.row.addFloat(this.fieldId, this.holder.value);
        }
    }

    public class IntKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableIntHolder holder;

        public IntKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntHolder();
        }

        public void writeField() throws IOException {
            this.reader.read(this.holder);
            KuduRecordWriter.this.row.addInt(this.fieldId, this.holder.value);
        }
    }

    public class NullableIntKuduConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableIntHolder holder;

        public NullableIntKuduConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntHolder();
        }

        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            KuduRecordWriter.this.row.addInt(this.fieldId, this.holder.value);
        }
    }
}

