/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.orc.OrcBatchReader;
import org.apache.iceberg.orc.OrcFileAppender;
import org.apache.iceberg.orc.OrcIterable;
import org.apache.iceberg.orc.OrcRowReader;
import org.apache.iceberg.orc.OrcRowWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;

public class ORC {
    private static final String VECTOR_ROW_BATCH_SIZE = "iceberg.orc.vectorbatch.size";

    private ORC() {
    }

    public static WriteBuilder write(OutputFile file) {
        return new WriteBuilder(file);
    }

    public static DataWriteBuilder writeData(OutputFile file) {
        return new DataWriteBuilder(file);
    }

    public static ReadBuilder read(InputFile file) {
        return new ReadBuilder(file);
    }

    static Reader newFileReader(String location, OrcFile.ReaderOptions readerOptions) {
        try {
            return OrcFile.createReader((Path)new Path(location), (OrcFile.ReaderOptions)readerOptions);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to open file: %s", new Object[]{location});
        }
    }

    static Reader newFileReader(InputFile file, Configuration config) {
        OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)config).useUTCTimestamp(true);
        if (file instanceof HadoopInputFile) {
            readerOptions.filesystem(((HadoopInputFile)file).getFileSystem());
        }
        return ORC.newFileReader(file.location(), readerOptions);
    }

    public static class ReadBuilder {
        private final InputFile file;
        private final Configuration conf;
        private Schema schema = null;
        private Long start = null;
        private Long length = null;
        private Expression filter = null;
        private boolean caseSensitive = true;
        private NameMapping nameMapping = null;
        private Function<TypeDescription, OrcRowReader<?>> readerFunc;
        private Function<TypeDescription, OrcBatchReader<?>> batchedReaderFunc;
        private int recordsPerBatch = 1024;

        private ReadBuilder(InputFile file) {
            Preconditions.checkNotNull((Object)file, (Object)"Input file cannot be null");
            this.file = file;
            this.conf = file instanceof HadoopInputFile ? new Configuration(((HadoopInputFile)file).getConf()) : new Configuration();
            this.conf.setBoolean(OrcConf.FORCE_POSITIONAL_EVOLUTION.getHiveConfName(), false);
        }

        public ReadBuilder split(long newStart, long newLength) {
            this.start = newStart;
            this.length = newLength;
            return this;
        }

        public ReadBuilder project(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public ReadBuilder caseSensitive(boolean newCaseSensitive) {
            OrcConf.IS_SCHEMA_EVOLUTION_CASE_SENSITIVE.setBoolean(this.conf, newCaseSensitive);
            this.caseSensitive = newCaseSensitive;
            return this;
        }

        public ReadBuilder config(String property, String value) {
            this.conf.set(property, value);
            return this;
        }

        public ReadBuilder createReaderFunc(Function<TypeDescription, OrcRowReader<?>> readerFunction) {
            Preconditions.checkArgument((this.batchedReaderFunc == null ? 1 : 0) != 0, (Object)"Reader function cannot be set since the batched version is already set");
            this.readerFunc = readerFunction;
            return this;
        }

        public ReadBuilder filter(Expression newFilter) {
            this.filter = newFilter;
            return this;
        }

        public ReadBuilder createBatchedReaderFunc(Function<TypeDescription, OrcBatchReader<?>> batchReaderFunction) {
            Preconditions.checkArgument((this.readerFunc == null ? 1 : 0) != 0, (Object)"Batched reader function cannot be set since the non-batched version is already set");
            this.batchedReaderFunc = batchReaderFunction;
            return this;
        }

        public ReadBuilder recordsPerBatch(int numRecordsPerBatch) {
            this.recordsPerBatch = numRecordsPerBatch;
            return this;
        }

        public ReadBuilder withNameMapping(NameMapping newNameMapping) {
            this.nameMapping = newNameMapping;
            return this;
        }

        public <D> CloseableIterable<D> build() {
            Preconditions.checkNotNull((Object)this.schema, (Object)"Schema is required");
            return new OrcIterable(this.file, this.conf, this.schema, this.nameMapping, this.start, this.length, this.readerFunc, this.caseSensitive, this.filter, this.batchedReaderFunc, this.recordsPerBatch);
        }
    }

    public static class DataWriteBuilder {
        private final WriteBuilder appenderBuilder;
        private final String location;
        private PartitionSpec spec = null;
        private StructLike partition = null;
        private EncryptionKeyMetadata keyMetadata = null;
        private SortOrder sortOrder = null;

        private DataWriteBuilder(OutputFile file) {
            this.appenderBuilder = ORC.write(file);
            this.location = file.location();
        }

        public DataWriteBuilder forTable(Table table) {
            this.schema(table.schema());
            this.withSpec(table.spec());
            this.setAll(table.properties());
            this.metricsConfig(MetricsConfig.fromProperties((Map)table.properties()));
            return this;
        }

        public DataWriteBuilder schema(Schema newSchema) {
            this.appenderBuilder.schema(newSchema);
            return this;
        }

        public DataWriteBuilder set(String property, String value) {
            this.appenderBuilder.config(property, value);
            return this;
        }

        public DataWriteBuilder setAll(Map<String, String> properties) {
            this.appenderBuilder.setAll(properties);
            return this;
        }

        public DataWriteBuilder meta(String property, String value) {
            this.appenderBuilder.metadata(property, value);
            return this;
        }

        public DataWriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public DataWriteBuilder overwrite(boolean enabled) {
            this.appenderBuilder.overwrite(enabled);
            return this;
        }

        public DataWriteBuilder metricsConfig(MetricsConfig newMetricsConfig) {
            this.appenderBuilder.metricsConfig(newMetricsConfig);
            return this;
        }

        public DataWriteBuilder createWriterFunc(BiFunction<Schema, TypeDescription, OrcRowWriter<?>> writerFunction) {
            this.appenderBuilder.createWriterFunc(writerFunction);
            return this;
        }

        public DataWriteBuilder withSpec(PartitionSpec newSpec) {
            this.spec = newSpec;
            return this;
        }

        public DataWriteBuilder withPartition(StructLike newPartition) {
            this.partition = newPartition;
            return this;
        }

        public DataWriteBuilder withKeyMetadata(EncryptionKeyMetadata metadata) {
            this.keyMetadata = metadata;
            return this;
        }

        public DataWriteBuilder withSortOrder(SortOrder newSortOrder) {
            this.sortOrder = newSortOrder;
            return this;
        }

        public <T> DataWriter<T> build() {
            Preconditions.checkArgument((this.spec != null ? 1 : 0) != 0, (Object)"Cannot create data writer without spec");
            Preconditions.checkArgument((this.spec.isUnpartitioned() || this.partition != null ? 1 : 0) != 0, (Object)"Partition must not be null when creating data writer for partitioned spec");
            FileAppender fileAppender = this.appenderBuilder.build();
            return new DataWriter(fileAppender, FileFormat.ORC, this.location, this.spec, this.partition, this.keyMetadata, this.sortOrder);
        }
    }

    public static class WriteBuilder {
        private final OutputFile file;
        private final Configuration conf;
        private Schema schema = null;
        private BiFunction<Schema, TypeDescription, OrcRowWriter<?>> createWriterFunc;
        private Map<String, byte[]> metadata = new HashMap<String, byte[]>();
        private MetricsConfig metricsConfig;

        private WriteBuilder(OutputFile file) {
            this.file = file;
            this.conf = file instanceof HadoopOutputFile ? new Configuration(((HadoopOutputFile)file).getConf()) : new Configuration();
        }

        public WriteBuilder metadata(String property, String value) {
            this.metadata.put(property, value.getBytes(StandardCharsets.UTF_8));
            return this;
        }

        public WriteBuilder config(String property, String value) {
            this.conf.set(property, value);
            return this;
        }

        public WriteBuilder createWriterFunc(BiFunction<Schema, TypeDescription, OrcRowWriter<?>> writerFunction) {
            this.createWriterFunc = writerFunction;
            return this;
        }

        public WriteBuilder setAll(Map<String, String> properties) {
            properties.forEach((arg_0, arg_1) -> ((Configuration)this.conf).set(arg_0, arg_1));
            return this;
        }

        public WriteBuilder schema(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public WriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public WriteBuilder overwrite(boolean enabled) {
            OrcConf.OVERWRITE_OUTPUT_FILE.setBoolean(this.conf, enabled);
            return this;
        }

        public WriteBuilder metricsConfig(MetricsConfig newMetricsConfig) {
            this.metricsConfig = newMetricsConfig;
            return this;
        }

        public <D> FileAppender<D> build() {
            Preconditions.checkNotNull((Object)this.schema, (Object)"Schema is required");
            return new OrcFileAppender(this.schema, this.file, this.createWriterFunc, this.conf, this.metadata, this.conf.getInt(ORC.VECTOR_ROW_BATCH_SIZE, 1024), this.metricsConfig);
        }
    }
}

