/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula.writers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import technology.tabula.RectangularTextContainer;
import technology.tabula.Table;
import technology.tabula.writers.Writer;

public class CSVWriter
implements Writer {
    private final CSVFormat format;

    public CSVWriter() {
        this(CSVFormat.EXCEL);
    }

    protected CSVWriter(CSVFormat format) {
        this.format = format;
    }

    @Override
    public void write(Appendable out, Table table) throws IOException {
        this.write(out, Collections.singletonList(table));
    }

    @Override
    public void write(Appendable out, List<Table> tables) throws IOException {
        try (CSVPrinter printer = new CSVPrinter(out, this.format);){
            for (Table table : tables) {
                for (List<RectangularTextContainer> row : table.getRows()) {
                    ArrayList<String> cells = new ArrayList<String>(row.size());
                    for (RectangularTextContainer cell : row) {
                        cells.add(cell.getText());
                    }
                    printer.printRecord(cells);
                }
            }
            printer.flush();
        }
    }
}

