/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.metastore.Metastore;
import org.apache.drill.metastore.components.tables.Tables;
import org.apache.drill.metastore.components.views.Views;
import org.apache.drill.metastore.iceberg.components.tables.IcebergTables;
import org.apache.drill.metastore.iceberg.exceptions.IcebergMetastoreException;
import org.apache.drill.metastore.iceberg.schema.IcebergTableSchema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Table;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopTables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergMetastore
implements Metastore {
    private static final Logger logger = LoggerFactory.getLogger(IcebergMetastore.class);
    private final DrillConfig config;
    private final org.apache.iceberg.Tables tables;
    private final String baseLocation;
    private final Map<String, String> commonProperties;
    private final Map<Class<?>, Boolean> loadStatusMap = new ConcurrentHashMap();

    public IcebergMetastore(DrillConfig config) {
        this.config = config;
        Configuration configuration = this.configuration();
        this.tables = new HadoopTables(new Configuration(configuration));
        this.baseLocation = this.baseLocation(new Configuration(configuration));
        this.commonProperties = this.properties("drill.metastore.iceberg.components.common.properties");
    }

    public Tables tables() {
        Table table = this.loadTable("drill.metastore.iceberg.components.tables.location", "drill.metastore.iceberg.components.tables.properties", IcebergTables.SCHEMA, Tables.class);
        return new IcebergTables(table);
    }

    public Views views() {
        throw new UnsupportedOperationException("Views metadata support is not implemented");
    }

    private Configuration configuration() {
        Configuration configuration = new Configuration();
        if (this.config.hasPath("drill.metastore.iceberg.config.properties")) {
            Config configProperties = this.config.getConfig("drill.metastore.iceberg.config.properties");
            configProperties.entrySet().forEach(entry -> configuration.set((String)entry.getKey(), String.valueOf(((ConfigValue)entry.getValue()).unwrapped())));
        }
        return configuration;
    }

    private String baseLocation(Configuration configuration) {
        String relativeLocation;
        FileSystem fs;
        try {
            fs = FileSystem.get((Configuration)configuration);
        }
        catch (IOException e) {
            throw new IcebergMetastoreException(String.format("Error during file system [%s] setup", configuration.get("fs.defaultFS")));
        }
        String root = fs.getHomeDirectory().toUri().getPath();
        if (this.config.hasPath("drill.metastore.iceberg.location.base_path")) {
            root = this.config.getString("drill.metastore.iceberg.location.base_path");
        }
        if ((relativeLocation = this.config.getString("drill.metastore.iceberg.location.relative_path")) == null) {
            throw new IcebergMetastoreException(String.format("Iceberg Metastore relative path [%s] is not provided", "drill.metastore.iceberg.location.relative_path"));
        }
        String location = new Path(root, relativeLocation).toUri().getPath();
        logger.info("Iceberg Metastore is located in [{}] on file system [{}]", (Object)location, (Object)fs.getUri());
        return location;
    }

    private Map<String, String> properties(String propertiesPath) {
        return this.config.hasPath(propertiesPath) ? this.config.getConfig(propertiesPath).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.valueOf(((ConfigValue)entry.getValue()).unwrapped()), (o, n) -> n)) : Collections.emptyMap();
    }

    private Table loadTable(String componentLocationConfig, String componentPropertiesConfig, IcebergTableSchema schema, Class<?> loadClass) {
        Table table;
        String location = this.tableLocation(componentLocationConfig);
        Map<String, String> tableProperties = this.tableProperties(componentPropertiesConfig);
        try {
            table = this.tables.load(location);
        }
        catch (NoSuchTableException e) {
            try {
                return this.tables.create(schema.tableSchema(), schema.partitionSpec(), tableProperties, location);
            }
            catch (AlreadyExistsException ex) {
                table = this.tables.load(location);
            }
        }
        if (this.loadStatusMap.putIfAbsent(loadClass, Boolean.TRUE) == null) {
            this.updateTableProperties(table, tableProperties);
        }
        return table;
    }

    private String tableLocation(String componentLocationConfig) {
        if (!this.config.hasPath(componentLocationConfig)) {
            throw new IcebergMetastoreException(String.format("Component location config [%s] is not defined", componentLocationConfig));
        }
        String componentLocation = this.config.getString(componentLocationConfig);
        return new Path(this.baseLocation, componentLocation).toUri().getPath();
    }

    private Map<String, String> tableProperties(String componentPropertiesConfig) {
        HashMap<String, String> properties = new HashMap<String, String>(this.commonProperties);
        properties.putAll(this.properties(componentPropertiesConfig));
        return properties;
    }

    private void updateTableProperties(Table table, Map<String, String> tableProperties) {
        Map currentProperties = table.properties();
        MapDifference difference = Maps.difference(tableProperties, (Map)currentProperties);
        if (difference.areEqual()) {
            return;
        }
        UpdateProperties updateProperties = table.updateProperties();
        Map<String, String> propertiesToUpdate = difference.entriesDiffering().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((MapDifference.ValueDifference)entry.getValue()).leftValue(), (o, n) -> n));
        propertiesToUpdate.putAll(difference.entriesOnlyOnLeft());
        logger.debug("Updating Iceberg table [{}] properties: {}", (Object)table.location(), (Object)updateProperties);
        propertiesToUpdate.forEach((arg_0, arg_1) -> ((UpdateProperties)updateProperties).set(arg_0, arg_1));
        logger.debug("Removing Iceberg table [{}] properties: {}", (Object)table.location(), (Object)difference.entriesOnlyOnRight());
        difference.entriesOnlyOnRight().keySet().forEach(arg_0 -> ((UpdateProperties)updateProperties).remove(arg_0));
        updateProperties.commit();
    }

    public void close() {
    }
}

