/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseShims {
    public static void setKeyValueSequenceId(KeyValue kv, int sequenceId) {
        kv.setSequenceId((long)sequenceId);
    }

    public static Region getRegionCoprocessorRegion(RegionCoprocessorEnvironment env) {
        return env.getRegion();
    }

    public static void flushAllOnlineRegions(HRegionServer regionServer, TableName tableName) throws IOException {
        for (HRegion r : regionServer.getRegions(tableName)) {
            r.flush(true);
        }
    }

    public static void addFamilyToHTableDescriptor(HTableDescriptor tableDesc, HColumnDescriptor columnDesc) {
        tableDesc.addFamily(columnDesc);
    }

    public static CellComparator cellComparatorInstance() {
        return CellComparatorImpl.COMPARATOR;
    }

    public static boolean OmidCompactionEnabled(ObserverContext<RegionCoprocessorEnvironment> env, Store store, String cfFlagValue) {
        TableDescriptor desc = ((RegionCoprocessorEnvironment)env.getEnvironment()).getRegion().getTableDescriptor();
        ColumnFamilyDescriptor famDesc = desc.getColumnFamily(Bytes.toBytes((String)store.getColumnFamilyName()));
        return Boolean.valueOf(Bytes.toString((byte[])famDesc.getValue(Bytes.toBytes((String)cfFlagValue))));
    }

    public static void setCompaction(Connection conn, TableName table, byte[] columnFamily, String key, String value) throws IOException {
        try (Admin admin = conn.getAdmin();){
            TableDescriptor desc = admin.getDescriptor(table);
            ColumnFamilyDescriptor cfDesc = desc.getColumnFamily(columnFamily);
            ColumnFamilyDescriptorBuilder cfBuilder = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)cfDesc);
            cfBuilder.setValue(Bytes.toBytes((String)key), Bytes.toBytes((String)value));
            admin.modifyColumnFamily(table, cfBuilder.build());
        }
    }

    public static int getNoRetriesNumber() {
        return 1;
    }

    public static Connection newServerConnection(Configuration config, RegionCoprocessorEnvironment env) throws IOException {
        return env.createConnection(config);
    }
}

