/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.cassandra.CassandraTable;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface CassandraRel
extends RelNode {
    public static final Convention CONVENTION = new Convention.Impl("CASSANDRA", CassandraRel.class);

    public void implement(Implementor var1);

    public static class Implementor {
        final Map<String, String> selectFields = new LinkedHashMap<String, String>();
        final List<String> whereClause = new ArrayList<String>();
        int offset = 0;
        int fetch = -1;
        final List<String> order = new ArrayList<String>();
        @Nullable RelOptTable table;
        @Nullable CassandraTable cassandraTable;

        public void add(@Nullable Map<String, String> fields, @Nullable List<String> predicates) {
            if (fields != null) {
                this.selectFields.putAll(fields);
            }
            if (predicates != null) {
                this.whereClause.addAll(predicates);
            }
        }

        public void addOrder(List<String> newOrder) {
            this.order.addAll(newOrder);
        }

        public void visitChild(int ordinal, RelNode input) {
            assert (ordinal == 0);
            ((CassandraRel)input).implement(this);
        }
    }
}

