/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.rdbms;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.jooq.tools.jdbc.JDBCUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutorProvider
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutorProvider.class);
    private final HikariDataSource dataSource;
    private final SQLDialect dialect;

    public QueryExecutorProvider(HikariDataSource dataSource) {
        this.dataSource = dataSource;
        this.dialect = this.defineDialect();
    }

    public DSLContext executor() {
        return DSL.using((DataSource)this.dataSource, (SQLDialect)this.dialect);
    }

    @Override
    public void close() {
        this.dataSource.close();
    }

    private SQLDialect defineDialect() {
        SQLDialect dialect = SQLDialect.DEFAULT;
        try (Connection connection = this.dataSource.getConnection();){
            dialect = JDBCUtils.dialect((Connection)connection);
        }
        catch (SQLException e) {
            logger.debug("Unable to connect to data source in order to define SQL dialect: {}", (Object)e.getMessage(), (Object)e);
        }
        logger.info("RDBMS Metastore is configured to use {} SQL dialect", (Object)dialect);
        return dialect;
    }
}

