/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Optional;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.io.internal.AutoCloseableContentLengthVerifyingInputStream;
import com.oracle.bmc.io.internal.ContentLengthVerifyingInputStream;
import com.oracle.bmc.io.internal.WrappedResponseInputStream;
import com.oracle.bmc.model.BmcException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHelper.class);
    private static final ObjectReader STRING_READER = new ObjectMapper().readerFor(String.class);
    private static final int MAX_RESPONSE_BUFFER_BYTES = 4096;
    private static final String OPC_REQUEST_ID_HEADER = "opc-request-id";
    private static final Map<Integer, String> DEFAULT_ERROR_MESSAGES = new HashMap<Integer, String>();
    private static boolean SHOULD_AUTO_CLOSE_RESPONSE_INPUTSTREAM = true;

    public static void throwIfNotSuccessful(@NonNull Response response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Response response2 = response;
        synchronized (response2) {
            if (Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
                return;
            }
            if (response.getStatus() == Response.Status.NOT_MODIFIED.getStatusCode()) {
                return;
            }
            String opcRequestId = response.getHeaderString(OPC_REQUEST_ID_HEADER);
            if (!ResponseHelper.typeEqual(MediaType.APPLICATION_JSON_TYPE, response.getMediaType())) {
                String responseBody = "Cannot read response body!";
                try {
                    responseBody = (String)response.readEntity(String.class);
                }
                catch (ProcessingException e) {
                    LOG.warn("Unable to read response body", (Throwable)e);
                }
                try {
                    throw new BmcException(response.getStatus(), "Unknown", String.format("Unexpected Content-Type: %s instead of %s. Response body: %s", response.getMediaType(), MediaType.APPLICATION_JSON_TYPE, responseBody), opcRequestId);
                }
                catch (Throwable throwable) {
                    ResponseHelper.closeResponseSilently(response);
                    throw throwable;
                }
            }
            boolean isBuffered = false;
            try {
                ErrorCodeAndMessage errorCodeAndMessage;
                if (response.getLength() < 4096) {
                    try {
                        isBuffered = response.bufferEntity();
                    }
                    catch (IllegalStateException e) {
                        LOG.info("Unable to buffer response entity as the response has already been closed", (Throwable)e);
                    }
                }
                if ((errorCodeAndMessage = (ErrorCodeAndMessage)response.readEntity(ErrorCodeAndMessage.class)) == null) {
                    String message = DEFAULT_ERROR_MESSAGES.get(response.getStatus());
                    throw new BmcException(response.getStatus(), "Unknown", message != null ? message : "Detailed exception information not available", opcRequestId);
                }
                throw new BmcException(response.getStatus(), errorCodeAndMessage.getCode(), errorCodeAndMessage.getMessage(), opcRequestId);
            }
            catch (ProcessingException e) {
                String message = isBuffered ? "Unable to parse error response: " + (String)response.readEntity(String.class) : "Unable to parse error response.";
                int status = response.getStatus();
                ResponseHelper.closeResponseSilently(response);
                throw new BmcException(status, "Unknown", message, opcRequestId, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readWithoutEntity(@NonNull Response response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Response response2 = response;
        synchronized (response2) {
            ResponseHelper.closeResponseSilently(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readEntity(@NonNull Response response, GenericType<T> entityType) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Response response2 = response;
        synchronized (response2) {
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                response.bufferEntity();
                return (T)response.readEntity(entityType);
            }
            if (response.getStatus() == Response.Status.NOT_MODIFIED.getStatusCode()) {
                ResponseHelper.closeResponseSilently(response);
                return null;
            }
        }
        throw new IllegalStateException("Attempted to read entity from unsuccessful response, should have called throwIfNotSuccessful first");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readEntity(@NonNull Response response, Class<T> entityType) throws BmcException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Response response2 = response;
        synchronized (response2) {
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                if (entityType == InputStream.class) {
                    List contentType = (List)response.getHeaders().remove((Object)"Content-Type");
                    LOG.debug("Entity type is InputStream, ignoring contentType {} and processing as stream", (Object)contentType);
                    InputStream rawInputStream = (InputStream)response.readEntity(InputStream.class);
                    InputStream inputStream = new WrappedResponseInputStream(rawInputStream, response);
                    Optional<List<String>> contentLengthHeader = HeaderUtils.get((MultivaluedMap<String, String>)response.getStringHeaders(), "Content-Length");
                    if (contentLengthHeader.isPresent() && response.getHeaders().get((Object)"Content-Encoding") == null) {
                        long contentLength = HeaderUtils.toValue("Content-Length", (String)((List)contentLengthHeader.get()).get(0), Long.class);
                        if (SHOULD_AUTO_CLOSE_RESPONSE_INPUTSTREAM) {
                            if (ApacheUtils.isExtraStreamLogsEnabled()) {
                                LOG.warn("Wrapping response stream into auto closeable stream, to disable this, please use ResponseHelper.shouldAutoCloseResponseInputStream(false)");
                            }
                            inputStream = new AutoCloseableContentLengthVerifyingInputStream(inputStream, contentLength);
                        } else {
                            inputStream = new ContentLengthVerifyingInputStream(inputStream, contentLength);
                        }
                    }
                    T t = entityType.cast(inputStream);
                    return t;
                    finally {
                        if (contentType != null) {
                            response.getHeaders().addAll((Object)"Content-Type", contentType);
                        }
                    }
                }
                response.bufferEntity();
                Object entity = response.readEntity(entityType);
                Object entityAsJsonString = ResponseHelper.readResponseAsJsonString(entity, response, entityType);
                if (entityAsJsonString != null) {
                    return (T)entityAsJsonString;
                }
                return (T)entity;
            }
            if (response.getStatus() == Response.Status.NOT_MODIFIED.getStatusCode()) {
                ResponseHelper.closeResponseSilently(response);
                return null;
            }
            throw new IllegalStateException("Attempted to read entity from unsuccessful response, should have called throwIfNotSuccessful first");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeResponseSilently(Response response) {
        Response response2 = response;
        synchronized (response2) {
            try {
                response.close();
            }
            catch (Throwable t) {
                LOG.debug("Exception while closing response", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeResponseSilentlyIfNotBuffered(@NonNull Response response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Response response2 = response;
        synchronized (response2) {
            boolean isResponseAlreadyClosed = true;
            try {
                isResponseAlreadyClosed = response.bufferEntity();
            }
            catch (IllegalStateException ex) {
                LOG.trace("Exception while buffering the entity before closing the response", (Throwable)ex);
            }
            if (!isResponseAlreadyClosed) {
                ResponseHelper.closeResponseSilently(response);
            }
        }
    }

    private static boolean typeEqual(MediaType m1, MediaType m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        return m1.getSubtype().equalsIgnoreCase(m2.getSubtype()) && m1.getType().equalsIgnoreCase(m2.getType());
    }

    private static <T> T readResponseAsJsonString(T entity, Response response, Class<T> entityType) {
        String contentType = response.getHeaderString("Content-Type");
        if (contentType == null) {
            return null;
        }
        if (!"application/json".equalsIgnoreCase(contentType)) {
            return null;
        }
        if (entityType != String.class) {
            return null;
        }
        String stringEntity = (String)entity;
        if (stringEntity.startsWith("\"") && stringEntity.endsWith("\"")) {
            try {
                return entityType.cast(STRING_READER.readValue(stringEntity));
            }
            catch (IOException e) {
                LOG.error("Unable to extract string response", (Throwable)e);
            }
        }
        return null;
    }

    public static void shouldAutoCloseResponseInputStream(boolean shouldAutoClose) {
        LOG.info("Setting auto-close of response input stream to", (Object)shouldAutoClose);
        SHOULD_AUTO_CLOSE_RESPONSE_INPUTSTREAM = shouldAutoClose;
    }

    static {
        DEFAULT_ERROR_MESSAGES.put(Response.Status.NOT_FOUND.getStatusCode(), "The resource does not exist or the request was not authorized");
        DEFAULT_ERROR_MESSAGES.put(Response.Status.PRECONDITION_FAILED.getStatusCode(), "Precondition failed");
    }

    @JsonDeserialize(builder=Builder.class)
    public static final class ErrorCodeAndMessage {
        private final String code;
        private final String message;

        @ConstructorProperties(value={"code", "message"})
        ErrorCodeAndMessage(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorCodeAndMessage)) {
                return false;
            }
            ErrorCodeAndMessage other = (ErrorCodeAndMessage)o;
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "ResponseHelper.ErrorCodeAndMessage(code=" + this.getCode() + ", message=" + this.getMessage() + ")";
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private String code;
            private String message;

            Builder() {
            }

            public Builder code(String code) {
                this.code = code;
                return this;
            }

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public ErrorCodeAndMessage build() {
                return new ErrorCodeAndMessage(this.code, this.message);
            }

            public String toString() {
                return "ResponseHelper.ErrorCodeAndMessage.Builder(code=" + this.code + ", message=" + this.message + ")";
            }
        }
    }
}

