/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import java.util.Optional;
import javax.sql.DataSource;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlDialect;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.SubsetRemover;
import org.apache.drill.exec.store.jdbc.DrillJdbcConvention;
import org.apache.drill.exec.store.jdbc.JdbcCatalogSchema;
import org.apache.drill.exec.store.jdbc.JdbcDialect;
import org.apache.drill.exec.store.jdbc.JdbcStoragePlugin;

public class DefaultJdbcDialect
implements JdbcDialect {
    private final JdbcStoragePlugin plugin;
    private final SqlDialect dialect;

    public DefaultJdbcDialect(JdbcStoragePlugin plugin, SqlDialect dialect) {
        this.plugin = plugin;
        this.dialect = dialect;
    }

    @Override
    public void registerSchemas(SchemaConfig config, SchemaPlus parent) {
        Optional<DataSource> dataSource = this.plugin.getDataSource(config.getQueryUserCredentials());
        if (!dataSource.isPresent()) {
            return;
        }
        DrillJdbcConvention convention = this.plugin.getConvention(this.dialect, config.getQueryUserCredentials());
        JdbcCatalogSchema schema = new JdbcCatalogSchema(this.plugin.getName(), dataSource.get(), this.dialect, convention, !this.plugin.getConfig().areTableNamesCaseInsensitive());
        SchemaPlus holder = parent.add(this.plugin.getName(), (Schema)schema);
        schema.setHolder(holder);
    }

    @Override
    public String generateSql(RelOptCluster cluster, RelNode input) {
        JdbcImplementor jdbcImplementor = new JdbcImplementor(this.dialect, (JavaTypeFactory)cluster.getTypeFactory());
        SqlImplementor.Result result = jdbcImplementor.visitRoot(input.accept(SubsetRemover.INSTANCE));
        return result.asStatement().toSqlString(this.dialect).getSql();
    }
}

