/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.visibility;

import java.util.Collection;
import java.util.Collections;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionAware;
import org.apache.tephra.shaded.com.google.common.primitives.Bytes;
import org.apache.tephra.shaded.com.google.common.primitives.Longs;

class ReadFence
implements TransactionAware {
    private final byte[] fenceId;
    private Transaction tx;

    public ReadFence(byte[] fenceId) {
        this.fenceId = fenceId;
    }

    public void startTx(Transaction tx) {
        this.tx = tx;
    }

    public void updateTx(Transaction tx) {
    }

    public Collection<byte[]> getTxChanges() {
        if (this.tx == null) {
            throw new IllegalStateException("Transaction has not started yet");
        }
        return Collections.singleton(Bytes.concat(this.fenceId, Longs.toByteArray(this.tx.getTransactionId())));
    }

    public boolean commitTx() throws Exception {
        return true;
    }

    public void postTxCommit() {
        this.tx = null;
    }

    public boolean rollbackTx() throws Exception {
        return true;
    }

    public String getTransactionAwareName() {
        return this.getClass().getSimpleName();
    }
}

