/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.internal.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.tephra.shaded.org.apache.twill.api.TwillRunResources;
import org.apache.tephra.shaded.org.apache.twill.api.logging.LogEntry;
import org.apache.tephra.shaded.org.apache.twill.internal.DefaultTwillRunResources;

public final class TwillRunResourcesCodec
implements JsonSerializer<TwillRunResources>,
JsonDeserializer<TwillRunResources> {
    private static final String CONTAINER_ID = "containerId";
    private static final String INSTANCE_ID = "instanceId";
    private static final String HOST = "host";
    private static final String MEMORY_MB = "memoryMB";
    private static final String VIRTUAL_CORES = "virtualCores";
    private static final String DEBUG_PORT = "debugPort";
    private static final String LOG_LEVEL = "logLevel";

    public JsonElement serialize(TwillRunResources src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty(CONTAINER_ID, src.getContainerId());
        json.addProperty(INSTANCE_ID, (Number)src.getInstanceId());
        json.addProperty(HOST, src.getHost());
        json.addProperty(MEMORY_MB, (Number)src.getMemoryMB());
        json.addProperty(VIRTUAL_CORES, (Number)src.getVirtualCores());
        if (src.getDebugPort() != null) {
            json.addProperty(DEBUG_PORT, (Number)src.getDebugPort());
        }
        if (src.getLogLevel() != null) {
            json.addProperty(LOG_LEVEL, src.getLogLevel().toString());
        }
        return json;
    }

    public TwillRunResources deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        return new DefaultTwillRunResources(jsonObj.get(INSTANCE_ID).getAsInt(), jsonObj.get(CONTAINER_ID).getAsString(), jsonObj.get(VIRTUAL_CORES).getAsInt(), jsonObj.get(MEMORY_MB).getAsInt(), jsonObj.get(HOST).getAsString(), jsonObj.has(DEBUG_PORT) ? Integer.valueOf(jsonObj.get(DEBUG_PORT).getAsInt()) : null, jsonObj.has(LOG_LEVEL) ? LogEntry.Level.valueOf(jsonObj.get(LOG_LEVEL).getAsString()) : LogEntry.Level.INFO);
    }
}

